/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.translations.libretranslate;

import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.translations.ITranslationService;
import org.fao.geonet.translations.libretranslate.LibreTranslateClient;
import org.fao.geonet.translations.libretranslate.LibreTranslateClientException;
import org.fao.geonet.translations.libretranslate.LibreTranslateResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LibreTranslateService
implements ITranslationService {
    private SettingManager settingManager;

    @Autowired
    public LibreTranslateService(SettingManager settingManager) {
        this.settingManager = settingManager;
    }

    @Override
    public String name() {
        return "LibreTranslate";
    }

    @Override
    public String translate(String text, String fromLanguage, String toLanguage) {
        try {
            LibreTranslateClient libreTranslateClient = new LibreTranslateClient(this.settingManager.getValue("system/translation/serviceUrl"), this.settingManager.getValue("system/translation/apiKey"));
            LibreTranslateResponse translateResponse = libreTranslateClient.translate(text, fromLanguage, toLanguage);
            return translateResponse.getTranslatedText();
        }
        catch (LibreTranslateClientException ex) {
            return text;
        }
    }
}

