/*
 * Decompiled with CFR 0.152.
 */
package org.postgis.binary;

import org.postgis.Geometry;
import org.postgis.GeometryCollection;
import org.postgis.LineString;
import org.postgis.LinearRing;
import org.postgis.MultiLineString;
import org.postgis.MultiPoint;
import org.postgis.MultiPolygon;
import org.postgis.Point;
import org.postgis.Polygon;
import org.postgis.binary.ByteSetter;
import org.postgis.binary.ValueSetter;

public class BinaryWriter {
    public static ValueSetter valueSetterForEndian(ByteSetter bytes, byte endian) {
        if (endian == 0) {
            return new ValueSetter.XDR(bytes);
        }
        if (endian == 1) {
            return new ValueSetter.NDR(bytes);
        }
        throw new IllegalArgumentException("Unknown Endian type:" + endian);
    }

    public synchronized String writeHexed(Geometry geom, byte REP) {
        int length = this.estimateBytes(geom);
        ByteSetter.StringByteSetter bytes = new ByteSetter.StringByteSetter(length);
        this.writeGeometry(geom, BinaryWriter.valueSetterForEndian(bytes, REP));
        return bytes.result();
    }

    public synchronized String writeHexed(Geometry geom) {
        return this.writeHexed(geom, (byte)1);
    }

    public synchronized byte[] writeBinary(Geometry geom, byte REP) {
        int length = this.estimateBytes(geom);
        ByteSetter.BinaryByteSetter bytes = new ByteSetter.BinaryByteSetter(length);
        this.writeGeometry(geom, BinaryWriter.valueSetterForEndian(bytes, REP));
        return bytes.result();
    }

    public synchronized byte[] writeBinary(Geometry geom) {
        return this.writeBinary(geom, (byte)1);
    }

    protected void writeGeometry(Geometry geom, ValueSetter dest) {
        dest.setByte(dest.endian);
        int typeword = geom.type;
        if (geom.dimension == 3) {
            typeword |= Integer.MIN_VALUE;
        }
        if (geom.haveMeasure) {
            typeword |= 0x40000000;
        }
        if (geom.srid != -1) {
            typeword |= 0x20000000;
        }
        dest.setInt(typeword);
        if (geom.srid != -1) {
            dest.setInt(geom.srid);
        }
        switch (geom.type) {
            case 1: {
                this.writePoint((Point)geom, dest);
                break;
            }
            case 2: {
                this.writeLineString((LineString)geom, dest);
                break;
            }
            case 3: {
                this.writePolygon((Polygon)geom, dest);
                break;
            }
            case 4: {
                this.writeMultiPoint((MultiPoint)geom, dest);
                break;
            }
            case 5: {
                this.writeMultiLineString((MultiLineString)geom, dest);
                break;
            }
            case 6: {
                this.writeMultiPolygon((MultiPolygon)geom, dest);
                break;
            }
            case 7: {
                this.writeCollection((GeometryCollection)geom, dest);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Geometry Type: " + geom.type);
            }
        }
    }

    private void writePoint(Point geom, ValueSetter dest) {
        dest.setDouble(geom.x);
        dest.setDouble(geom.y);
        if (geom.dimension == 3) {
            dest.setDouble(geom.z);
        }
        if (geom.haveMeasure) {
            dest.setDouble(geom.m);
        }
    }

    private void writeGeometryArray(Geometry[] container, ValueSetter dest) {
        for (int i = 0; i < container.length; ++i) {
            this.writeGeometry(container[i], dest);
        }
    }

    private void writePointArray(Point[] geom, ValueSetter dest) {
        dest.setInt(geom.length);
        for (int i = 0; i < geom.length; ++i) {
            this.writePoint(geom[i], dest);
        }
    }

    private void writeMultiPoint(MultiPoint geom, ValueSetter dest) {
        dest.setInt(geom.numPoints());
        this.writeGeometryArray(geom.getPoints(), dest);
    }

    private void writeLineString(LineString geom, ValueSetter dest) {
        this.writePointArray(geom.getPoints(), dest);
    }

    private void writeLinearRing(LinearRing geom, ValueSetter dest) {
        this.writePointArray(geom.getPoints(), dest);
    }

    private void writePolygon(Polygon geom, ValueSetter dest) {
        dest.setInt(geom.numRings());
        for (int i = 0; i < geom.numRings(); ++i) {
            this.writeLinearRing(geom.getRing(i), dest);
        }
    }

    private void writeMultiLineString(MultiLineString geom, ValueSetter dest) {
        dest.setInt(geom.numLines());
        this.writeGeometryArray(geom.getLines(), dest);
    }

    private void writeMultiPolygon(MultiPolygon geom, ValueSetter dest) {
        dest.setInt(geom.numPolygons());
        this.writeGeometryArray(geom.getPolygons(), dest);
    }

    private void writeCollection(GeometryCollection geom, ValueSetter dest) {
        dest.setInt(geom.numGeoms());
        this.writeGeometryArray(geom.getGeometries(), dest);
    }

    protected int estimateBytes(Geometry geom) {
        int result = 0;
        ++result;
        result += 4;
        if (geom.srid != -1) {
            result += 4;
        }
        switch (geom.type) {
            case 1: {
                result += this.estimatePoint((Point)geom);
                break;
            }
            case 2: {
                result += this.estimateLineString((LineString)geom);
                break;
            }
            case 3: {
                result += this.estimatePolygon((Polygon)geom);
                break;
            }
            case 4: {
                result += this.estimateMultiPoint((MultiPoint)geom);
                break;
            }
            case 5: {
                result += this.estimateMultiLineString((MultiLineString)geom);
                break;
            }
            case 6: {
                result += this.estimateMultiPolygon((MultiPolygon)geom);
                break;
            }
            case 7: {
                result += this.estimateCollection((GeometryCollection)geom);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Geometry Type: " + geom.type);
            }
        }
        return result;
    }

    private int estimatePoint(Point geom) {
        int result = 16;
        if (geom.dimension == 3) {
            result += 8;
        }
        if (geom.haveMeasure) {
            result += 8;
        }
        return result;
    }

    private int estimateGeometryArray(Geometry[] container) {
        int result = 0;
        for (int i = 0; i < container.length; ++i) {
            result += this.estimateBytes(container[i]);
        }
        return result;
    }

    private int estimatePointArray(Point[] geom) {
        int result = 4;
        if (geom.length > 0) {
            result += geom.length * this.estimatePoint(geom[0]);
        }
        return result;
    }

    private int estimateMultiPoint(MultiPoint geom) {
        int result = 4;
        if (geom.numPoints() > 0) {
            result += geom.numPoints() * this.estimateBytes(geom.getFirstPoint());
        }
        return result;
    }

    private int estimateLineString(LineString geom) {
        return this.estimatePointArray(geom.getPoints());
    }

    private int estimateLinearRing(LinearRing geom) {
        return this.estimatePointArray(geom.getPoints());
    }

    private int estimatePolygon(Polygon geom) {
        int result = 4;
        for (int i = 0; i < geom.numRings(); ++i) {
            result += this.estimateLinearRing(geom.getRing(i));
        }
        return result;
    }

    private int estimateMultiLineString(MultiLineString geom) {
        return 4 + this.estimateGeometryArray(geom.getLines());
    }

    private int estimateMultiPolygon(MultiPolygon geom) {
        return 4 + this.estimateGeometryArray(geom.getPolygons());
    }

    private int estimateCollection(GeometryCollection geom) {
        return 4 + this.estimateGeometryArray(geom.getGeometries());
    }
}

