/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import jeeves.server.sources.http.ServletPathFinder;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.Logger;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.domain.mapservices.MapService;
import org.fao.geonet.kernel.security.SecurityProviderConfiguration;
import org.fao.geonet.kernel.security.SecurityProviderUtil;
import org.fao.geonet.repository.LinkRepository;
import org.fao.geonet.repository.MetadataLinkRepository;
import org.fao.geonet.repository.specification.LinkSpecs;
import org.fao.geonet.utils.Log;
import org.mitre.dsmiley.httpproxy.ProxyServlet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.SystemEnvironmentPropertySource;
import org.springframework.security.core.context.SecurityContextHolder;

public class URITemplateProxyServlet
extends ProxyServlet {
    public static final String P_FORWARDEDHOST = "forwardHost";
    public static final String P_FORWARDEDHOSTPREFIXPATH = "forwardHostPrefixPath";
    protected static final Pattern TEMPLATE_PATTERN;
    private static final Logger LOGGER;
    private static final long serialVersionUID = 4847856943273604410L;
    private static final String P_SECURITY_MODE = "securityMode";
    private static final String P_IS_SECURED = "isSecured";
    private static final String TARGET_URI_NAME = "targetUri";
    private static final String P_EXCLUDE_HOSTS = "excludeHosts";
    private static final String P_ALLOW_PORTS = "allowPorts";
    private static final String ATTR_QUERY_STRING;
    protected boolean doForwardHost = false;
    protected String doForwardHostPrefixPath = "";
    protected boolean isSecured = false;
    protected SECURITY_MODE securityMode;
    protected String targetUriTemplate;
    @Autowired
    MetadataLinkRepository metadataLinkRepository;
    private String username;
    private String password;
    private Pattern excludeHostsPattern;
    private Set<Integer> allowPorts = new HashSet<Integer>(Arrays.asList(80, 443));

    protected void initTarget() throws ServletException {
        String additionalAllowPorts;
        String excludeHosts;
        String doIsSecured;
        this.securityMode = SECURITY_MODE.parse(this.getConfigParam(P_SECURITY_MODE));
        String doForwardHostString = this.getConfigParam(P_FORWARDEDHOST);
        if (doForwardHostString != null) {
            String doForwardHostPrefixPathString = this.getConfigParam(P_FORWARDEDHOSTPREFIXPATH);
            this.doForwardHost = Boolean.parseBoolean(doForwardHostString);
            this.doForwardHostPrefixPath = doForwardHostPrefixPathString != null ? doForwardHostPrefixPathString : "";
        }
        this.targetUriTemplate = this.getConfigValue(TARGET_URI_NAME);
        if (StringUtils.isBlank((CharSequence)this.targetUriTemplate)) {
            this.targetUriTemplate = this.getConfigParam(TARGET_URI_NAME);
            if (this.targetUriTemplate == null) {
                throw new ServletException("targetUri  is required in web.xml or set externally");
            }
        }
        this.getServletContext().setAttribute(this.getServletName() + "." + TARGET_URI_NAME, (Object)this.targetUriTemplate);
        this.username = this.getConfigValue("username");
        this.password = this.getConfigValue("password");
        if (StringUtils.isBlank((CharSequence)this.username)) {
            this.username = this.getConfigParam("username");
            this.password = this.getConfigParam("password");
        }
        if ((doIsSecured = this.getConfigParam(P_IS_SECURED)) != null) {
            this.isSecured = Boolean.parseBoolean(doIsSecured);
        }
        if (StringUtils.isBlank((CharSequence)(excludeHosts = this.getConfigValue(P_EXCLUDE_HOSTS)))) {
            excludeHosts = this.getConfigParam(P_EXCLUDE_HOSTS);
        }
        if (StringUtils.isNotBlank((CharSequence)excludeHosts)) {
            try {
                this.excludeHostsPattern = Pattern.compile(excludeHosts);
            }
            catch (PatternSyntaxException ex) {
                throw new ServletException("excludeHosts doesn't contain a valid regular expression");
            }
        }
        if (StringUtils.isBlank((CharSequence)(additionalAllowPorts = this.getConfigValue(P_ALLOW_PORTS)))) {
            additionalAllowPorts = this.getConfigParam(P_ALLOW_PORTS);
        }
        if (StringUtils.isNotBlank((CharSequence)additionalAllowPorts)) {
            Set validPorts = Arrays.stream(additionalAllowPorts.split("\\|")).filter(StringUtils::isNumeric).map(Integer::valueOf).collect(Collectors.toSet());
            this.allowPorts.addAll(validPorts);
        }
    }

    private String getConfigValue(String suffix) {
        ServletPathFinder pathFinder = new ServletPathFinder(this.getServletContext());
        String baseUrl = pathFinder.getBaseUrl();
        String webappName = "";
        if (StringUtils.isNotEmpty((CharSequence)baseUrl)) {
            webappName = baseUrl.substring(1);
        }
        LOGGER.info("Looking for " + webappName + "." + this.getServletName() + "." + suffix + " in Environment variables, System properties and config.properties entries");
        String result = this.resolveConfigValue(webappName + "." + this.getServletName() + "." + suffix);
        if (StringUtils.isBlank((CharSequence)result)) {
            LOGGER.info("Looking for geonetwork." + this.getServletName() + "." + suffix + "  in Environment variables, System properties and config.properties entries");
            result = this.resolveConfigValue("geonetwork." + this.getServletName() + "." + suffix);
        }
        return result;
    }

    private String resolveConfigValue(String propertyName) {
        String propertyValue;
        block15: {
            propertyValue = null;
            try {
                HashMap<String, String> environmentVariables = new HashMap<String, String>(System.getenv());
                SystemEnvironmentPropertySource sysEnvPropSource = new SystemEnvironmentPropertySource("environment", environmentVariables);
                propertyValue = (String)sysEnvPropSource.getProperty(propertyName);
                if (propertyValue == null) {
                    propertyValue = System.getProperties().getProperty(propertyName);
                }
                if (propertyValue != null) break block15;
                Properties configProperties = new Properties();
                try (InputStream is = this.getServletContext().getResourceAsStream("/WEB-INF/config.properties");){
                    configProperties.load(is);
                    propertyValue = configProperties.getProperty(propertyName);
                }
            }
            catch (IOException e) {
                LOGGER.error("Error initiating " + this.getServletName() + " servlet property " + propertyName);
                LOGGER.error((Throwable)e);
            }
        }
        return propertyValue;
    }

    protected HttpClient createHttpClient() {
        HttpClientBuilder clientBuilder = this.getHttpClientBuilder().setDefaultRequestConfig(this.buildRequestConfig()).setDefaultSocketConfig(this.buildSocketConfig());
        clientBuilder.setMaxConnTotal(this.maxConnections);
        clientBuilder.setMaxConnPerRoute(this.maxConnections);
        if (!this.doHandleCompression) {
            clientBuilder.disableContentCompression();
        }
        if (StringUtils.isNotEmpty((CharSequence)this.username) && StringUtils.isNotEmpty((CharSequence)this.password)) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.username, this.password));
            clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        clientBuilder = clientBuilder.useSystemProperties();
        return this.buildHttpClient(clientBuilder);
    }

    protected HttpClient buildHttpClient(HttpClientBuilder clientBuilder) {
        return clientBuilder.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void copyRequestHeaders(HttpServletRequest servletRequest, HttpRequest proxyRequest) {
        List mapServiceList;
        Optional<MapService> result;
        super.copyRequestHeaders(servletRequest, proxyRequest);
        if (this.doForwardHost) {
            StringBuffer url = servletRequest.getRequestURL();
            String uri = servletRequest.getRequestURI();
            String host = url.substring(servletRequest.getScheme().length() + 3, url.indexOf(uri));
            proxyRequest.setHeader("X-Forwarded-Host", host);
            proxyRequest.setHeader("X-Forwarded-Proto", servletRequest.getScheme());
            proxyRequest.setHeader("X-Forwarded-Prefix", servletRequest.getContextPath() + this.doForwardHostPrefixPath);
        }
        proxyRequest.removeHeaders("Host");
        if (!StringUtils.isEmpty((CharSequence)servletRequest.getHeader("Authorization")) || !(result = (mapServiceList = (List)ApplicationContextHolder.get().getBean("securedMapServices", List.class)).stream().filter(u -> MapService.UrlType.valueOf((String)u.getUrlType()).equals((Object)MapService.UrlType.TEXT) && proxyRequest.getRequestLine().getUri().contains(u.getUrl()) || MapService.UrlType.valueOf((String)u.getUrlType()).equals((Object)MapService.UrlType.REGEXP) && proxyRequest.getRequestLine().getUri().matches(u.getUrl())).findFirst()).isPresent()) return;
        if (MapService.AuthType.valueOf((String)result.get().getAuthType()).equals((Object)MapService.AuthType.BASIC)) {
            proxyRequest.setHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString((result.get().getUsername() + ":" + result.get().getPassword()).getBytes()));
            return;
        } else {
            if (!MapService.AuthType.valueOf((String)result.get().getAuthType()).equals((Object)MapService.AuthType.BEARER)) throw new IllegalArgumentException("Unknown authentication type " + result.get().getAuthType());
            if (!SecurityContextHolder.getContext().getAuthentication().isAuthenticated()) return;
            SecurityProviderUtil securityProviderUtil = SecurityProviderConfiguration.getSecurityProviderUtil();
            if (securityProviderUtil == null) throw new IllegalArgumentException("Invalid or Unsupported authentication type " + result.get().getAuthType() + " for current security provider");
            String authenticationHeaderValue = securityProviderUtil.getSSOAuthenticationHeaderValue();
            if (StringUtils.isEmpty((CharSequence)authenticationHeaderValue)) return;
            proxyRequest.setHeader("Authorization", authenticationHeaderValue);
        }
    }

    private long getContentLength(HttpServletRequest request) {
        String contentLengthHeader = request.getHeader("Content-Length");
        return contentLengthHeader != null ? Long.parseLong(contentLengthHeader) : -1L;
    }

    protected HttpRequest newProxyRequestWithEntity(String method, String proxyRequestUri, HttpServletRequest servletRequest) throws IOException {
        BasicHttpEntityEnclosingRequest eProxyRequest = new BasicHttpEntityEnclosingRequest(method, proxyRequestUri);
        InputStreamEntity entity = new InputStreamEntity((InputStream)servletRequest.getInputStream(), this.getContentLength(servletRequest));
        if ("GET".equals(method) || !this.isSecured) {
            eProxyRequest.setEntity((HttpEntity)entity);
        } else {
            BufferedHttpEntity bufferedHttpEntity = new BufferedHttpEntity((HttpEntity)entity);
            eProxyRequest.setEntity((HttpEntity)bufferedHttpEntity);
        }
        return eProxyRequest;
    }

    protected void service(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        if (!this.isUrlAllowed(servletRequest)) {
            String message = "The proxy does not allow to access to the provided URL.";
            servletResponse.sendError(403, message);
            return;
        }
        switch (this.securityMode) {
            case NONE: {
                this.internalService(servletRequest, servletResponse);
                break;
            }
            case DB_LINK_CHECK: {
                boolean proxyCallAllowed = false;
                try {
                    UserSession userSession = ApiUtils.getUserSession((HttpSession)servletRequest.getSession());
                    if (userSession.isAuthenticated()) {
                        proxyCallAllowed = true;
                    }
                }
                catch (SecurityException securityException) {
                    servletResponse.sendError(403, securityException.getMessage());
                    return;
                }
                if (!proxyCallAllowed) {
                    try {
                        URI uri = new URI(servletRequest.getParameter("url"));
                        String host = uri.getHost();
                        LinkRepository linkRepository = (LinkRepository)ApplicationContextHolder.get().getBean(LinkRepository.class);
                        long linksFound = linkRepository.count(LinkSpecs.filter((String)host, null, null, null, null, null));
                        if (linksFound == 0L) {
                            String message = "The proxy does not allow to access the requested URI because the URL host was not registered in any metadata records.";
                            if (linkRepository.count() == 0L) {
                                message = "The proxy is configured with DB_LINK_CHECK mode but the MetadataLink table is empty. Administrator may need to analyze record links from the admin console in order to register URL allowed by the proxy.";
                            }
                            servletResponse.sendError(403, message);
                            return;
                        }
                        proxyCallAllowed = linksFound > 0L;
                    }
                    catch (URISyntaxException e) {
                        throw new IllegalArgumentException(String.format("The provided URL is invalid. Error is: '%s'", e.getMessage()));
                    }
                }
                if (!proxyCallAllowed) break;
                this.internalService(servletRequest, servletResponse);
            }
        }
    }

    private boolean isUrlAllowed(HttpServletRequest servletRequest) {
        String url = servletRequest.getParameter("url");
        if (StringUtils.isBlank((CharSequence)url)) {
            return true;
        }
        try {
            Matcher matcher;
            URI uri = new URI(url);
            if (this.excludeHostsPattern != null && (matcher = this.excludeHostsPattern.matcher(uri.getHost())).matches()) {
                return false;
            }
            int port = uri.getPort();
            return port == -1 || this.allowPorts.contains(port);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("The provided URL is invalid. Error is: '%s'", e.getMessage()));
        }
    }

    private void internalService(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        URI targetUriObj;
        List pairs;
        int hash;
        String requestQueryString = servletRequest.getQueryString();
        String queryString = "";
        if (requestQueryString != null) {
            queryString = "?" + requestQueryString;
        }
        if ((hash = queryString.indexOf(35)) >= 0) {
            queryString = queryString.substring(0, hash);
        }
        try {
            pairs = URLEncodedUtils.parse((URI)new URI(queryString), (Charset)StandardCharsets.UTF_8);
        }
        catch (URISyntaxException e) {
            throw new ServletException("Unexpected URI parsing error on " + queryString, (Throwable)e);
        }
        LinkedHashMap<String, List> params = new LinkedHashMap<String, List>();
        for (NameValuePair pair : pairs) {
            params.computeIfAbsent(pair.getName(), k -> new ArrayList()).add(pair.getValue());
        }
        StringBuffer urlBuf = new StringBuffer();
        Matcher matcher = TEMPLATE_PATTERN.matcher(this.targetUriTemplate);
        while (matcher.find()) {
            String arg = matcher.group(1);
            List replacementValues = (List)params.remove(arg);
            if (replacementValues == null) {
                throw new ServletException("Missing HTTP parameter " + arg + " to fill the template");
            }
            String replacement = String.join((CharSequence)",", replacementValues);
            matcher.appendReplacement(urlBuf, replacement);
        }
        matcher.appendTail(urlBuf);
        String newTargetUri = urlBuf.toString();
        servletRequest.setAttribute(ATTR_TARGET_URI, (Object)newTargetUri);
        try {
            targetUriObj = new URI(newTargetUri);
        }
        catch (Exception e) {
            throw new ServletException("Rewritten targetUri is invalid: " + newTargetUri, (Throwable)e);
        }
        servletRequest.setAttribute(ATTR_TARGET_HOST, (Object)URIUtils.extractHost((URI)targetUriObj));
        StringBuilder newQueryBuf = new StringBuilder(queryString.length());
        for (Map.Entry nameVal : params.entrySet()) {
            for (String name : (List)nameVal.getValue()) {
                if (newQueryBuf.length() > 0) {
                    newQueryBuf.append('&');
                }
                newQueryBuf.append((String)nameVal.getKey()).append('=');
                if (name == null) continue;
                newQueryBuf.append(URLEncoder.encode(name, StandardCharsets.UTF_8.name()));
            }
        }
        servletRequest.setAttribute(ATTR_QUERY_STRING, (Object)newQueryBuf.toString());
        super.service(servletRequest, servletResponse);
    }

    protected String rewriteQueryStringFromRequest(HttpServletRequest servletRequest, String queryString) {
        return (String)servletRequest.getAttribute(ATTR_QUERY_STRING);
    }

    static {
        String[] headers;
        TEMPLATE_PATTERN = Pattern.compile("\\{(.+?)\\}");
        LOGGER = Log.createLogger((String)"URITemplateProxyServlet");
        ATTR_QUERY_STRING = URITemplateProxyServlet.class.getSimpleName() + ".queryString";
        for (String header : headers = new String[]{"X-XSRF-TOKEN", "Access-Control-Allow-Origin", "Vary", "Access-Control-Allow-Credentials", "Strict-Transport-Security", "Etag"}) {
            hopByHopHeaders.addHeader((Header)new BasicHeader(header, null));
        }
    }

    private static enum SECURITY_MODE {
        NONE,
        DB_LINK_CHECK;


        public static SECURITY_MODE parse(String value) {
            if ("DB_LINK_CHECK".equals(value)) {
                return DB_LINK_CHECK;
            }
            return NONE;
        }
    }
}

