/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.harvesting;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.Util;
import org.fao.geonet.repository.HarvestHistoryRepository;
import org.fao.geonet.repository.specification.HarvestHistorySpecs;
import org.fao.geonet.utils.Log;
import org.jdom.Element;
import org.springframework.data.jpa.domain.Specification;

public class HistoryDelete
implements Service {
    public void init(Path appPath, ServiceConfig config) throws Exception {
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        long nrRecs = 0L;
        HarvestHistoryRepository historyRepository = (HarvestHistoryRepository)context.getBean(HarvestHistoryRepository.class);
        String uuid = Util.getParam((Element)params, (String)"uuid");
        if (uuid != null) {
            Specification hasHarvesterUuid = HarvestHistorySpecs.hasHarvesterUuid((String)uuid);
            nrRecs = historyRepository.count(hasHarvesterUuid);
            historyRepository.deleteAll(hasHarvesterUuid);
        } else {
            Collection ids = Collections2.transform((Collection)params.getChildren("id"), (Function)new Function<Object, Integer>(){

                @Nullable
                public Integer apply(@Nonnull Object input) {
                    return Integer.valueOf(((Element)input).getText());
                }
            });
            List files = params.getChildren("file");
            for (Element file : files) {
                try {
                    File f = new File(file.getTextTrim());
                    if (!f.exists() || !f.canWrite() || f.delete()) continue;
                    Log.warning((String)"geonetwork.harvester", (Object)("Removing history. Failed to delete file: " + f.getCanonicalPath()));
                }
                catch (Exception e) {
                    Log.error((String)"geonetwork.harvester", (String)e.getMessage(), (Throwable)e);
                }
            }
            if (!ids.isEmpty()) {
                nrRecs = historyRepository.deleteAllById(ids);
            }
        }
        return new Element("response").setText(nrRecs + "");
    }
}

