/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.arcsde;

import org.fao.geonet.arcgis.ArcSDEApiConnection;
import org.fao.geonet.arcgis.ArcSDEConnection;
import org.fao.geonet.arcgis.ArcSDEConnectionException;
import org.fao.geonet.arcgis.ArcSDEOracleJdbcConnection;
import org.fao.geonet.arcgis.ArcSDEPostgresJdbcConnection;
import org.fao.geonet.arcgis.ArcSDESqlServerJdbcConnection;
import org.fao.geonet.kernel.harvest.harvester.arcsde.ArcSDEConnectionType;
import org.springframework.stereotype.Component;

@Component
public class ArcSDEConnectionFactory {
    public ArcSDEConnection getConnection(ArcSDEConnectionType connectionType, String dbType, String server, int port, String database, String username, String password) throws ArcSDEConnectionException {
        ArcSDEApiConnection connection;
        switch (connectionType) {
            case ARCSDE: {
                connection = new ArcSDEApiConnection(server, port, database, username, password);
                break;
            }
            case JDBC: {
                if (dbType.equalsIgnoreCase("oracle")) {
                    connection = new ArcSDEOracleJdbcConnection(server, port, database, username, password);
                    break;
                }
                if (dbType.equalsIgnoreCase("sqlserver")) {
                    connection = new ArcSDESqlServerJdbcConnection(server, port, database, username, password);
                    break;
                }
                if (dbType.equalsIgnoreCase("postgresql")) {
                    connection = new ArcSDEPostgresJdbcConnection(server, port, database, username, password);
                    break;
                }
                throw new ArcSDEConnectionException("ArcSDEConnectionType " + connectionType.name() + " for database type " + dbType + " not supported");
            }
            default: {
                throw new ArcSDEConnectionException("ArcSDEConnectionType " + connectionType.name() + " not supported");
            }
        }
        return connection;
    }
}

