/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.LineString;
import org.opengis.filter.capability.FunctionName;

public class FilterFunction_startAngle
extends FunctionExpressionImpl {
    public static FunctionName NAME = new FunctionNameImpl("startAngle", FunctionNameImpl.parameter("degrees", Double.class), FunctionNameImpl.parameter("linestring", LineString.class));

    public FilterFunction_startAngle() {
        super(NAME);
    }

    @Override
    public Object evaluate(Object feature) {
        LineString ls;
        try {
            ls = (LineString)this.getExpression(0).evaluate(feature, LineString.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Filter Function problem for function startAngle argument #0 - expected type Geometry");
        }
        if (ls == null || ls.getNumPoints() == 1) {
            return null;
        }
        CoordinateSequence cs = ls.getCoordinateSequence();
        double dx = cs.getX(1) - cs.getX(0);
        double dy = cs.getY(1) - cs.getY(0);
        return -Math.toDegrees(Math.atan2(dy, dx));
    }
}

