/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.vanilla;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ftp.exception.ClientException;
import org.globus.ftp.exception.ServerException;

public class TransferState {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$ftp$vanilla$TransferState == null ? (class$org$globus$ftp$vanilla$TransferState = TransferState.class$("org.globus.ftp.vanilla.TransferState")) : class$org$globus$ftp$vanilla$TransferState).getName());
    private int transferDone = 0;
    private int transferStarted = 0;
    private Exception transferException = null;
    static /* synthetic */ Class class$org$globus$ftp$vanilla$TransferState;

    public synchronized void transferStarted() {
        ++this.transferStarted;
        this.notifyAll();
    }

    public synchronized void transferDone() {
        ++this.transferDone;
        this.notifyAll();
    }

    public synchronized void transferError(Exception e) {
        logger.debug((Object)"intercepted exception", (Throwable)e);
        if (this.transferException == null) {
            this.transferException = e;
        } else if (this.transferException instanceof InterruptedException || this.transferException instanceof InterruptedIOException) {
            this.transferException = e;
        }
        this.notifyAll();
    }

    public synchronized boolean isDone() {
        return this.transferDone >= 2;
    }

    public synchronized void waitForEnd() throws ServerException, ClientException, IOException {
        try {
            while (!this.isDone()) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.checkError();
    }

    public synchronized void waitForStart() throws ServerException, ClientException, IOException {
        if (this.transferStarted >= 2) {
            this.checkError();
            return;
        }
        try {
            while (this.transferStarted != 2 && this.transferException == null) {
                this.wait();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.checkError();
    }

    public synchronized boolean hasError() {
        return this.transferException != null;
    }

    public Exception getError() {
        return this.transferException;
    }

    public void checkError() throws ServerException, ClientException, IOException {
        if (this.transferException == null) {
            return;
        }
        if (this.transferException instanceof ServerException) {
            throw (ServerException)this.transferException;
        }
        if (this.transferException instanceof IOException) {
            throw (IOException)this.transferException;
        }
        if (this.transferException instanceof InterruptedException) {
            throw new ClientException(7);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

