/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.net.InetAddress;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.SimpleMappedFieldType;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.IpFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptCompiler;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.lookup.FieldValues;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.xcontent.XContentParser;

public class IpFieldMapper
extends FieldMapper {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(IpFieldMapper.class);
    public static final String CONTENT_TYPE = "ip";
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> {
        boolean ignoreMalformedByDefault = (Boolean)IGNORE_MALFORMED_SETTING.get(c.getSettings());
        return new Builder((String)n, c.scriptCompiler(), ignoreMalformedByDefault, c.indexVersionCreated());
    });
    private final boolean indexed;
    private final boolean hasDocValues;
    private final boolean stored;
    private final boolean ignoreMalformed;
    private final boolean dimension;
    private final InetAddress nullValue;
    private final String nullValueAsString;
    private final boolean ignoreMalformedByDefault;
    private final Version indexCreatedVersion;
    private final Script script;
    private final FieldValues<InetAddress> scriptValues;
    private final ScriptCompiler scriptCompiler;

    private static IpFieldMapper toType(FieldMapper in) {
        return (IpFieldMapper)in;
    }

    private IpFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, copyTo, builder.script.get() != null, (String)builder.onScriptError.get());
        this.ignoreMalformedByDefault = builder.ignoreMalformedByDefault;
        this.indexed = (Boolean)builder.indexed.getValue();
        this.hasDocValues = (Boolean)builder.hasDocValues.getValue();
        this.stored = (Boolean)builder.stored.getValue();
        this.ignoreMalformed = (Boolean)builder.ignoreMalformed.getValue();
        this.nullValue = builder.parseNullValue();
        this.nullValueAsString = (String)builder.nullValue.getValue();
        this.indexCreatedVersion = builder.indexCreatedVersion;
        this.script = (Script)builder.script.get();
        this.scriptValues = builder.scriptValues();
        this.scriptCompiler = builder.scriptCompiler;
        this.dimension = (Boolean)builder.dimension.getValue();
    }

    boolean ignoreMalformed() {
        return this.ignoreMalformed;
    }

    @Override
    public IpFieldType fieldType() {
        return (IpFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return this.fieldType().typeName();
    }

    @Override
    protected void parseCreateField(DocumentParserContext context) throws IOException {
        InetAddress address;
        try {
            address = IpFieldMapper.value(context.parser(), this.nullValue);
        }
        catch (IllegalArgumentException e) {
            if (this.ignoreMalformed) {
                context.addIgnoredField(this.fieldType().name());
                return;
            }
            throw e;
        }
        if (address != null) {
            this.indexValue(context, address);
        }
    }

    private static InetAddress value(XContentParser parser, InetAddress nullValue) throws IOException {
        String value = parser.textOrNull();
        if (value == null) {
            return nullValue;
        }
        return InetAddresses.forString(value);
    }

    private void indexValue(DocumentParserContext context, InetAddress address) {
        if (this.indexed) {
            InetAddressPoint field = new InetAddressPoint(this.fieldType().name(), address);
            if (this.dimension) {
                if (context.doc().getByKey(this.fieldType().name()) != null) {
                    throw new IllegalArgumentException("Dimension field [" + this.fieldType().name() + "] cannot be a multi-valued field.");
                }
                context.doc().addWithKey(this.fieldType().name(), (IndexableField)field);
            } else {
                context.doc().add((IndexableField)field);
            }
        }
        if (this.hasDocValues) {
            context.doc().add((IndexableField)new SortedSetDocValuesField(this.fieldType().name(), new BytesRef(InetAddressPoint.encode((InetAddress)address))));
        } else if (this.stored || this.indexed) {
            context.addToFieldNames(this.fieldType().name());
        }
        if (this.stored) {
            context.doc().add((IndexableField)new StoredField(this.fieldType().name(), new BytesRef(InetAddressPoint.encode((InetAddress)address))));
        }
    }

    @Override
    protected void indexScriptValues(SearchLookup searchLookup, LeafReaderContext readerContext, int doc, DocumentParserContext documentParserContext) {
        this.scriptValues.valuesForDoc(searchLookup, readerContext, doc, value -> this.indexValue(documentParserContext, (InetAddress)value));
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.scriptCompiler, this.ignoreMalformedByDefault, this.indexCreatedVersion).dimension(this.dimension).init(this);
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Boolean> indexed = FieldMapper.Parameter.indexParam(m -> IpFieldMapper.access$900(IpFieldMapper.toType(m)), true);
        private final FieldMapper.Parameter<Boolean> hasDocValues = FieldMapper.Parameter.docValuesParam(m -> IpFieldMapper.access$800(IpFieldMapper.toType(m)), true);
        private final FieldMapper.Parameter<Boolean> stored = FieldMapper.Parameter.storeParam(m -> IpFieldMapper.access$700(IpFieldMapper.toType(m)), false);
        private final FieldMapper.Parameter<Boolean> ignoreMalformed;
        private final FieldMapper.Parameter<String> nullValue = FieldMapper.Parameter.stringParam("null_value", false, m -> IpFieldMapper.access$600(IpFieldMapper.toType(m)), null).acceptsNull();
        private final FieldMapper.Parameter<Script> script = FieldMapper.Parameter.scriptParam(m -> IpFieldMapper.access$500(IpFieldMapper.toType(m)));
        private final FieldMapper.Parameter<String> onScriptError = FieldMapper.Parameter.onScriptErrorParam(m -> IpFieldMapper.toType((FieldMapper)m).onScriptError, this.script);
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final FieldMapper.Parameter<Boolean> dimension;
        private final boolean ignoreMalformedByDefault;
        private final Version indexCreatedVersion;
        private final ScriptCompiler scriptCompiler;

        public Builder(String name, ScriptCompiler scriptCompiler, boolean ignoreMalformedByDefault, Version indexCreatedVersion) {
            super(name);
            this.scriptCompiler = Objects.requireNonNull(scriptCompiler);
            this.ignoreMalformedByDefault = ignoreMalformedByDefault;
            this.indexCreatedVersion = indexCreatedVersion;
            this.ignoreMalformed = FieldMapper.Parameter.boolParam("ignore_malformed", true, m -> IpFieldMapper.toType(m).ignoreMalformed, ignoreMalformedByDefault);
            this.script.precludesParameters(this.nullValue, this.ignoreMalformed);
            this.addScriptValidation(this.script, this.indexed, this.hasDocValues);
            this.dimension = TimeSeriesParams.dimensionParam(m -> IpFieldMapper.toType(m).dimension).addValidator(v -> {
                if (!(!v.booleanValue() || this.indexed.getValue().booleanValue() && this.hasDocValues.getValue().booleanValue())) {
                    throw new IllegalArgumentException("Field [time_series_dimension] requires that [" + this.indexed.name + "] and [" + this.hasDocValues.name + "] are true");
                }
            });
        }

        Builder nullValue(String nullValue) {
            this.nullValue.setValue(nullValue);
            return this;
        }

        public Builder dimension(boolean dimension) {
            this.dimension.setValue(dimension);
            return this;
        }

        private InetAddress parseNullValue() {
            String nullValueAsString = this.nullValue.getValue();
            if (nullValueAsString == null) {
                return null;
            }
            try {
                return InetAddresses.forString(nullValueAsString);
            }
            catch (Exception e) {
                DEPRECATION_LOGGER.critical(DeprecationCategory.MAPPINGS, "ip_mapper_null_field", "Error parsing [" + this.nullValue.getValue() + "] as IP in [null_value] on field [" + this.name() + "]); [null_value] will be ignored", new Object[0]);
                return null;
            }
        }

        private FieldValues<InetAddress> scriptValues() {
            if (this.script.get() == null) {
                return null;
            }
            IpFieldScript.Factory factory = this.scriptCompiler.compile(this.script.get(), IpFieldScript.CONTEXT);
            return factory == null ? null : (lookup, ctx, doc, consumer) -> factory.newFactory(this.name, this.script.get().getParams(), lookup).newInstance(ctx).runForDoc(doc, consumer);
        }

        @Override
        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.indexed, this.hasDocValues, this.stored, this.ignoreMalformed, this.nullValue, this.script, this.onScriptError, this.meta, this.dimension);
        }

        @Override
        public IpFieldMapper build(MapperBuilderContext context) {
            return new IpFieldMapper(this.name, (MappedFieldType)new IpFieldType(context.buildFullName(this.name), this.indexed.getValue(), this.stored.getValue(), this.hasDocValues.getValue(), this.parseNullValue(), this.scriptValues(), this.meta.getValue(), this.dimension.getValue()), this.multiFieldsBuilder.build(this, context), this.copyTo.build(), this);
        }
    }

    public static final class IpFieldType
    extends SimpleMappedFieldType {
        private final InetAddress nullValue;
        private final FieldValues<InetAddress> scriptValues;
        private final boolean isDimension;

        public IpFieldType(String name, boolean indexed, boolean stored, boolean hasDocValues, InetAddress nullValue, FieldValues<InetAddress> scriptValues, Map<String, String> meta, boolean isDimension) {
            super(name, indexed, stored, hasDocValues, TextSearchInfo.SIMPLE_MATCH_WITHOUT_TERMS, meta);
            this.nullValue = nullValue;
            this.scriptValues = scriptValues;
            this.isDimension = isDimension;
        }

        public IpFieldType(String name) {
            this(name, true, false, true, null, null, Collections.emptyMap(), false);
        }

        @Override
        public String typeName() {
            return IpFieldMapper.CONTENT_TYPE;
        }

        private static InetAddress parse(Object value) {
            if (value instanceof InetAddress) {
                return (InetAddress)value;
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return InetAddresses.forString(value.toString());
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            if (this.scriptValues != null) {
                return FieldValues.valueFetcher(this.scriptValues, v -> InetAddresses.toAddrString((InetAddress)v), context);
            }
            return new SourceValueFetcher(this.name(), context, this.nullValue){

                @Override
                protected Object parseSourceValue(Object value) {
                    InetAddress address = value instanceof InetAddress ? (InetAddress)value : InetAddresses.forString(value.toString());
                    return InetAddresses.toAddrString(address);
                }
            };
        }

        @Override
        public Query termQuery(Object value, @Nullable SearchExecutionContext context) {
            String term;
            this.failIfNotIndexed();
            if (value instanceof InetAddress) {
                return InetAddressPoint.newExactQuery((String)this.name(), (InetAddress)((InetAddress)value));
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            if ((term = value.toString()).contains("/")) {
                Tuple<InetAddress, Integer> cidr = InetAddresses.parseCidr(term);
                return InetAddressPoint.newPrefixQuery((String)this.name(), (InetAddress)((InetAddress)cidr.v1()), (int)((Integer)cidr.v2()));
            }
            InetAddress address = InetAddresses.forString(term);
            return InetAddressPoint.newExactQuery((String)this.name(), (InetAddress)address);
        }

        @Override
        public Query termsQuery(Collection<?> values, SearchExecutionContext context) {
            InetAddress[] addresses = new InetAddress[values.size()];
            int i = 0;
            for (Object value : values) {
                InetAddress address;
                if (value instanceof InetAddress) {
                    address = (InetAddress)value;
                } else {
                    if (value instanceof BytesRef) {
                        value = ((BytesRef)value).utf8ToString();
                    }
                    if (value.toString().contains("/")) {
                        return super.termsQuery(values, context);
                    }
                    address = InetAddresses.forString(value.toString());
                }
                addresses[i++] = address;
            }
            return InetAddressPoint.newSetQuery((String)this.name(), (InetAddress[])addresses);
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, SearchExecutionContext context) {
            this.failIfNotIndexed();
            return IpFieldType.rangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, (lower, upper) -> InetAddressPoint.newRangeQuery((String)this.name(), (InetAddress)lower, (InetAddress)upper));
        }

        public static Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, BiFunction<InetAddress, InetAddress, Query> builder) {
            InetAddress upper;
            InetAddress lower;
            if (lowerTerm == null) {
                lower = InetAddressPoint.MIN_VALUE;
            } else {
                lower = IpFieldType.parse(lowerTerm);
                if (!includeLower) {
                    if (lower.equals(InetAddressPoint.MAX_VALUE)) {
                        return new MatchNoDocsQuery();
                    }
                    lower = InetAddressPoint.nextUp((InetAddress)lower);
                }
            }
            if (upperTerm == null) {
                upper = InetAddressPoint.MAX_VALUE;
            } else {
                upper = IpFieldType.parse(upperTerm);
                if (!includeUpper) {
                    if (upper.equals(InetAddressPoint.MIN_VALUE)) {
                        return new MatchNoDocsQuery();
                    }
                    upper = InetAddressPoint.nextDown((InetAddress)upper);
                }
            }
            return builder.apply(lower, upper);
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new SortedSetOrdinalsIndexFieldData.Builder(this.name(), IpScriptDocValues::new, CoreValuesSourceType.IP);
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            return DocValueFormat.IP.format((BytesRef)value);
        }

        @Override
        public DocValueFormat docValueFormat(@Nullable String format, ZoneId timeZone) {
            this.checkNoFormat(format);
            this.checkNoTimeZone(timeZone);
            return DocValueFormat.IP;
        }

        @Override
        public boolean isDimension() {
            return this.isDimension;
        }

        public static final class IpScriptDocValues
        extends ScriptDocValues<String> {
            private final SortedSetDocValues in;
            private long[] ords = new long[0];
            private int count;

            public IpScriptDocValues(SortedSetDocValues in) {
                this.in = in;
            }

            @Override
            public void setNextDocId(int docId) throws IOException {
                this.count = 0;
                if (this.in.advanceExact(docId)) {
                    long ord = this.in.nextOrd();
                    while (ord != -1L) {
                        this.ords = ArrayUtil.grow((long[])this.ords, (int)(this.count + 1));
                        this.ords[this.count++] = ord;
                        ord = this.in.nextOrd();
                    }
                }
            }

            public String getValue() {
                if (this.count == 0) {
                    return null;
                }
                return this.get(0);
            }

            @Override
            public String get(int index) {
                try {
                    BytesRef encoded = this.in.lookupOrd(this.ords[index]);
                    InetAddress address = InetAddressPoint.decode((byte[])Arrays.copyOfRange(encoded.bytes, encoded.offset, encoded.offset + encoded.length));
                    return InetAddresses.toAddrString(address);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public int size() {
                return this.count;
            }
        }
    }
}

