/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.kernel.search.JSONLocCacheLoader;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.util.LocalizedEmailParameter;
import org.fao.geonet.util.MailUtil;

public class LocalizedEmailComponent {
    private final ComponentType componentType;
    private final String keyOrRawValue;
    private final KeyType keyType;
    private final ReplacementType replacementType;
    private final Map<Locale, ArrayList<LocalizedEmailParameter>> parameters;
    private Boolean compileWithIndexFields;
    private String metadataUuid;
    private Boolean replaceLinks;
    private Boolean replaceLinksWithHtmlFormat = false;

    public LocalizedEmailComponent(ComponentType componentType, String keyOrRawValue, KeyType keyType, ReplacementType replacementType) {
        this.componentType = componentType;
        this.keyOrRawValue = keyOrRawValue;
        this.keyType = keyType;
        this.replacementType = replacementType;
        this.parameters = new HashMap<Locale, ArrayList<LocalizedEmailParameter>>();
        this.compileWithIndexFields = false;
        this.metadataUuid = null;
        this.replaceLinks = false;
    }

    public void addParameters(Locale locale, LocalizedEmailParameter ... newParameters) {
        if (!this.parameters.containsKey(locale)) {
            this.parameters.put(locale, new ArrayList());
        }
        for (LocalizedEmailParameter newParameter : newParameters) {
            if (newParameter == null) {
                throw new IllegalArgumentException("Null parameter not allowed");
            }
            if (this.parameters.get(locale).stream().anyMatch(existingParameter -> newParameter.getId().equals(existingParameter.getId()))) {
                throw new IllegalArgumentException("Duplicate parameter id: " + newParameter.getId());
            }
            if ((this.replacementType.equals((Object)ReplacementType.POSITIONAL_FORMAT) || this.replacementType.equals((Object)ReplacementType.NUMERIC_FORMAT)) && !(newParameter.getId() instanceof Integer)) {
                throw new IllegalArgumentException("Positional parameter id must be an integer");
            }
            this.parameters.get(locale).add(newParameter);
        }
    }

    public Map<Locale, ArrayList<LocalizedEmailParameter>> getParameters() {
        return this.parameters;
    }

    public void enableCompileWithIndexFields(String metadataUuid) {
        this.compileWithIndexFields = true;
        this.metadataUuid = metadataUuid;
    }

    public void enableReplaceLinks(Boolean useHtmlFormat) {
        this.replaceLinks = true;
        this.replaceLinksWithHtmlFormat = useHtmlFormat;
    }

    public ComponentType getComponentType() {
        return this.componentType;
    }

    public String parseMessage(Locale locale) {
        String parsedMessage;
        ArrayList parametersForLocale = this.parameters.getOrDefault(locale, new ArrayList());
        switch (this.keyType) {
            case MESSAGE_OR_JSON_KEY: {
                try {
                    parsedMessage = this.getResourceBundleString(locale);
                }
                catch (MissingResourceException missingResourceException) {
                    parsedMessage = this.getTranslationMapString(locale);
                }
                break;
            }
            case MESSAGE_KEY: {
                try {
                    parsedMessage = this.getResourceBundleString(locale);
                }
                catch (MissingResourceException e) {
                    parsedMessage = this.keyOrRawValue;
                }
                break;
            }
            case JSON_KEY: {
                parsedMessage = this.getTranslationMapString(locale);
                break;
            }
            case RAW_VALUE: {
                parsedMessage = this.keyOrRawValue;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported key type: " + (Object)((Object)this.keyType));
            }
        }
        if (this.replacementType == ReplacementType.POSITIONAL_FORMAT || this.replacementType == ReplacementType.NUMERIC_FORMAT) {
            Object[] parsedLocaleEmailParameters = parametersForLocale.stream().sorted(Comparator.comparing(parameter -> (Integer)parameter.getId())).map(parameter -> parameter.parseValue(locale)).toArray();
            if (this.replacementType == ReplacementType.POSITIONAL_FORMAT) {
                parsedMessage = String.format(parsedMessage, parsedLocaleEmailParameters);
            } else {
                if (this.replaceLinks.booleanValue()) {
                    parsedMessage = this.replaceLinks(parsedMessage);
                }
                parsedMessage = MessageFormat.format(parsedMessage, parsedLocaleEmailParameters);
            }
        } else if (this.replacementType == ReplacementType.NAMED_FORMAT) {
            for (LocalizedEmailParameter parameter2 : parametersForLocale) {
                parsedMessage = parsedMessage.replace(parameter2.getId().toString(), parameter2.parseValue(locale));
            }
        }
        if (this.replaceLinks.booleanValue()) {
            parsedMessage = this.replaceLinks(parsedMessage);
        }
        if (this.compileWithIndexFields.booleanValue() && this.metadataUuid != null) {
            parsedMessage = MailUtil.compileMessageWithIndexFields(parsedMessage, this.metadataUuid, locale.getLanguage());
        }
        return parsedMessage;
    }

    public LinkedHashMap<Locale, String> getParsedMessagesMap(Locale[] feedbackLocales) {
        return this.getParsedMessagesMap(feedbackLocales, false);
    }

    public LinkedHashMap<Locale, String> getParsedMessagesMap(Locale[] feedbackLocales, Boolean distinct) {
        LinkedHashMap<Locale, String> parsedMessages = new LinkedHashMap<Locale, String>();
        for (Locale locale : feedbackLocales) {
            String parsedMessage = this.parseMessage(locale);
            if (distinct.booleanValue() && parsedMessages.containsValue(parsedMessage)) continue;
            parsedMessages.put(locale, parsedMessage);
        }
        return parsedMessages;
    }

    private String getResourceBundleString(Locale locale) {
        return ResourceBundle.getBundle("org.fao.geonet.api.Messages", locale).getString(this.keyOrRawValue);
    }

    private String getTranslationMapString(Locale locale) {
        try {
            Object translationMap = new JSONLocCacheLoader(ApplicationContextHolder.get(), locale.getISO3Language()).call();
            return translationMap.getOrDefault(this.keyOrRawValue, this.keyOrRawValue);
        }
        catch (Exception exception) {
            return this.keyOrRawValue;
        }
    }

    private String replaceLinks(String message) {
        SettingManager settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        String newPlaceholder = this.replaceLinksWithHtmlFormat != false ? "{{index:uuid}}" : "'{{'index:uuid'}}'";
        return message.replace("{{link}}", settingManager.getNodeURL() + "api/records/" + newPlaceholder);
    }

    public static enum ReplacementType {
        POSITIONAL_FORMAT,
        NUMERIC_FORMAT,
        NAMED_FORMAT,
        NONE;

    }

    public static enum KeyType {
        MESSAGE_OR_JSON_KEY,
        MESSAGE_KEY,
        JSON_KEY,
        RAW_VALUE;

    }

    public static enum ComponentType {
        SUBJECT,
        MESSAGE,
        SALUTATION,
        NESTED;

    }
}

