/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.openidconnect;

import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.as.AuthorizationServerMetadata;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.kernel.security.openidconnect.OIDCConfiguration;
import org.fao.geonet.utils.Log;
import org.springframework.core.io.Resource;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.util.FileCopyUtils;

public class GeonetworkClientRegistrationProvider {
    public static String CLIENTREGISTRATION_NAME = "geonetwork-oidc";
    ClientRegistration clientRegistration;
    OIDCConfiguration oidcConfiguration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeonetworkClientRegistrationProvider(Resource metadataResource, String serverMetadataJsonText, String oidcMetadataConfigURL, OIDCConfiguration oidcConfiguration) throws IOException, ParseException {
        this.oidcConfiguration = oidcConfiguration;
        String clientId = oidcConfiguration.clientId;
        String clientSecret = oidcConfiguration.clientSecret;
        if (oidcMetadataConfigURL != null && oidcMetadataConfigURL.toLowerCase().startsWith("http")) {
            Log.debug((String)"geonetwork.security", (Object)("Download OIDC Configuration from -" + oidcMetadataConfigURL));
            URL url = new URL(oidcMetadataConfigURL);
            HttpURLConnection http = (HttpURLConnection)url.openConnection();
            try {
                this.clientRegistration = this.createClientRegistration(http.getInputStream(), clientId, clientSecret);
            }
            finally {
                http.disconnect();
            }
        } else if (!StringUtils.isBlank((String)serverMetadataJsonText) && serverMetadataJsonText.trim().length() > 50) {
            Log.debug((String)"geonetwork.security", (Object)"OpenID Connect - using IDP server metadata config from text");
            this.clientRegistration = this.createClientRegistration(new ByteArrayInputStream(serverMetadataJsonText.getBytes()), clientId, clientSecret);
        } else {
            Log.debug((String)"geonetwork.security", (Object)"OpenID Connect - using IDP server metadata config from resource file");
            this.clientRegistration = this.createClientRegistration(metadataResource, clientId, clientSecret);
        }
    }

    public GeonetworkClientRegistrationProvider(InputStream inputStream, OIDCConfiguration oidcConfiguration) throws IOException, ParseException {
        this.oidcConfiguration = oidcConfiguration;
        String clientId = oidcConfiguration.clientId;
        String clientSecret = oidcConfiguration.clientSecret;
        this.clientRegistration = this.createClientRegistration(inputStream, clientId, clientSecret);
    }

    public static String resourceToString(Resource resource) throws IOException {
        return GeonetworkClientRegistrationProvider.inputStreamToString(resource.getInputStream());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String inputStreamToString(InputStream inputStream) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            String string = FileCopyUtils.copyToString((Reader)reader);
            return string;
        }
    }

    private static ClientAuthenticationMethod getClientAuthenticationMethod(String issuer, List<com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod> metadataAuthMethods) {
        if (metadataAuthMethods == null || metadataAuthMethods.contains(com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod.CLIENT_SECRET_BASIC)) {
            return ClientAuthenticationMethod.BASIC;
        }
        if (metadataAuthMethods.contains(com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod.CLIENT_SECRET_POST)) {
            return ClientAuthenticationMethod.POST;
        }
        if (metadataAuthMethods.contains(com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod.NONE)) {
            return ClientAuthenticationMethod.NONE;
        }
        throw new IllegalArgumentException("Only ClientAuthenticationMethod.BASIC, ClientAuthenticationMethod.POST and ClientAuthenticationMethod.NONE are supported. The issuer \"" + issuer + "\" returned a configuration of " + metadataAuthMethods);
    }

    ClientRegistration createClientRegistration(InputStream inputStream, String clientId, String clientSecret) throws IOException, ParseException {
        return this.createClientRegistration(GeonetworkClientRegistrationProvider.inputStreamToString(inputStream), "inputstream", clientId, clientSecret);
    }

    ClientRegistration createClientRegistration(Resource metadataResource, String clientId, String clientSecret) throws IOException, ParseException {
        return this.createClientRegistration(GeonetworkClientRegistrationProvider.resourceToString(metadataResource), metadataResource.getFilename(), clientId, clientSecret);
    }

    private List<String> getScopes(AuthorizationServerMetadata metadata) {
        Scope scope = metadata.getScopes();
        ArrayList<String> scopes = scope == null ? Collections.singletonList("openid") : scope.toStringList();
        if (this.oidcConfiguration.getScopeSet() != null && !(scopes = new ArrayList<String>(this.oidcConfiguration.getScopeSet())).contains("openid")) {
            scopes.add("openid");
        }
        return scopes;
    }

    public ClientRegistration getClientRegistration() {
        return this.clientRegistration;
    }

    ClientRegistration createClientRegistration(String jsonServerConfig, String fname, String clientId, String clientSecret) throws IOException, ParseException {
        String json = jsonServerConfig;
        String issuer = "issuer: " + fname;
        OIDCProviderMetadata oidcMetadata = OIDCProviderMetadata.parse((String)json);
        ClientAuthenticationMethod method = GeonetworkClientRegistrationProvider.getClientAuthenticationMethod(issuer, oidcMetadata.getTokenEndpointAuthMethods());
        List grantTypes = oidcMetadata.getGrantTypes();
        if (grantTypes != null && !grantTypes.contains(GrantType.AUTHORIZATION_CODE)) {
            throw new IllegalArgumentException("Only AuthorizationGrantType.AUTHORIZATION_CODE is supported. The issuer \"" + issuer + "\" returned a configuration of " + grantTypes);
        }
        List<String> scopes = this.getScopes((AuthorizationServerMetadata)oidcMetadata);
        LinkedHashMap configurationMetadata = new LinkedHashMap(oidcMetadata.toJSONObject());
        ClientRegistration.Builder builder = ClientRegistration.withRegistrationId((String)CLIENTREGISTRATION_NAME).userNameAttributeName(this.oidcConfiguration.getUserNameAttribute()).scope(scopes).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).clientAuthenticationMethod(method).redirectUriTemplate("{baseUrl}/{action}/oauth2/code/{registrationId}").authorizationUri(oidcMetadata.getAuthorizationEndpointURI().toASCIIString()).providerConfigurationMetadata(configurationMetadata).tokenUri(oidcMetadata.getTokenEndpointURI().toASCIIString()).clientName(issuer);
        builder.jwkSetUri(oidcMetadata.getJWKSetURI().toASCIIString());
        if (oidcMetadata.getUserInfoEndpointURI() != null) {
            builder.userInfoUri(oidcMetadata.getUserInfoEndpointURI().toASCIIString());
        }
        builder.clientId(clientId).clientSecret(clientSecret).clientName("geonetwork via spring security");
        ClientRegistration clientRegistration = builder.build();
        return clientRegistration;
    }
}

