/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.datamanager.base;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.yammer.metrics.core.TimerContext;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import jeeves.monitor.MonitorManager;
import jeeves.monitor.timer.IndexingRecordMeter;
import jeeves.monitor.timer.IndexingRecordTimer;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import jeeves.xlink.Processor;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.records.attachments.Store;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.InspireAtomFeed;
import org.fao.geonet.domain.MetadataCategory;
import org.fao.geonet.domain.MetadataDraft;
import org.fao.geonet.domain.MetadataStatus;
import org.fao.geonet.domain.MetadataStatus_;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.domain.MetadataValidation;
import org.fao.geonet.domain.MetadataValidationStatus;
import org.fao.geonet.domain.OperationAllowed;
import org.fao.geonet.domain.OperationAllowedId;
import org.fao.geonet.domain.ReservedGroup;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.domain.Source;
import org.fao.geonet.domain.StatusValueType;
import org.fao.geonet.domain.User;
import org.fao.geonet.events.history.RecordDeletedEvent;
import org.fao.geonet.events.md.MetadataIndexCompleted;
import org.fao.geonet.events.md.MetadataIndexStarted;
import org.fao.geonet.kernel.IndexMetadataTask;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.SelectionManager;
import org.fao.geonet.kernel.SvnManager;
import org.fao.geonet.kernel.XmlSerializer;
import org.fao.geonet.kernel.datamanager.IMetadataIndexer;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.datamanager.draft.DraftMetadataIndexer;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.fao.geonet.kernel.search.IndexingMode;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.InspireAtomFeedRepository;
import org.fao.geonet.repository.MetadataStatusRepository;
import org.fao.geonet.repository.MetadataValidationRepository;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.fao.geonet.repository.SourceRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.UserSavedSelectionRepository;
import org.fao.geonet.repository.userfeedback.UserFeedbackRepository;
import org.fao.geonet.resources.Resources;
import org.fao.geonet.util.ThreadUtils;
import org.fao.geonet.utils.Log;
import org.jdom.Attribute;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

public class BaseMetadataIndexer
implements IMetadataIndexer,
ApplicationEventPublisherAware {
    @Autowired
    private EsSearchManager searchManager;
    @Autowired
    private SourceRepository sourceRepository;
    @Autowired
    protected MetadataStatusRepository statusRepository;
    @Autowired
    MonitorManager monitorManager;
    private IMetadataUtils metadataUtils;
    private IMetadataManager metadataManager;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private OperationAllowedRepository operationAllowedRepository;
    @Autowired
    private GroupRepository groupRepository;
    @Autowired
    private MetadataValidationRepository metadataValidationRepository;
    @Autowired
    private SchemaManager schemaManager;
    @Autowired(required=false)
    private SvnManager svnManager;
    @Autowired
    private InspireAtomFeedRepository inspireAtomFeedRepository;
    @Autowired(required=false)
    private XmlSerializer xmlSerializer;
    @Autowired
    @Lazy
    private SettingManager settingManager;
    @Autowired
    private UserFeedbackRepository userFeedbackRepository;
    @Autowired
    @Qualifier(value="resourceStore")
    private Store store;
    @Autowired
    private Resources resources;
    private ServiceContext servContext;
    private ApplicationEventPublisher publisher;
    @Autowired
    private UserSavedSelectionRepository userSavedSelectionRepository;
    Set<String> waitForIndexing = new HashSet<String>();
    Set<String> indexing = new HashSet<String>();
    Set<IndexMetadataTask> batchIndex = ConcurrentHashMap.newKeySet();

    @Override
    public void init(ServiceContext context, Boolean force) throws Exception {
        this.servContext = context;
    }

    @Override
    public void setMetadataUtils(IMetadataUtils metadataUtils) {
        this.metadataUtils = metadataUtils;
    }

    @Override
    public void setMetadataManager(IMetadataManager metadataManager) {
        this.metadataManager = metadataManager;
    }

    @Override
    public void forceIndexChanges() throws IOException {
        this.searchManager.forceIndexChanges();
    }

    @Override
    public int batchDeleteMetadataAndUpdateIndex(Specification<? extends AbstractMetadata> specification) throws Exception {
        List<? extends AbstractMetadata> metadataToDelete = this.metadataUtils.findAll(specification);
        metadataToDelete.forEach(md -> {
            try {
                LinkedHashMap<String, String> titles = this.metadataUtils.extractTitles(Integer.toString(md.getId()));
                UserSession userSession = ServiceContext.get().getUserSession();
                String xmlBefore = md.getData();
                this.store.delResources(ServiceContext.get(), md.getUuid());
                this.metadataManager.deleteMetadata(ServiceContext.get(), String.valueOf(md.getId()));
                new RecordDeletedEvent(Integer.valueOf(md.getId()), md.getUuid(), titles, Integer.valueOf(userSession.getUserIdAsInt()), xmlBefore).publish((ApplicationContext)ApplicationContextHolder.get());
            }
            catch (Exception e) {
                Log.warning((String)"geonetwork.datamanager", (Object)String.format("Error during removal of metadata %s part of batch delete operation. This error may create a ghost record (ie. not in the index but still present in the database). You can reindex the catalogue to see it again. Error was: %s.", md.getUuid(), e.getMessage()));
                e.printStackTrace();
            }
        });
        return metadataToDelete.size();
    }

    @Override
    public synchronized void rebuildIndexXLinkedMetadata(ServiceContext context) throws Exception {
        Set<Integer> toIndex = this.searchManager.getDocsWithXLinks();
        if (Log.isDebugEnabled((String)"geonetwork.datamanager")) {
            Log.debug((String)"geonetwork.datamanager", (Object)("Will index " + toIndex.size() + " records with XLinks"));
        }
        if (toIndex.size() > 0) {
            Processor.clearCache();
            ArrayList<String> stringIds = new ArrayList<String>();
            for (Integer id : toIndex) {
                stringIds.add(id.toString());
            }
            this.batchIndexInThreadPool(context, stringIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void rebuildIndexForSelection(ServiceContext context, String bucket, boolean clearXlink) throws Exception {
        ArrayList<String> listOfIdsToIndex = new ArrayList<String>();
        UserSession session = context.getUserSession();
        SelectionManager sm = SelectionManager.getManager(session);
        Set<String> set = sm.getSelection(bucket);
        synchronized (set) {
            for (String uuid : sm.getSelection(bucket)) {
                String id = this.metadataUtils.getMetadataId(uuid);
                if (id == null) continue;
                listOfIdsToIndex.add(id);
            }
        }
        if (Log.isDebugEnabled((String)"geonetwork.datamanager")) {
            Log.debug((String)"geonetwork.datamanager", (Object)("Will index " + listOfIdsToIndex.size() + " records from selection."));
        }
        if (listOfIdsToIndex.size() > 0) {
            if (clearXlink) {
                Processor.clearCache();
            }
            this.batchIndexInThreadPool(context, listOfIdsToIndex);
        }
    }

    @Override
    public void batchIndexInThreadPool(ServiceContext context, List<?> metadataIds) {
        TransactionStatus transactionStatus = null;
        try {
            transactionStatus = TransactionAspectSupport.currentTransactionStatus();
        }
        catch (NoTransactionException noTransactionException) {
            // empty catch block
        }
        int threadCount = ThreadUtils.getNumberOfThreads();
        ExecutorService executor = Executors.newFixedThreadPool(threadCount);
        int perThread = metadataIds.size() < threadCount ? metadataIds.size() : metadataIds.size() / threadCount;
        int index = 0;
        if (Log.isDebugEnabled((String)"geonetwork.index")) {
            Log.debug((String)"geonetwork.index", (Object)("Indexing " + metadataIds.size() + " records."));
            Log.debug((String)"geonetwork.index", (Object)metadataIds.toString());
        }
        AtomicInteger numIndexedTracker = new AtomicInteger();
        while (index < metadataIds.size()) {
            int start = index;
            int count = Math.min(perThread, metadataIds.size() - start);
            int nbRecords = start + count;
            if (Log.isDebugEnabled((String)"geonetwork.index")) {
                Log.debug((String)"geonetwork.index", (Object)("Indexing records from " + start + " to " + nbRecords));
            }
            List<?> subList = metadataIds.subList(start, nbRecords);
            if (Log.isDebugEnabled((String)"geonetwork.index")) {
                Log.debug((String)"geonetwork.index", (Object)subList.toString());
            }
            IndexMetadataTask worker = new IndexMetadataTask(context, subList, this.batchIndex, transactionStatus, numIndexedTracker);
            executor.execute(worker);
            index += count;
        }
        executor.shutdown();
    }

    @Override
    public boolean isIndexing() {
        return this.searchManager.isIndexing();
    }

    @Override
    public void indexMetadata(List<String> metadataIds) throws Exception {
        for (String metadataId : metadataIds) {
            this.indexMetadata(metadataId, true, IndexingMode.full);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void indexMetadata(String metadataId, boolean forceRefreshReaders, IndexingMode indexingMode) throws Exception {
        AbstractMetadata fullMd;
        long start;
        block60: {
            this.monitorManager.getMeter(IndexingRecordMeter.class).mark();
            TimerContext timerContext = this.monitorManager.getTimer(IndexingRecordTimer.class).time();
            start = System.currentTimeMillis();
            try {
                List validationInfo;
                Optional groupOpt;
                Optional userOpt;
                String displayOrder;
                String uuid;
                ArrayListMultimap fields = ArrayListMultimap.create();
                int id$ = Integer.parseInt(metadataId);
                Element md = this.getXmlSerializer().selectNoXLinkResolver(metadataId, true, false);
                ServiceContext serviceContext = this.getServiceContext();
                if (this.getXmlSerializer().resolveXLinks()) {
                    List<Attribute> xlinks = Processor.getXLinks(md);
                    if (xlinks.size() > 0) {
                        fields.put((Object)"_hasxlinks", (Object)true);
                        StringBuilder sb = new StringBuilder();
                        for (Attribute xlink : xlinks) {
                            fields.put((Object)"_xlink", (Object)xlink.getValue());
                        }
                        Processor.detachXLink(md, this.getServiceContext());
                    } else {
                        fields.put((Object)"_hasxlinks", (Object)false);
                    }
                } else {
                    fields.put((Object)"_hasxlinks", (Object)false);
                }
                fullMd = this.metadataUtils.findOne(id$);
                String schema = fullMd.getDataInfo().getSchemaId();
                String createDate = fullMd.getDataInfo().getCreateDate().getDateAndTime();
                String changeDate = fullMd.getDataInfo().getChangeDate().getDateAndTime();
                String source = fullMd.getSourceInfo().getSourceId();
                MetadataType metadataType = fullMd.getDataInfo().getType();
                String indexKey = uuid = fullMd.getUuid();
                if (fullMd instanceof MetadataDraft) {
                    indexKey = indexKey + "-draft";
                }
                String extra = fullMd.getDataInfo().getExtra();
                boolean isHarvested = fullMd.getHarvestInfo().isHarvested();
                String owner = String.valueOf(fullMd.getSourceInfo().getOwner());
                Integer groupOwner = fullMd.getSourceInfo().getGroupOwner();
                String popularity = String.valueOf(fullMd.getDataInfo().getPopularity());
                String rating = String.valueOf(fullMd.getDataInfo().getRating());
                String string = displayOrder = fullMd.getDataInfo().getDisplayOrder() == null ? null : String.valueOf(fullMd.getDataInfo().getDisplayOrder());
                if (Log.isDebugEnabled((String)"geonetwork.datamanager")) {
                    Log.debug((String)"geonetwork.datamanager", (Object)("record schema (" + schema + ")"));
                    Log.debug((String)"geonetwork.datamanager", (Object)("record createDate (" + createDate + ")"));
                }
                fields.put((Object)"documentStandard", (Object)schema);
                fields.put((Object)"record", (Object)"record");
                fields.put((Object)"createDate", (Object)createDate);
                fields.put((Object)"changeDate", (Object)changeDate);
                fields.put((Object)"_source", (Object)source);
                fields.put((Object)"isTemplate", (Object)metadataType.codeString);
                fields.put((Object)"uuid", (Object)uuid);
                fields.put((Object)"id", (Object)metadataId);
                fields.put((Object)"featureOfRecord", (Object)"record");
                fields.put((Object)"isHarvested", (Object)isHarvested);
                if (isHarvested) {
                    fields.put((Object)"harvesterUuid", (Object)fullMd.getHarvestInfo().getUuid());
                }
                fields.put((Object)"owner", (Object)owner);
                if (!this.schemaManager.existsSchema(schema)) {
                    fields.put((Object)"draft", (Object)"n");
                    fields.put((Object)"indexingError", (Object)true);
                    fields.put((Object)"indexingErrorMsg", (Object)String.format("Schema '%s' is not registered in this catalog. Install it or remove those records", schema));
                    this.searchManager.index(null, md, indexKey, (Multimap<String, Object>)fields, metadataType, forceRefreshReaders, indexingMode);
                    Log.error((String)"geonetwork.datamanager", (Object)String.format("Record %s / Schema '%s' is not registered in this catalog. Install it or remove those records. Record is indexed indexing error flag.", metadataId, schema));
                    break block60;
                }
                fields.put((Object)"_popularity", (Object)popularity);
                fields.put((Object)"_rating", (Object)rating);
                if ("advanced".equals(this.settingManager.getValue("system/localrating/enable"))) {
                    int nbOfFeedback = this.userFeedbackRepository.findByMetadata_Uuid(uuid).size();
                    fields.put((Object)"feedbackCount", (Object)nbOfFeedback);
                }
                fields.put((Object)"_displayOrder", (Object)displayOrder);
                fields.put((Object)"_extra", (Object)extra);
                InspireAtomFeed feed = this.inspireAtomFeedRepository.findByMetadataId(id$);
                if (feed != null && StringUtils.isNotEmpty((String)feed.getAtom())) {
                    fields.put((Object)"atomfeed", (Object)feed.getAtom());
                }
                if (owner != null && (userOpt = this.userRepository.findById((Object)fullMd.getSourceInfo().getOwner())).isPresent()) {
                    User user = (User)userOpt.get();
                    fields.put((Object)"_userinfo", (Object)(user.getUsername() + "|" + user.getSurname() + "|" + user.getName() + "|" + user.getProfile()));
                    fields.put((Object)"recordOwner", (Object)(user.getName() + " " + user.getSurname()));
                }
                String logoUUID = null;
                if (groupOwner != null && (groupOpt = this.groupRepository.findById((Object)groupOwner)).isPresent()) {
                    Group group = (Group)groupOpt.get();
                    fields.put((Object)"groupOwner", (Object)String.valueOf(groupOwner));
                    boolean preferGroup = this.settingManager.getValueAsBool("system/metadata/prefergrouplogo", true);
                    if (group.getWebsite() != null && !group.getWebsite().isEmpty() && preferGroup) {
                        fields.put((Object)"_groupWebsite", (Object)group.getWebsite());
                    }
                    if (group.getLogo() != null && preferGroup) {
                        logoUUID = group.getLogo();
                    }
                }
                boolean added = false;
                if (StringUtils.isNotEmpty(logoUUID)) {
                    Path harvesterLogosDir = this.resources.locateHarvesterLogosDir(this.getServiceContext());
                    try (Resources.ResourceHolder logo = this.resources.getImage(this.getServiceContext(), logoUUID, harvesterLogosDir);){
                        if (logo != null) {
                            added = true;
                            fields.put((Object)"_logo", (Object)("/images/harvesting/" + logo.getPath().getFileName()));
                        }
                    }
                }
                if (!added) {
                    Source sourceCatalogue = this.sourceRepository.findOneByUuid(source);
                    logoUUID = sourceCatalogue != null && StringUtils.isNotEmpty((String)sourceCatalogue.getLogo()) ? sourceCatalogue.getLogo() : source + ".png";
                    Path logosDir = this.resources.locateLogosDir(this.getServiceContext());
                    try (Resources.ResourceHolder image = this.resources.getImage(this.getServiceContext(), logoUUID, logosDir);){
                        if (image != null) {
                            fields.put((Object)"_logo", (Object)("/images/logos/" + logoUUID));
                        }
                    }
                }
                fields.putAll(this.buildFieldsForPrivileges(id$));
                for (MetadataCategory category : fullMd.getCategories()) {
                    fields.put((Object)"cat", (Object)category.getName());
                }
                Sort statusSort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{MetadataStatus_.changeDate.getName()});
                List statuses = this.statusRepository.findAllByMetadataIdAndByType(id$, StatusValueType.workflow, statusSort);
                if (!statuses.isEmpty()) {
                    MetadataStatus stat = (MetadataStatus)statuses.get(0);
                    String status = String.valueOf(stat.getStatusValue().getId());
                    fields.put((Object)"mdStatus", (Object)status);
                    String statusChangeDate = stat.getChangeDate().getDateAndTime();
                    fields.put((Object)"mdStatusChangeDate", (Object)statusChangeDate);
                }
                if ((validationInfo = this.metadataValidationRepository.findAllById_MetadataId(id$)).isEmpty()) {
                    fields.put((Object)"_valid", (Object)"-1");
                } else {
                    String isValid = "1";
                    boolean hasInspireValidation = false;
                    for (MetadataValidation vi : validationInfo) {
                        String type = vi.getId().getValidationType();
                        MetadataValidationStatus status = vi.getStatus();
                        if (!type.equalsIgnoreCase("inspire")) {
                            if (status == MetadataValidationStatus.NEVER_CALCULATED && vi.isRequired().booleanValue()) {
                                isValid = "-1";
                            }
                            if (status == MetadataValidationStatus.INVALID && vi.isRequired().booleanValue() && isValid != "-1") {
                                isValid = "0";
                            }
                        } else {
                            hasInspireValidation = true;
                            fields.put((Object)"_inspireReportUrl", (Object)vi.getReportUrl());
                            fields.put((Object)"_inspireValidationDate", (Object)vi.getValidationDate().getDateAndTime());
                        }
                        fields.put((Object)("_valid_" + type), (Object)status.getCode());
                    }
                    fields.put((Object)"_valid", (Object)isValid);
                    if (!hasInspireValidation) {
                        fields.put((Object)"_valid_inspire", (Object)"-1");
                    }
                }
                int savedCount = this.userSavedSelectionRepository.countTimesUserSavedMetadata(uuid, 0);
                fields.put((Object)"userSavedCount", (Object)savedCount);
                fields.putAll(this.addExtraFields(fullMd));
                if (fullMd != null) {
                    this.publisher.publishEvent((ApplicationEvent)new MetadataIndexStarted(fullMd, (Multimap)fields));
                }
                this.searchManager.index(this.schemaManager.getSchemaDir(schema), md, indexKey, (Multimap<String, Object>)fields, metadataType, forceRefreshReaders, indexingMode);
            }
            catch (Exception x) {
                Log.error((String)"geonetwork.datamanager", (String)("The metadata document index with id=" + metadataId + " is corrupt/invalid - ignoring it. Error: " + x.getMessage()), (Throwable)x);
                fullMd = null;
            }
            finally {
                timerContext.stop();
            }
        }
        if (fullMd != null) {
            this.publisher.publishEvent((ApplicationEvent)new MetadataIndexCompleted(fullMd));
        }
        Log.warning((String)"geonetwork.index", (Object)String.format("Record #%s (mode: %s) indexed in %dms", new Object[]{metadataId, indexingMode, System.currentTimeMillis() - start}));
    }

    @Override
    public void indexMetadataPrivileges(String uuid, int id) throws Exception {
        HashSet<String> operationFields = new HashSet<String>();
        Arrays.asList(ReservedOperation.values()).forEach(o -> operationFields.add("op" + o.getId()));
        this.searchManager.updateFields(uuid, this.buildFieldsForPrivileges(id), operationFields);
    }

    private Multimap<String, Object> buildFieldsForPrivileges(int recordId) {
        List operationsAllowed = this.operationAllowedRepository.findAllById_MetadataId(recordId);
        ArrayListMultimap privilegesFields = ArrayListMultimap.create();
        boolean isPublishedToAll = false;
        boolean isPublishedToIntranet = false;
        boolean isPublishedToGuest = false;
        for (OperationAllowed operationAllowed : operationsAllowed) {
            Optional g;
            OperationAllowedId operationAllowedId = operationAllowed.getId();
            int groupId = operationAllowedId.getGroupId();
            int operationId = operationAllowedId.getOperationId();
            privilegesFields.put((Object)("op" + operationId), (Object)String.valueOf(groupId));
            if (operationId != ReservedOperation.view.getId() || !(g = this.groupRepository.findById((Object)groupId)).isPresent()) continue;
            privilegesFields.put((Object)"groupPublished", (Object)((Group)g.get()).getName());
            privilegesFields.put((Object)"groupPublishedId", (Object)((Group)g.get()).getId());
            if (((Group)g.get()).getId() == ReservedGroup.all.getId()) {
                isPublishedToAll = true;
                continue;
            }
            if (((Group)g.get()).getId() == ReservedGroup.intranet.getId()) {
                isPublishedToIntranet = true;
                continue;
            }
            if (((Group)g.get()).getId() != ReservedGroup.guest.getId()) continue;
            isPublishedToGuest = true;
        }
        if (isPublishedToAll) {
            privilegesFields.put((Object)"isPublishedToAll", (Object)true);
        } else {
            privilegesFields.put((Object)"isPublishedToAll", (Object)false);
        }
        if (isPublishedToIntranet) {
            privilegesFields.put((Object)"isPublishedToIntranet", (Object)true);
        } else {
            privilegesFields.put((Object)"isPublishedToIntranet", (Object)false);
        }
        if (isPublishedToGuest) {
            privilegesFields.put((Object)"isPublishedToGuest", (Object)true);
        } else {
            privilegesFields.put((Object)"isPublishedToGuest", (Object)false);
        }
        return privilegesFields;
    }

    protected Multimap<String, Object> addExtraFields(AbstractMetadata fullMd) {
        ArrayListMultimap extraFields = ArrayListMultimap.create();
        if (!DraftMetadataIndexer.class.isInstance(this)) {
            extraFields.put((Object)"draft", (Object)"n");
        }
        return extraFields;
    }

    private XmlSerializer getXmlSerializer() {
        return this.xmlSerializer;
    }

    @Override
    public void versionMetadata(ServiceContext context, String id, Element md) throws Exception {
        if (this.svnManager != null) {
            this.svnManager.createMetadataDir(id, context, md);
        }
    }

    private ServiceContext getServiceContext() {
        ServiceContext context = ServiceContext.get();
        return context == null ? this.servContext : context;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }
}

