/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jeeves.server.context.ServiceContext;
import jeeves.xlink.Processor;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.Util;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.kernel.AllThesaurus;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.Thesaurus;
import org.fao.geonet.kernel.ThesaurusFinder;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataSchemaUtils;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.oaipmh.Lib;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.languages.IsoLanguagesMapper;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.openrdf.sesame.Sesame;
import org.openrdf.sesame.config.ConfigurationException;
import org.openrdf.sesame.config.RepositoryConfig;
import org.openrdf.sesame.config.SailConfig;
import org.openrdf.sesame.constants.RDFFormat;
import org.openrdf.sesame.repository.local.LocalRepository;
import org.openrdf.sesame.repository.local.LocalService;
import org.openrdf.sesame.sailimpl.memory.RdfSchemaRepositoryConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;

public class ThesaurusManager
implements ThesaurusFinder {
    @Autowired
    private SettingManager settingManager;
    @Autowired
    private GeonetworkDataDirectory geonetworkDataDirectory;
    @Autowired
    private IMetadataUtils iMetadataUtils;
    @Autowired
    private IMetadataManager metadataManager;
    @Autowired
    private IsoLanguagesMapper isoLanguagesMapper;
    @Autowired
    private IMetadataSchemaUtils metadataSchemaUtils;
    @Autowired
    private AllThesaurus allThesaurus;
    private ConcurrentHashMap<String, Thesaurus> thesauriMap = new ConcurrentHashMap();
    private LocalService service = null;
    private Path thesauriDirectory = null;
    private boolean initialized = false;
    @Value(value="${thesaurus.cache.maxsize:50000}")
    private int thesaurusCacheMaxSize = 50000;

    public int getThesaurusCacheMaxSize() {
        return this.thesaurusCacheMaxSize;
    }

    public void setThesaurusCacheMaxSize(int thesaurusCacheMaxSize) {
        this.thesaurusCacheMaxSize = thesaurusCacheMaxSize;
    }

    public synchronized void init(boolean isTest, ServiceContext context, String thesauriRepository) throws Exception {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        String siteURL = this.settingManager.getSiteURL(context);
        this.allThesaurus.init(siteURL);
        this.service = Sesame.getService();
        Path thesauriDir = IO.toPath((String)thesauriRepository, (String[])new String[0]);
        if (!Files.exists(thesauriDir, new LinkOption[0])) {
            thesauriDir = this.geonetworkDataDirectory.resolveWebResource(thesauriRepository);
        }
        thesauriDir = thesauriDir.toAbsolutePath();
        this.thesauriDirectory = thesauriDir.toAbsolutePath();
        this.batchBuildTable(isTest, context, thesauriDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchBuildTable(boolean synchRun, ServiceContext context, Path thesauriDir) {
        ExecutorService executor = null;
        try {
            InitThesauriTableTask worker = new InitThesauriTableTask(context, thesauriDir);
            if (synchRun) {
                worker.run();
            } else {
                executor = Executors.newFixedThreadPool(1);
                executor.execute(worker);
            }
        }
        finally {
            if (executor != null) {
                executor.shutdown();
            }
        }
    }

    private void initThesauriTable(Path thesauriDirectory, ServiceContext context) throws IOException {
        this.thesauriMap = new ConcurrentHashMap();
        Log.info((String)"geonetwork.thesaurus-man", (Object)("Scanning " + thesauriDirectory));
        if (thesauriDirectory != null && Files.isDirectory(thesauriDirectory, new LinkOption[0])) {
            String[] types;
            for (String type : types = new String[]{"external", "local", "register"}) {
                Path externalThesauriDirectory = thesauriDirectory.resolve(type).resolve("thesauri");
                if (!Files.isDirectory(externalThesauriDirectory, new LinkOption[0])) continue;
                try (DirectoryStream<Path> paths = Files.newDirectoryStream(externalThesauriDirectory, IO.DIRECTORIES_FILTER);){
                    for (Path aRdfDataDirectory : paths) {
                        this.loadRepositories(aRdfDataDirectory, type, context);
                    }
                }
            }
        }
    }

    private void loadRepositories(Path thesauriDirectory, String root, ServiceContext context) throws IOException {
        String siteURL = this.settingManager.getSiteURL(context);
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(thesauriDirectory, "*.rdf");){
            for (Path aRdfDataFile : paths) {
                Thesaurus gst;
                String rdfFileName = aRdfDataFile.getFileName().toString();
                String thesaurusDirName = thesauriDirectory.getFileName().toString();
                if (root.equals("register")) {
                    if (Log.isDebugEnabled((String)"geonetwork.thesaurus-man")) {
                        Log.debug((String)"geonetwork.thesaurus-man", (Object)("Creating thesaurus : " + aRdfDataFile));
                    }
                    Path outputRdf = thesauriDirectory.resolve(aRdfDataFile);
                    String uuid = com.google.common.io.Files.getNameWithoutExtension((String)rdfFileName);
                    try (OutputStream outputRdfStream = Files.newOutputStream(outputRdf, new OpenOption[0]);){
                        this.getRegisterMetadataAsRdf(uuid, outputRdfStream, context);
                    }
                    catch (Exception e) {
                        Log.error((String)"geonetwork.thesaurus-man", (String)("Register thesaurus " + aRdfDataFile + " could not be read/converted from ISO19135 record in catalog - skipping"), (Throwable)e);
                        continue;
                    }
                    gst = new Thesaurus(this.isoLanguagesMapper, rdfFileName, root, thesaurusDirName, outputRdf, siteURL, this.thesaurusCacheMaxSize);
                } else {
                    gst = new Thesaurus(this.isoLanguagesMapper, rdfFileName, root, thesaurusDirName, thesauriDirectory.resolve(aRdfDataFile), siteURL, this.thesaurusCacheMaxSize);
                }
                try {
                    this.addThesaurus(gst, false);
                }
                catch (Exception e) {
                    Log.error((String)"geonetwork.thesaurus-man", (String)("Error adding thesaurus " + aRdfDataFile + ": " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    private void getRegisterMetadataAsRdf(String uuid, OutputStream os, ServiceContext context) throws Exception {
        AbstractMetadata mdInfo = this.iMetadataUtils.findOneByUuid(uuid);
        Integer id = mdInfo.getId();
        Element md = this.metadataManager.getMetadata("" + id);
        Processor.detachXLink(md, context);
        String siteURL = this.settingManager.getSiteURL(context);
        Element env = Lib.prepareTransformEnv(mdInfo.getUuid(), mdInfo.getDataInfo().getChangeDate().getDateAndTime(), "", siteURL, "");
        Element root = new Element("root");
        root.addContent((Content)md);
        root.addContent((Content)env);
        Path styleSheet = this.metadataSchemaUtils.getSchemaDir("iso19135").resolve("convert").resolve("xml_iso19135ToSKOS.xsl");
        Xml.transform((Element)root, (Path)styleSheet, (OutputStream)os);
    }

    public Path buildThesaurusFilePath(String fname, String type, String dname) throws IOException {
        Path dirPath = this.thesauriDirectory.resolve(type).resolve("thesauri").resolve(dname);
        Files.createDirectories(dirPath, new FileAttribute[0]);
        return dirPath.resolve(fname);
    }

    public void addThesaurus(Thesaurus gst, boolean writeConceptScheme) throws Exception {
        String thesaurusName = gst.getKey();
        if (Log.isDebugEnabled((String)"geonetwork.thesaurus-man")) {
            Log.debug((String)"geonetwork.thesaurus-man", (Object)("Adding thesaurus : " + thesaurusName));
        }
        if (this.existsThesaurus(thesaurusName)) {
            throw new Exception("A thesaurus exists with code " + thesaurusName);
        }
        this.createThesaurusRepository(gst);
        this.thesauriMap.put(thesaurusName, gst);
        if (writeConceptScheme) {
            gst.createConceptScheme(gst.getTitle(), gst.getMultilingualTitles(), gst.getDescription(), gst.getMultilingualDescriptions(), gst.getFname(), gst.getDname(), gst.getDefaultNamespace());
        }
    }

    public void addOrReloadThesaurus(Thesaurus gst) throws Exception {
        if (this.thesauriMap.replace(gst.getKey(), gst) != null) {
            this.service.removeRepository(gst.getKey());
        }
        this.createThesaurusRepository(gst);
        this.thesauriMap.put(gst.getKey(), gst);
        if (Log.isDebugEnabled((String)"geonetwork.thesaurus-man")) {
            Log.debug((String)"geonetwork.thesaurus-man", (Object)("Thesaurus " + gst.getKey() + " loaded."));
        }
    }

    public void remove(String name) {
        this.service.removeRepository(name);
        this.thesauriMap.remove(name);
    }

    private void createThesaurusRepository(Thesaurus gst) throws Exception {
        try {
            RepositoryConfig repConfig = new RepositoryConfig(gst.getKey());
            SailConfig syncSail = new SailConfig("org.openrdf.sesame.sailimpl.sync.SyncRdfSchemaRepository");
            RdfSchemaRepositoryConfig memSail = new RdfSchemaRepositoryConfig(gst.getFile().toAbsolutePath().toString(), RDFFormat.RDFXML);
            repConfig.addSail(syncSail);
            repConfig.addSail((SailConfig)memSail);
            repConfig.setWorldReadable(true);
            repConfig.setWorldWriteable(true);
            LocalRepository thesaurusRepository = this.service.createRepository(repConfig);
            gst.setRepository(thesaurusRepository);
        }
        catch (ConfigurationException e) {
            Log.error((String)"geonetwork.thesaurus-man", (String)"Create Thesaurus Repository error", (Throwable)e);
            throw e;
        }
    }

    public Path getThesauriDirectory() {
        return this.thesauriDirectory;
    }

    @Override
    public Map<String, Thesaurus> getThesauriMap() {
        if (this.settingManager.getValueAsBool("system/metadata/allThesaurus")) {
            HashMap all = Maps.newHashMap(this.thesauriMap);
            all.put(this.allThesaurus.getKey(), this.allThesaurus);
            return all;
        }
        return Collections.unmodifiableMap(this.thesauriMap);
    }

    @Override
    @Nullable
    public Thesaurus getThesaurusByName(@Nonnull String thesaurusName) {
        return this.getThesauriMap().get(thesaurusName);
    }

    @Override
    public Thesaurus getThesaurusByConceptScheme(String uri) {
        for (Map.Entry<String, Thesaurus> entry : this.getThesauriMap().entrySet()) {
            try {
                Thesaurus thesaurus = entry.getValue();
                if (!thesaurus.hasConceptScheme(uri)) continue;
                return thesaurus;
            }
            catch (Exception e) {
                Log.error((String)"geonetwork.thesaurus-man", (String)"Get Thesaurus By Concept Scheme error", (Throwable)e);
            }
        }
        return null;
    }

    public Thesaurus getThesaurusByTitle(String title) {
        for (Map.Entry<String, Thesaurus> entry : this.getThesauriMap().entrySet()) {
            try {
                Thesaurus thesaurus = entry.getValue();
                if (!thesaurus.getTitle().equals(title)) continue;
                return thesaurus;
            }
            catch (Exception e) {
                Log.error((String)"geonetwork.thesaurus-man", (String)"Get thesaurus by title error", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public boolean existsThesaurus(String name) {
        return this.getThesauriMap().get(name) != null;
    }

    public String createUpdateThesaurusFromRegister(String uuid, String type, ServiceContext context) throws Exception {
        String root = "register";
        String aRdfDataFile = uuid + ".rdf";
        Path thesaurusFile = this.buildThesaurusFilePath(aRdfDataFile, root, type);
        String siteURL = this.settingManager.getSiteURL(context);
        Thesaurus gst = new Thesaurus(this.isoLanguagesMapper, aRdfDataFile, root, type, thesaurusFile, siteURL, this.thesaurusCacheMaxSize);
        try (OutputStream outputRdfStream = Files.newOutputStream(thesaurusFile, new OpenOption[0]);){
            this.getRegisterMetadataAsRdf(uuid, outputRdfStream, context);
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.thesaurus-man", (String)("Register thesaurus " + aRdfDataFile + " could not be read/converted from ISO19135 record in catalog - skipping"), (Throwable)e);
        }
        String theKey = gst.getKey();
        gst.retrieveThesaurusInformation();
        this.addOrReloadThesaurus(gst);
        return theKey;
    }

    public Element buildResultfromThTable(ServiceContext context) throws SQLException, JDOMException, IOException {
        Element elRoot = new Element("thesauri");
        Collection<Thesaurus> e = this.getThesauriMap().values();
        for (Thesaurus currentTh : e) {
            Map.Entry<String, String> entry22;
            Element elLoop = new Element("thesaurus");
            Element elKey = new Element("key");
            String key = currentTh.getKey();
            elKey.addContent(key);
            Element elDname = new Element("dname");
            String dname = currentTh.getDname();
            elDname.addContent(dname);
            Element description = new Element("description");
            description.addContent(currentTh.getDescription());
            Element elFname = new Element("filename");
            String fname = currentTh.getFname();
            elFname.addContent(fname);
            Element elTitle = new Element("title");
            String title = currentTh.getTitles((ApplicationContext)context.getApplicationContext()).get(context.getLanguage());
            if (title == null) {
                title = currentTh.getTitle();
            }
            elTitle.addContent(title);
            Element elMultilingualTitles = new Element("multilingualTitles");
            for (Map.Entry<String, String> entry22 : currentTh.getMultilingualTitles().entrySet()) {
                if (!StringUtils.isNotBlank((String)entry22.getValue())) continue;
                Element elMultilingualTitle = new Element("multilingualTitle");
                Element element = new Element("lang");
                element.setText((String)entry22.getKey());
                Element elMultilingualTitleTitle = new Element("title");
                elMultilingualTitleTitle.setText((String)entry22.getValue());
                elMultilingualTitle.addContent((Content)element);
                elMultilingualTitle.addContent((Content)elMultilingualTitleTitle);
                elMultilingualTitles.addContent((Content)elMultilingualTitle);
            }
            Element elDublinCoreMultilingual = new Element("dublinCoreMultilinguals");
            entry22 = currentTh.getDublinCoreMultilingual().entrySet().iterator();
            while (entry22.hasNext()) {
                Map.Entry entryLang = (Map.Entry)entry22.next();
                String string = (String)entryLang.getKey();
                for (Map.Entry entry : ((Map)entryLang.getValue()).entrySet()) {
                    if (!StringUtils.isNotBlank((String)((String)entry.getValue()))) continue;
                    Element elItem = new Element("dublinCoreMultilingual");
                    Element elLang = new Element("lang");
                    elLang.setText(string);
                    Element elTag = new Element("tag");
                    elTag.setText((String)entry.getKey());
                    Element elValue = new Element("value");
                    elValue.setText((String)entry.getValue());
                    elItem.addContent((Content)elLang);
                    elItem.addContent((Content)elTag);
                    elItem.addContent((Content)elValue);
                    elDublinCoreMultilingual.addContent((Content)elItem);
                }
            }
            Element elMultilingualDescriptions = new Element("multilingualDescriptions");
            for (Map.Entry entry : currentTh.getMultilingualDescriptions().entrySet()) {
                if (!StringUtils.isNotBlank((String)((String)entry.getValue()))) continue;
                Element elMultilingualDescription = new Element("multilingualDescription");
                Element element = new Element("lang");
                element.setText((String)entry.getKey());
                Element elMultilingualDescDesc = new Element("description");
                elMultilingualDescDesc.setText((String)entry.getValue());
                elMultilingualDescription.addContent((Content)element);
                elMultilingualDescription.addContent((Content)elMultilingualDescDesc);
                elMultilingualDescriptions.addContent((Content)elMultilingualDescription);
            }
            Element elType = new Element("type");
            String string = currentTh.getType();
            elType.addContent(string);
            Element elDate = new Element("date");
            String string2 = currentTh.getDate();
            elDate.addContent(string2);
            Element elCreatedDate = new Element("createdDate");
            String createdDate = currentTh.getCreatedDate();
            elCreatedDate.addContent(createdDate);
            Element elIssuedDate = new Element("issuedDate");
            String issuedDate = currentTh.getIssuedDate();
            elIssuedDate.addContent(issuedDate);
            Element elModifiedDate = new Element("modifiedDate");
            String modifiedDate = currentTh.getModifiedDate();
            elModifiedDate.addContent(modifiedDate);
            Element elUrl = new Element("url");
            String url = currentTh.getDownloadUrl();
            elUrl.addContent(url);
            Element elDefaultURI = new Element("defaultNamespace");
            String defaultURI = currentTh.getDefaultNamespace();
            elDefaultURI.addContent(defaultURI);
            elLoop.addContent((Content)elKey);
            elLoop.addContent((Content)elDname);
            elLoop.addContent((Content)description);
            elLoop.addContent((Content)elFname);
            elLoop.addContent((Content)elTitle);
            elLoop.addContent((Content)elMultilingualTitles);
            elLoop.addContent((Content)elDublinCoreMultilingual);
            elLoop.addContent((Content)elMultilingualDescriptions);
            elLoop.addContent((Content)elDate);
            elLoop.addContent((Content)elCreatedDate);
            elLoop.addContent((Content)elIssuedDate);
            elLoop.addContent((Content)elModifiedDate);
            elLoop.addContent((Content)elUrl);
            elLoop.addContent((Content)elDefaultURI);
            elLoop.addContent((Content)elType);
            elRoot.addContent((Content)elLoop);
        }
        return elRoot;
    }

    final class InitThesauriTableTask
    implements Runnable {
        private final ServiceContext context;
        private final Path thesauriDir;

        InitThesauriTableTask(ServiceContext context, Path thesauriDir) {
            this.context = context;
            this.thesauriDir = thesauriDir;
        }

        @Override
        public void run() {
            this.context.setAsThreadLocal();
            try {
                while (!this.context.isServletInitialized()) {
                    if (Log.isDebugEnabled((String)"geonetwork.thesaurus-man")) {
                        Log.debug((String)"geonetwork.thesaurus-man", (Object)"Waiting for servlet to finish initializing..");
                    }
                    Thread.sleep(10000L);
                }
                try {
                    ThesaurusManager.this.initThesauriTable(this.thesauriDir, this.context);
                }
                catch (Exception e) {
                    Log.error((String)"geonetwork.thesaurus-man", (Object)("Error rebuilding thesaurus table : " + e.getMessage() + "\n" + Util.getStackTrace((Throwable)e)));
                }
            }
            catch (Exception e) {
                Log.debug((String)"geonetwork.thesaurus-man", (String)"Thesaurus table rebuilding thread threw exception", (Throwable)e);
            }
        }
    }
}

