/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import jeeves.server.ServiceConfig;
import jeeves.server.sources.http.JeevesServlet;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.utils.FilePathChecker;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;

public class GeonetworkDataDirectory {
    public static final String KEY_SUFFIX = ".dir";
    public static final String GEONETWORK_DIR_KEY = "geonetwork.dir";
    public static final String GEONETWORK_BEAN_KEY = "GeonetworkDataDirectory";
    @Autowired
    SchemaManager schemaManager;
    private Path webappDir;
    private Path systemDataDir;
    private Path indexConfigDir;
    private Path configDir;
    private Path thesauriDir;
    private Path schemaPluginsDir;
    private Path metadataDataDir;
    private Path backupDir;
    private Path metadataRevisionDir;
    private Path resourcesDir;
    private Path htmlCacheDir;
    private Path uploadDir;
    private Path formatterDir;
    private Path nodeLessFiles;

    public void init(String webappName, Path webappDir, ServiceConfig handlerConfig, JeevesServlet jeevesServlet) throws IOException {
        if (Log.isDebugEnabled((String)"geonetwork.data.directory")) {
            Log.debug((String)"geonetwork.data.directory", (Object)"Check and create if needed GeoNetwork data directory");
        }
        this.webappDir = webappDir;
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        this.setDataDirectory(jeevesServlet, webappName, handlerConfig);
        if (applicationContext != null) {
            applicationContext.publishEvent((ApplicationEvent)new GeonetworkDataDirectoryInitializedEvent((ApplicationContext)applicationContext, this));
        }
    }

    public void init(String webappName, Path webappDir, Path systemDataDir, ServiceConfig handlerConfig, JeevesServlet jeevesServlet) throws IOException {
        this.systemDataDir = systemDataDir;
        this.init(webappName, webappDir, handlerConfig, jeevesServlet);
    }

    public static File getLogfile() {
        return Log.getLogfile();
    }

    private Path lookupProperty(JeevesServlet jeevesServlet, ServiceConfig handlerConfig, String key) {
        String[] typeStrs = new String[]{"Java environment variable ", "Servlet context parameter ", "Config.xml appHandler parameter", "System environment variable "};
        String dataDirStr = null;
        if (Log.isDebugEnabled((String)"geonetwork.data.directory")) {
            Log.debug((String)"geonetwork.data.directory", (Object)("lookupProperty " + key));
        }
        for (int j = 0; j < typeStrs.length && dataDirStr == null; ++j) {
            String value = null;
            String typeStr = typeStrs[j];
            String keyToUse = key;
            switch (j) {
                case 0: {
                    value = System.getProperty(keyToUse);
                    break;
                }
                case 1: {
                    if (jeevesServlet == null || (value = jeevesServlet.getInitParameter(keyToUse)) != null || jeevesServlet.getServletContext() == null) break;
                    value = jeevesServlet.getServletContext().getInitParameter(keyToUse);
                    break;
                }
                case 2: {
                    value = handlerConfig.getValue(keyToUse);
                    break;
                }
                case 3: {
                    value = System.getenv(keyToUse.replace('.', '_'));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Did not expect value: " + j);
                }
            }
            if (Log.isDebugEnabled((String)"geonetwork.data.directory")) {
                Log.debug((String)"geonetwork.data.directory", (Object)(" Found " + typeStr + "for " + keyToUse + " with value " + value));
            }
            dataDirStr = value;
        }
        return dataDirStr == null ? null : IO.toPath(dataDirStr, (String[])new String[0]);
    }

    private Path setDataDirectory(JeevesServlet jeevesServlet, String webappName, ServiceConfig handlerConfig) throws IOException {
        if (this.systemDataDir == null) {
            this.systemDataDir = this.lookupProperty(jeevesServlet, handlerConfig, webappName + KEY_SUFFIX);
        }
        if (this.systemDataDir == null) {
            this.systemDataDir = this.lookupProperty(jeevesServlet, handlerConfig, GEONETWORK_DIR_KEY);
        }
        boolean useDefaultDataDir = false;
        Log.info((String)"geonetwork.data.directory", (Object)("   - Data directory initialization: " + this.systemDataDir));
        if (this.systemDataDir == null) {
            Log.warning((String)"geonetwork.data.directory", (Object)("    - Data directory properties is not set. Use " + webappName + KEY_SUFFIX + " or " + GEONETWORK_DIR_KEY + " properties."));
            useDefaultDataDir = true;
        } else {
            try {
                Files.createDirectories(this.systemDataDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                Log.error((String)"geonetwork.data.directory", (Object)("Error creating system data directory: " + this.systemDataDir));
                useDefaultDataDir = true;
            }
            if (!Files.exists(this.systemDataDir, new LinkOption[0])) {
                Log.warning((String)"geonetwork.data.directory", (Object)"    - Data directory does not exist. Create it first.");
                useDefaultDataDir = true;
            }
            try {
                Path testFile = this.systemDataDir.resolve("testDD.txt");
                IO.touch((Path)testFile);
                Files.delete(testFile);
            }
            catch (IOException e) {
                Log.warning((String)"geonetwork.data.directory", (Object)("    - Data directory is not writable. Set read/write privileges to user starting the catalogue (ie. " + System.getProperty("user.name") + ")."));
                useDefaultDataDir = true;
            }
            if (!this.systemDataDir.isAbsolute()) {
                Log.warning((String)"geonetwork.data.directory", (Object)("    - Data directory is not an absolute path. Relative path is not recommended.\nUpdate " + webappName + KEY_SUFFIX + " or geonetwork.dir environment variable."));
            }
        }
        if (useDefaultDataDir) {
            this.systemDataDir = this.getDefaultDataDir(this.webappDir);
            Log.warning((String)"geonetwork.data.directory", (Object)("    - Data directory provided could not be used. Using default location: " + this.systemDataDir));
        }
        try {
            this.systemDataDir = this.systemDataDir.toRealPath(new LinkOption[0]);
            if (!Files.exists(this.systemDataDir, new LinkOption[0])) {
                Log.error((String)"geonetwork.data.directory", (Object)"System Data Directory does not exist");
            }
        }
        catch (IOException e) {
            Log.warning((String)"geonetwork.data.directory", (Object)("Unable to make a canonical path from: " + this.systemDataDir));
        }
        Log.info((String)"geonetwork.data.directory", (Object)("   - Data directory is: " + this.systemDataDir));
        this.indexConfigDir = this.setDir(jeevesServlet, webappName, handlerConfig, this.indexConfigDir, ".indexConfig.dir", "indexConfigDir", "config", "index");
        this.configDir = this.setDir(jeevesServlet, webappName, handlerConfig, this.configDir, ".config.dir", "configDir", "config", new String[0]);
        this.thesauriDir = this.setDir(jeevesServlet, webappName, handlerConfig, this.thesauriDir, ".codeList.dir", "codeListDir", "config", "codelist");
        this.schemaPluginsDir = this.setDir(jeevesServlet, webappName, handlerConfig, this.schemaPluginsDir, ".schema.dir", "schemaPluginsDir", "config", "schema_plugins");
        this.metadataDataDir = this.setDir(jeevesServlet, webappName, handlerConfig, this.metadataDataDir, ".data.dir", "dataDir", "data", "metadata_data");
        this.metadataRevisionDir = this.setDir(jeevesServlet, webappName, handlerConfig, this.metadataRevisionDir, ".svn.dir", "subversionPath", "data", "metadata_subversion");
        this.resourcesDir = this.setDir(jeevesServlet, webappName, handlerConfig, this.resourcesDir, ".resources.dir", "resources", "data", "resources");
        this.uploadDir = this.setDir(jeevesServlet, webappName, handlerConfig, this.uploadDir, ".upload.dir", "uploadDir", "data", "upload");
        this.formatterDir = this.setDir(jeevesServlet, webappName, handlerConfig, this.formatterDir, ".formatter.dir", "formatterPath", "data", "formatter");
        this.htmlCacheDir = this.setDir(jeevesServlet, webappName, handlerConfig, this.htmlCacheDir, ".htmlcache.dir", "htmlCacheDir", handlerConfig.getValue("resources"), "htmlcache");
        this.backupDir = this.setDir(jeevesServlet, webappName, handlerConfig, this.backupDir, ".backup.dir", "backupDir", "data", "backup");
        this.nodeLessFiles = this.setDir(jeevesServlet, webappName, handlerConfig, this.nodeLessFiles, ".node_less_files.dir", "node_less_files", "data", "node_less_files");
        handlerConfig.setValue("geonetworkDataDir", this.systemDataDir.toString());
        this.initDataDirectory();
        return this.systemDataDir;
    }

    private void initDataDirectory() throws IOException {
        Path schemaCatFile;
        block82: {
            Path dest;
            Path relativePath;
            DirectoryStream<Path> paths;
            Path logoDir;
            Object relativePath2;
            block81: {
                Path resourcesConfigDir;
                Path imagesDir;
                block80: {
                    Path mapDir;
                    Log.info((String)"geonetwork.data.directory", (Object)"   - Data directory initialization ...");
                    if (!Files.exists(this.thesauriDir, new LinkOption[0]) || IO.isEmptyDir((Path)this.thesauriDir)) {
                        Log.info((String)"geonetwork.data.directory", (Object)("     - Copying codelists directory ..." + this.thesauriDir));
                        try {
                            Path srcThesauri = this.getDefaultDataDir(this.webappDir).resolve("config").resolve("codelist");
                            IO.copyDirectoryOrFile((Path)srcThesauri, (Path)this.thesauriDir, (boolean)false);
                        }
                        catch (IOException e) {
                            Log.error((String)"geonetwork.data.directory", (String)("     - Thesaurus copy failed: " + e.getMessage()), (Throwable)e);
                        }
                    }
                    if (!Files.exists(mapDir = this.resourcesDir.resolve("map"), new LinkOption[0]) || IO.isEmptyDir((Path)mapDir)) {
                        Log.info((String)"geonetwork.data.directory", (Object)"     - Copying config-viewer-XXX.xml files ...");
                        try {
                            Path srcMap = this.webappDir.resolve("WEB-INF").resolve("data").resolve("data").resolve("resources").resolve("map");
                            if (!Files.exists(srcMap, new LinkOption[0])) break block80;
                            try (DirectoryStream<Path> paths2 = Files.newDirectoryStream(srcMap);){
                                for (Path path : paths2) {
                                    relativePath2 = srcMap.relativize(path);
                                    Path dest2 = mapDir.resolve(relativePath2.toString());
                                    if (Files.exists(dest2, new LinkOption[0])) continue;
                                    IO.copyDirectoryOrFile((Path)path, (Path)dest2, (boolean)false);
                                }
                            }
                        }
                        catch (IOException e) {
                            Log.error((String)"geonetwork.data.directory", (String)("     - config-viewer-XXX.xml copy failed: " + e.getMessage()), (Throwable)e);
                        }
                    }
                }
                if (!Files.exists(imagesDir = this.resourcesDir.resolve("images"), new LinkOption[0])) {
                    try {
                        Path srcFile = this.getDefaultDataDir(this.webappDir).resolve("data").resolve("resources").resolve("images");
                        IO.copyDirectoryOrFile((Path)srcFile, (Path)imagesDir, (boolean)false);
                    }
                    catch (IOException e) {
                        Log.info((String)"geonetwork.data.directory", (Object)("      - Error copying images folder: " + e.getMessage()));
                    }
                }
                if (!Files.exists(logoDir = this.resourcesDir.resolve("images").resolve("logos"), new LinkOption[0])) {
                    try {
                        Files.createDirectories(logoDir, new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        Log.info((String)"geonetwork.data.directory", (Object)("      - Error creating images/logos folder: " + e.getMessage()));
                    }
                }
                if (!Files.exists(resourcesConfigDir = this.resourcesDir.resolve("config"), new LinkOption[0]) || IO.isEmptyDir((Path)resourcesConfigDir)) {
                    Log.info((String)"geonetwork.data.directory", (Object)"     - Copying config ...");
                    try {
                        Files.createDirectories(resourcesConfigDir, new FileAttribute[0]);
                        Path fromDir = this.getDefaultDataDir(this.webappDir).resolve("data").resolve("resources").resolve("config");
                        if (!Files.exists(fromDir, new LinkOption[0])) break block81;
                        paths = Files.newDirectoryStream(fromDir);
                        relativePath2 = null;
                        try {
                            for (Path path : paths) {
                                relativePath = fromDir.relativize(path);
                                dest = resourcesConfigDir.resolve(relativePath.toString());
                                if (Files.exists(dest, new LinkOption[0])) continue;
                                IO.copyDirectoryOrFile((Path)path, (Path)dest, (boolean)false);
                            }
                        }
                        catch (Throwable dest2) {
                            relativePath2 = dest2;
                            throw dest2;
                        }
                        finally {
                            if (paths != null) {
                                if (relativePath2 != null) {
                                    try {
                                        paths.close();
                                    }
                                    catch (Throwable dest2) {
                                        ((Throwable)relativePath2).addSuppressed(dest2);
                                    }
                                } else {
                                    paths.close();
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        Log.error((String)"geonetwork.data.directory", (String)("     - Config copy failed: " + e.getMessage()), (Throwable)e);
                    }
                }
            }
            if (!Files.exists(logoDir = this.resourcesDir.resolve("images").resolve("harvesting"), new LinkOption[0]) || IO.isEmptyDir((Path)logoDir)) {
                Log.info((String)"geonetwork.data.directory", (Object)"     - Copying logos ...");
                try {
                    Files.createDirectories(logoDir, new FileAttribute[0]);
                    Path srcLogo = this.getDefaultDataDir(this.webappDir).resolve("data").resolve("resources").resolve("images").resolve("harvesting");
                    if (!Files.exists(srcLogo, new LinkOption[0])) break block82;
                    paths = Files.newDirectoryStream(srcLogo);
                    relativePath2 = null;
                    try {
                        for (Path path : paths) {
                            relativePath = srcLogo.relativize(path);
                            dest = logoDir.resolve(relativePath.toString());
                            if (Files.exists(dest, new LinkOption[0])) continue;
                            IO.copyDirectoryOrFile((Path)path, (Path)dest, (boolean)false);
                        }
                    }
                    catch (Throwable dest2) {
                        relativePath2 = dest2;
                        throw dest2;
                    }
                    finally {
                        if (paths != null) {
                            if (relativePath2 != null) {
                                try {
                                    paths.close();
                                }
                                catch (Throwable dest2) {
                                    ((Throwable)relativePath2).addSuppressed(dest2);
                                }
                            } else {
                                paths.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    Log.error((String)"geonetwork.data.directory", (String)("     - Logo copy failed: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        if (!Files.exists(this.indexConfigDir, new LinkOption[0]) || IO.isEmptyDir((Path)this.indexConfigDir)) {
            Log.info((String)"geonetwork.data.directory", (Object)"     - Copying index configuration in data directory ...");
            try {
                Path srcFile = this.getDefaultDataDir(this.webappDir).resolve("config").resolve("index");
                IO.copyDirectoryOrFile((Path)srcFile, (Path)this.indexConfigDir, (boolean)false);
            }
            catch (IOException e) {
                Log.info((String)"geonetwork.data.directory", (Object)("      - Error copying index configuration: " + e.getMessage()));
            }
        }
        if (!Files.exists(schemaCatFile = this.configDir.resolve("schemaplugin-uri-catalog.xml"), new LinkOption[0])) {
            Log.info((String)"geonetwork.data.directory", (Object)"     - Copying schema plugin catalogue ...");
            try {
                Path srcFile = this.webappDir.resolve("WEB-INF").resolve("schemaplugin-uri-catalog.xml");
                IO.copyDirectoryOrFile((Path)srcFile, (Path)schemaCatFile, (boolean)false);
                Path srcPluginsDir = this.getDefaultDataDir(this.webappDir).resolve("config").resolve("schema_plugins");
                try (DirectoryStream<Path> schemaPlugins = Files.newDirectoryStream(srcPluginsDir);){
                    for (Path next : schemaPlugins) {
                        Path destDir = this.schemaPluginsDir.resolve(next.getFileName().toString());
                        if (Files.exists(destDir, new LinkOption[0])) continue;
                        IO.copyDirectoryOrFile((Path)next, (Path)destDir, (boolean)false);
                    }
                }
            }
            catch (IOException e) {
                Log.info((String)"geonetwork.data.directory", (Object)("      - Error copying schema plugin catalogue: " + e.getMessage()));
            }
        }
        Log.info((String)"geonetwork.data.directory", (Object)"     - Copying encryptor.properties file...");
        try {
            Path srcEncryptorFile = this.getDefaultDataDir(this.webappDir).resolve("config").resolve("encryptor.properties");
            Path destEncryptorFile = this.configDir.resolve("encryptor.properties");
            if (!Files.exists(destEncryptorFile, new LinkOption[0])) {
                IO.copyDirectoryOrFile((Path)srcEncryptorFile, (Path)destEncryptorFile, (boolean)true);
            }
        }
        catch (IOException e) {
            Log.info((String)"geonetwork.data.directory", (Object)("      - Error copying encryptor.propeties file: " + e.getMessage()));
            throw e;
        }
        Path locDir = this.webappDir.resolve("loc");
        if (!Files.exists(locDir, new LinkOption[0])) {
            Files.createDirectories(locDir, new FileAttribute[0]);
        }
    }

    private Path getDefaultDataDir(Path webappDir) {
        return webappDir.resolve("WEB-INF").resolve("data");
    }

    private Path setDir(JeevesServlet jeevesServlet, String webappName, ServiceConfig handlerConfig, Path dir, String key, String handlerKey, String firstPathSeg, String ... otherSegments) {
        String envKey = webappName + key;
        if (dir != null) {
            if (Log.isDebugEnabled((String)"geonetwork.data.directory")) {
                Log.debug((String)"geonetwork.data.directory", (Object)("path for " + envKey + " set to " + dir.toString() + " via bean properties, not looking up"));
            }
        } else {
            dir = this.lookupProperty(jeevesServlet, handlerConfig, envKey);
        }
        if (dir == null) {
            envKey = "geonetwork" + key;
            dir = this.lookupProperty(jeevesServlet, handlerConfig, envKey);
        }
        if (dir == null) {
            dir = this.systemDataDir.resolve(firstPathSeg);
            for (String otherSegment : otherSegments) {
                dir = dir.resolve(otherSegment);
            }
        } else if (!dir.isAbsolute()) {
            Log.info((String)"geonetwork.data.directory", (Object)("    - " + envKey + " for directory " + dir + " is relative path. Use absolute path instead."));
        }
        if (handlerKey != null) {
            handlerConfig.setValue(handlerKey, dir.toString());
        }
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Log.info((String)"geonetwork.data.directory", (Object)("    - " + envKey + " is " + dir));
        return dir;
    }

    public Path getSystemDataDir() {
        return this.systemDataDir;
    }

    public void setSystemDataDir(Path systemDataDir) {
        this.systemDataDir = systemDataDir;
    }

    public Path getIndexConfigDir() {
        return this.indexConfigDir;
    }

    public void setIndexConfigDir(Path indexConfigDir) {
        this.indexConfigDir = indexConfigDir;
    }

    public Path getConfigDir() {
        return this.configDir;
    }

    public void setConfigDir(Path configDir) {
        this.configDir = configDir;
    }

    public Path getThesauriDir() {
        return this.thesauriDir;
    }

    public void setThesauriDir(Path thesauriDir) {
        this.thesauriDir = thesauriDir;
    }

    public Path getSchemaPluginsDir() {
        return this.schemaPluginsDir;
    }

    public void setSchemaPluginsDir(Path schemaPluginsDir) {
        this.schemaPluginsDir = schemaPluginsDir;
    }

    public Path getMetadataDataDir() {
        return this.metadataDataDir;
    }

    public void setMetadataDataDir(Path metadataDataDir) {
        this.metadataDataDir = metadataDataDir;
    }

    public Path getMetadataRevisionDir() {
        return this.metadataRevisionDir;
    }

    public void setMetadataRevisionDir(Path metadataRevisionDir) {
        this.metadataRevisionDir = metadataRevisionDir;
    }

    public Path getResourcesDir() {
        return this.resourcesDir;
    }

    public void setResourcesDir(Path resourcesDir) {
        this.resourcesDir = resourcesDir;
    }

    public Path getWebappDir() {
        return this.webappDir;
    }

    public Path getHtmlCacheDir() {
        return this.htmlCacheDir;
    }

    public void setHtmlCacheDir(Path htmlCacheDir) {
        this.htmlCacheDir = htmlCacheDir;
    }

    public Path getUploadDir() {
        return this.uploadDir;
    }

    public void setUploadDir(Path uploadDir) {
        this.uploadDir = uploadDir;
    }

    public Path getFormatterDir() {
        return this.formatterDir;
    }

    public void setFormatterDir(Path formatterDir) {
        this.formatterDir = formatterDir;
    }

    public Path getNodeLessFiles() {
        return this.nodeLessFiles;
    }

    public void setNodeLessFiles(Path nodeLessFiles) {
        this.nodeLessFiles = nodeLessFiles;
    }

    public Path resolveWebResource(String resourcePath) {
        if (resourcePath.charAt(0) == '/' || resourcePath.charAt(0) == '\\') {
            resourcePath = resourcePath.substring(1);
        }
        return this.webappDir.resolve(resourcePath);
    }

    public Path getBackupDir() {
        return this.backupDir;
    }

    public void setBackupDir(Path backupDir) {
        this.backupDir = backupDir;
    }

    public Path getXsltConversion(String conversionId) {
        if (conversionId.startsWith("schema:")) {
            String[] pathToken = conversionId.split(":");
            if (pathToken.length == 3) {
                String schema = pathToken[1];
                if (!this.schemaManager.existsSchema(schema)) {
                    throw new BadParameterEx(String.format("Conversion not found. Schema '%s' is not registered in this catalog.", schema));
                }
                FilePathChecker.verify((String)pathToken[2]);
                return this.getSchemaPluginsDir().resolve(pathToken[1]).resolve(pathToken[2] + ".xsl");
            }
        } else {
            FilePathChecker.verify((String)conversionId);
            return this.getWebappDir().resolve("xsl/conversion/import").resolve(conversionId + ".xsl");
        }
        return null;
    }

    public static class GeonetworkDataDirectoryInitializedEvent
    extends ApplicationEvent {
        private final ApplicationContext applicationContext;

        public GeonetworkDataDirectoryInitializedEvent(ApplicationContext context, GeonetworkDataDirectory dataDirectory) {
            super((Object)dataDirectory);
            this.applicationContext = context;
        }

        public ApplicationContext getApplicationContext() {
            return this.applicationContext;
        }

        public GeonetworkDataDirectory getSource() {
            return (GeonetworkDataDirectory)super.getSource();
        }
    }
}

