/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core.oidc;

import java.util.Map;
import org.springframework.security.oauth2.core.oidc.AddressStandardClaim;

public final class DefaultAddressStandardClaim
implements AddressStandardClaim {
    private String formatted;
    private String streetAddress;
    private String locality;
    private String region;
    private String postalCode;
    private String country;

    private DefaultAddressStandardClaim() {
    }

    @Override
    public String getFormatted() {
        return this.formatted;
    }

    @Override
    public String getStreetAddress() {
        return this.streetAddress;
    }

    @Override
    public String getLocality() {
        return this.locality;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public String getPostalCode() {
        return this.postalCode;
    }

    @Override
    public String getCountry() {
        return this.country;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !AddressStandardClaim.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        AddressStandardClaim other = (AddressStandardClaim)obj;
        if (this.getFormatted() != null ? !this.getFormatted().equals(other.getFormatted()) : other.getFormatted() != null) {
            return false;
        }
        if (this.getStreetAddress() != null ? !this.getStreetAddress().equals(other.getStreetAddress()) : other.getStreetAddress() != null) {
            return false;
        }
        if (this.getLocality() != null ? !this.getLocality().equals(other.getLocality()) : other.getLocality() != null) {
            return false;
        }
        if (this.getRegion() != null ? !this.getRegion().equals(other.getRegion()) : other.getRegion() != null) {
            return false;
        }
        if (this.getPostalCode() != null ? !this.getPostalCode().equals(other.getPostalCode()) : other.getPostalCode() != null) {
            return false;
        }
        return this.getCountry() != null ? this.getCountry().equals(other.getCountry()) : other.getCountry() == null;
    }

    public int hashCode() {
        int result = this.getFormatted() != null ? this.getFormatted().hashCode() : 0;
        result = 31 * result + (this.getStreetAddress() != null ? this.getStreetAddress().hashCode() : 0);
        result = 31 * result + (this.getLocality() != null ? this.getLocality().hashCode() : 0);
        result = 31 * result + (this.getRegion() != null ? this.getRegion().hashCode() : 0);
        result = 31 * result + (this.getPostalCode() != null ? this.getPostalCode().hashCode() : 0);
        result = 31 * result + (this.getCountry() != null ? this.getCountry().hashCode() : 0);
        return result;
    }

    public static class Builder {
        private static final String FORMATTED_FIELD_NAME = "formatted";
        private static final String STREET_ADDRESS_FIELD_NAME = "street_address";
        private static final String LOCALITY_FIELD_NAME = "locality";
        private static final String REGION_FIELD_NAME = "region";
        private static final String POSTAL_CODE_FIELD_NAME = "postal_code";
        private static final String COUNTRY_FIELD_NAME = "country";
        private String formatted;
        private String streetAddress;
        private String locality;
        private String region;
        private String postalCode;
        private String country;

        public Builder() {
        }

        public Builder(Map<String, Object> addressFields) {
            this.formatted((String)addressFields.get(FORMATTED_FIELD_NAME));
            this.streetAddress((String)addressFields.get(STREET_ADDRESS_FIELD_NAME));
            this.locality((String)addressFields.get(LOCALITY_FIELD_NAME));
            this.region((String)addressFields.get(REGION_FIELD_NAME));
            this.postalCode((String)addressFields.get(POSTAL_CODE_FIELD_NAME));
            this.country((String)addressFields.get(COUNTRY_FIELD_NAME));
        }

        public Builder formatted(String formatted) {
            this.formatted = formatted;
            return this;
        }

        public Builder streetAddress(String streetAddress) {
            this.streetAddress = streetAddress;
            return this;
        }

        public Builder locality(String locality) {
            this.locality = locality;
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            return this;
        }

        public AddressStandardClaim build() {
            DefaultAddressStandardClaim address = new DefaultAddressStandardClaim();
            address.formatted = this.formatted;
            address.streetAddress = this.streetAddress;
            address.locality = this.locality;
            address.region = this.region;
            address.postalCode = this.postalCode;
            address.country = this.country;
            return address;
        }
    }
}

