/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.cs;

import java.util.Arrays;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.referencing.cs.DirectionAlongMeridian;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;

final class ComparableAxisWrapper
implements Comparable<ComparableAxisWrapper> {
    private final CoordinateSystemAxis axis;
    private final DirectionAlongMeridian meridian;

    private ComparableAxisWrapper(CoordinateSystemAxis axis) {
        this.axis = axis;
        this.meridian = DirectionAlongMeridian.parse(axis.getDirection());
    }

    private static boolean isCompassDirection(AxisDirection direction) {
        int compass = DefaultCoordinateSystemAxis.getCompassAngle(direction, AxisDirection.NORTH);
        return compass != Integer.MIN_VALUE;
    }

    @Override
    public int compareTo(ComparableAxisWrapper other) {
        ComparableAxisWrapper that = other;
        AxisDirection d1 = this.axis.getDirection();
        AxisDirection d2 = that.axis.getDirection();
        int compass = DefaultCoordinateSystemAxis.getCompassAngle(d2, d1);
        if (compass != Integer.MIN_VALUE) {
            return compass;
        }
        if (ComparableAxisWrapper.isCompassDirection(d1)) {
            assert (!ComparableAxisWrapper.isCompassDirection(d2)) : d2;
            return -1;
        }
        if (ComparableAxisWrapper.isCompassDirection(d2)) {
            assert (!ComparableAxisWrapper.isCompassDirection(d1)) : d1;
            return 1;
        }
        if (this.meridian != null) {
            if (that.meridian != null) {
                return this.meridian.compareTo(that.meridian);
            }
            return -1;
        }
        if (that.meridian != null) {
            return 1;
        }
        return 0;
    }

    public static boolean sort(CoordinateSystemAxis ... axis) {
        Object[] wrappers = new ComparableAxisWrapper[axis.length];
        for (int i = 0; i < axis.length; ++i) {
            wrappers[i] = new ComparableAxisWrapper(axis[i]);
        }
        Arrays.sort(wrappers);
        boolean changed = false;
        for (int i = 0; i < axis.length; ++i) {
            CoordinateSystemAxis a = ((ComparableAxisWrapper)wrappers[i]).axis;
            changed |= axis[i] != a;
            axis[i] = a;
        }
        return changed;
    }
}

