/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.doi.client;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.exception.ResourceAlreadyExistException;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.constants.Geonet;
import org.fao.geonet.doi.client.DoiBuilder;
import org.fao.geonet.doi.client.DoiClientException;
import org.fao.geonet.doi.client.DoiDataciteClient;
import org.fao.geonet.doi.client.DoiMedraClient;
import org.fao.geonet.doi.client.IDoiClient;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.SchematronRequirement;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.ApplicableSchematron;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.SchematronValidator;
import org.fao.geonet.kernel.datamanager.base.BaseMetadataSchemaUtils;
import org.fao.geonet.kernel.datamanager.base.BaseMetadataUtils;
import org.fao.geonet.kernel.schema.MetadataSchema;
import org.fao.geonet.kernel.search.IndexingMode;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.SchematronRepository;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.springframework.beans.factory.annotation.Autowired;

public class DoiManager {
    private static final String DOI_ADD_XSL_PROCESS = "process/doi-add.xsl";
    private static final String DOI_REMOVE_XSL_PROCESS = "process/doi-remove.xsl";
    public static final String DATACITE_XSL_CONVERSION_FILE = "formatter/datacite/view.xsl";
    public static final String DATACITE_MEDRA_XSL_CONVERSION_FILE = "formatter/eu-po-doi/view.xsl";
    public static final String DOI_ID_PARAMETER = "doiId";
    public static final String DOI_DEFAULT_URL = "https://doi.org/";
    public static final String DOI_DEFAULT_PATTERN = "{{uuid}}";
    private IDoiClient client;
    private String doiPrefix;
    private String doiPattern;
    private String landingPageTemplate;
    private boolean initialised = false;
    private boolean isMedra = false;
    DataManager dm;
    SettingManager sm = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
    BaseMetadataSchemaUtils schemaUtils;
    @Autowired
    BaseMetadataUtils metadataUtils;
    @Autowired
    SchematronValidator validator;
    @Autowired
    DoiBuilder doiBuilder;
    @Autowired
    SchematronRepository schematronRepository;

    public DoiManager() {
        this.dm = (DataManager)ApplicationContextHolder.get().getBean(DataManager.class);
        this.schemaUtils = (BaseMetadataSchemaUtils)ApplicationContextHolder.get().getBean(BaseMetadataSchemaUtils.class);
        this.loadConfig();
    }

    public boolean isInitialised() {
        return this.initialised;
    }

    public void loadConfig() {
        this.initialised = false;
        if (this.sm != null) {
            String serverUrl = this.sm.getValue("system/publication/doi/doiurl");
            String doiPublicUrl = StringUtils.defaultIfEmpty((String)this.sm.getValue("system/publication/doi/doipublicurl"), (String)DOI_DEFAULT_URL);
            String username = this.sm.getValue("system/publication/doi/doiusername");
            String password = this.sm.getValue("system/publication/doi/doipassword");
            this.doiPrefix = this.sm.getValue("system/publication/doi/doikey");
            this.doiPattern = StringUtils.defaultIfEmpty((String)this.sm.getValue("system/publication/doi/doipattern"), (String)DOI_DEFAULT_PATTERN);
            this.landingPageTemplate = this.sm.getValue("system/publication/doi/doilandingpagetemplate");
            boolean emptyUrl = StringUtils.isEmpty((String)serverUrl);
            boolean emptyUsername = StringUtils.isEmpty((String)username);
            boolean emptyPassword = StringUtils.isEmpty((String)password);
            boolean emptyPrefix = StringUtils.isEmpty((String)this.doiPrefix);
            if (emptyUrl || emptyUsername || emptyPassword || emptyPrefix) {
                StringBuilder report = new StringBuilder("DOI configuration is not complete. Check in System Configuration to fill the DOI configuration.");
                if (emptyUrl) {
                    report.append("\n* URL MUST be set");
                }
                if (emptyUsername) {
                    report.append("\n* Username MUST be set");
                }
                if (emptyPassword) {
                    report.append("\n* Password MUST be set");
                }
                if (emptyPrefix) {
                    report.append("\n* Prefix MUST be set");
                }
                Log.warning((String)"geonetwork.doi", (Object)report.toString());
            } else {
                Log.debug((String)"geonetwork.doi", (Object)"DOI configuration looks perfect.");
                this.isMedra = serverUrl.contains("medra.org");
                this.client = this.isMedra ? new DoiMedraClient(serverUrl, username, password, doiPublicUrl) : new DoiDataciteClient(serverUrl, username, password, doiPublicUrl);
                this.initialised = true;
            }
        }
    }

    public String checkDoiUrl(AbstractMetadata metadata) {
        return this.doiBuilder.create(this.doiPattern, this.doiPrefix, metadata);
    }

    public Map<String, Boolean> check(ServiceContext serviceContext, AbstractMetadata metadata, Element dataciteMetadata) throws Exception {
        HashMap<String, Boolean> conditions = new HashMap<String, Boolean>();
        this.checkInitialised();
        conditions.put("doiConditionAPIConfigured", true);
        String doi = this.doiBuilder.create(this.doiPattern, this.doiPrefix, metadata);
        this.checkPreConditions(metadata, doi);
        conditions.put("doiConditionRecordIsPublic", true);
        conditions.put("doiConditionStandardSupportDoiCreation", true);
        Element dataciteFormatMetadata = dataciteMetadata == null ? this.convertXmlToDataCiteFormat(metadata.getDataInfo().getSchemaId(), metadata.getXmlData(false), doi) : dataciteMetadata;
        this.checkPreConditionsOnDataCite(metadata, doi, dataciteFormatMetadata, serviceContext.getLanguage());
        conditions.put("doiConditionDataCiteFormatIsValid", true);
        return conditions;
    }

    public Map<String, String> register(ServiceContext context, AbstractMetadata metadata) throws Exception {
        HashMap<String, String> doiInfo = new HashMap<String, String>(3);
        String doi = this.doiBuilder.create(this.doiPattern, this.doiPrefix, metadata);
        doiInfo.put("doi", doi);
        Element dataciteFormatMetadata = this.convertXmlToDataCiteFormat(metadata.getDataInfo().getSchemaId(), metadata.getXmlData(false), doi);
        try {
            this.check(context, metadata, dataciteFormatMetadata);
        }
        catch (ResourceAlreadyExistException ignore) {
            doiInfo.put("update", "true");
        }
        catch (Exception e) {
            throw e;
        }
        this.createDoi(context, metadata, doiInfo, dataciteFormatMetadata);
        this.checkDoiCreation(metadata, doiInfo);
        return doiInfo;
    }

    private void checkPreConditions(AbstractMetadata metadata, String doi) throws DoiClientException, IOException, JDOMException, ResourceAlreadyExistException {
        AccessManager am = (AccessManager)ApplicationContextHolder.get().getBean(AccessManager.class);
        boolean visibleToAll = false;
        try {
            visibleToAll = am.isVisibleToAll(metadata.getId() + "");
        }
        catch (Exception e) {
            throw new DoiClientException(String.format("Failed to check if record '%s' is visible to all for DOI creation. Error is %s.", metadata.getUuid(), e.getMessage())).withMessageKey("exception.doi.failedVisibilityCheck").withDescriptionKey("exception.doi.failedVisibilityCheck.description", new String[]{metadata.getUuid(), e.getMessage()});
        }
        if (!visibleToAll) {
            throw new DoiClientException(String.format("Record '%s' is not public and we cannot request a DOI for such a record. Publish this record first.", metadata.getUuid())).withMessageKey("exception.doi.recordNotPublic").withDescriptionKey("exception.doi.recordNotPublic.description", new String[]{metadata.getUuid()});
        }
        try {
            String currentDoi = this.metadataUtils.getDoi(metadata.getUuid());
            if (StringUtils.isNotEmpty((String)currentDoi)) {
                String newDoi = this.client.createPublicUrl(doi);
                if (!currentDoi.equals(newDoi)) {
                    throw new DoiClientException(String.format("Record '%s' already contains a DOI <a href='%s'>%s</a> which is not equal to the DOI about to be created (ie. '%s'). Maybe current DOI does not correspond to that record? This may happen when creating a copy of a record having an existing DOI.", metadata.getUuid(), currentDoi, currentDoi, newDoi)).withMessageKey("exception.doi.resourcesContainsDoiNotEqual").withDescriptionKey("exception.doi.resourcesContainsDoiNotEqual.description", new String[]{metadata.getUuid(), currentDoi, currentDoi, newDoi});
                }
                throw new ResourceAlreadyExistException(String.format("Record '%s' already contains a DOI. The DOI is <a href='%s'>%s</a>. You've to update existing DOI. Remove the DOI reference if it does not apply to that record.", metadata.getUuid(), currentDoi, currentDoi)).withMessageKey("exception.doi.resourceContainsDoi").withDescriptionKey("exception.doi.resourceContainsDoi.description", (Object[])new String[]{metadata.getUuid(), currentDoi, currentDoi});
            }
        }
        catch (ResourceNotFoundException e) {
            MetadataSchema schema = this.schemaUtils.getSchema(metadata.getDataInfo().getSchemaId());
            throw new DoiClientException(String.format("Record '%s' is in schema '%s' and we cannot find a saved query with id '%s' to retrieve the DOI. Error is %s. Check the schema %sSchemaPlugin and add the DOI get query.", metadata.getUuid(), schema.getName(), "doi-get", e.getMessage(), schema.getName())).withMessageKey("exception.doi.missingSavedquery").withDescriptionKey("exception.doi.missingSavedquery.description", new String[]{metadata.getUuid(), schema.getName(), "doi-get", e.getMessage(), schema.getName()});
        }
    }

    private void checkPreConditionsOnDataCite(AbstractMetadata metadata, String doi, Element dataciteMetadata, String language) throws DoiClientException, ResourceAlreadyExistException {
        try {
            ArrayList validations = new ArrayList();
            ArrayList applicableSchematron = Lists.newArrayList();
            ApplicableSchematron schematron = new ApplicableSchematron(SchematronRequirement.REQUIRED, this.schematronRepository.findOneByFileAndSchemaName("schematron-rules-datacite.xsl", metadata.getDataInfo().getSchemaId()));
            applicableSchematron.add(schematron);
            Element rules = this.validator.applyCustomSchematronRules(metadata.getDataInfo().getSchemaId(), metadata.getId(), metadata.getXmlData(false), language, validations, (List)applicableSchematron);
            ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
            namespaces.add(Geonet.Namespaces.GEONET);
            namespaces.add(Geonet.Namespaces.SVRL);
            List failures = Xml.selectNodes((Element)rules, (String)".//svrl:failed-assert/svrl:text/*", namespaces);
            StringBuilder message = new StringBuilder();
            if (!failures.isEmpty()) {
                message.append("<ul>");
                failures.forEach(f -> message.append("<li>").append(((Element)f).getTextNormalize()).append("</li>"));
                message.append("</ul>");
                throw new DoiClientException(String.format("Record '%s' is not conform with DataCite format. %d mandatory field(s) missing. %s", metadata.getUuid(), failures.size(), message)).withMessageKey("exception.doi.recordNotConformantMissingInfo").withDescriptionKey("exception.doi.recordNotConformantMissingInfo.description", new String[]{metadata.getUuid(), String.valueOf(failures.size()), message.toString()});
            }
        }
        catch (IOException | JDOMException e) {
            throw new DoiClientException(String.format("Record '%s' is not conform with DataCite validation rules for mandatory fields. Error is: %s. Required fields in DataCite are: identifier, creators, titles, publisher, publicationYear, resourceType. <a href='%sapi/records/%s/formatters/datacite?output=xml'>Check the DataCite format output</a> and adapt the record content to add missing information.", metadata.getUuid(), e.getMessage(), this.sm.getNodeURL(), metadata.getUuid())).withMessageKey("exception.doi.recordNotConformantMissingMandatory").withDescriptionKey("exception.doi.recordNotConformantMissingMandatory.description", new String[]{metadata.getUuid(), e.getMessage(), this.sm.getNodeURL(), metadata.getUuid()});
        }
        try {
            Xml.validate((Element)dataciteMetadata);
        }
        catch (Exception e) {
            throw new DoiClientException(String.format("Record '%s' converted to DataCite format is invalid. Error is: %s. Required fields in DataCite are: identifier, creators, titles, publisher, publicationYear, resourceType. <a href='%sapi/records/%s/formatters/datacite?output=xml'>Check the DataCite format output</a> and adapt the record content to add missing information.", metadata.getUuid(), e.getMessage(), this.sm.getNodeURL(), metadata.getUuid())).withMessageKey("exception.doi.recordInvalid").withDescriptionKey("exception.doi.recordInvalid.description", new String[]{metadata.getUuid(), e.getMessage(), this.sm.getNodeURL(), metadata.getUuid()});
        }
        String doiResponse = this.client.retrieveDoi(doi);
        if (doiResponse != null) {
            throw new ResourceAlreadyExistException(String.format("Record '%s' looks to be already published on DataCite with DOI <a href='%s'>'%s'</a>. DOI on Datacite point to: <a href='%s'>%s</a>. If the DOI is not correct, remove it from the record and ask for a new one.", metadata.getUuid(), this.client.createUrl("doi") + "/" + doi, doi, doi, doiResponse)).withMessageKey("exception.doi.resourceAlreadyPublished").withDescriptionKey("exception.doi.resourceAlreadyPublished.description", (Object[])new String[]{metadata.getUuid(), this.client.createUrl("doi") + "/" + doi, doi, doi, doiResponse});
        }
    }

    private void createDoi(ServiceContext context, AbstractMetadata metadata, Map<String, String> doiInfo, Element dataciteMetadata) throws Exception {
        this.client.createDoiMetadata(doiInfo.get("doi"), Xml.getString((Element)dataciteMetadata));
        String landingPage = this.landingPageTemplate.replace(DOI_DEFAULT_PATTERN, metadata.getUuid());
        doiInfo.put("doiLandingPage", landingPage);
        doiInfo.put("doiUrl", this.client.createPublicUrl(doiInfo.get("doi")));
        this.client.createDoi(doiInfo.get("doi"), landingPage);
        Element recordWithDoi = this.setDOIValue(doiInfo.get("doi"), metadata.getDataInfo().getSchemaId(), metadata.getXmlData(false));
        this.dm.updateMetadata(context, metadata.getId() + "", recordWithDoi, false, true, context.getLanguage(), new ISODate().toString(), true, IndexingMode.full);
    }

    private void checkDoiCreation(AbstractMetadata metadata, Map<String, String> doi) {
    }

    public void unregisterDoi(AbstractMetadata metadata, ServiceContext context) throws DoiClientException, ResourceNotFoundException {
        this.checkInitialised();
        String doi = this.doiBuilder.create(this.doiPattern, this.doiPrefix, metadata);
        String doiResponse = this.client.retrieveDoi(doi);
        if (doiResponse == null) {
            throw new ResourceNotFoundException(String.format("Record '%s' is not available on DataCite. DOI '%s' does not exist.", metadata.getUuid(), doi));
        }
        try {
            Element md = metadata.getXmlData(false);
            String doiUrl = this.metadataUtils.getDoi(metadata.getUuid());
            this.client.deleteDoiMetadata(doi);
            this.client.deleteDoi(doi);
            Element recordWithoutDoi = this.removeDOIValue(doiUrl, metadata.getDataInfo().getSchemaId(), md);
            this.dm.updateMetadata(context, metadata.getId() + "", recordWithoutDoi, false, true, context.getLanguage(), new ISODate().toString(), true, IndexingMode.full);
        }
        catch (Exception ex) {
            throw new DoiClientException(String.format("Error unregistering DOI: %s", ex.getMessage())).withMessageKey("exception.doi.serverErrorUnregister").withDescriptionKey("exception.doi.serverErrorUnregister.description", new String[]{ex.getMessage()});
        }
    }

    public Element setDOIValue(String doi, String schema, Element md) throws Exception {
        Path styleSheet = this.dm.getSchemaDir(schema).resolve(DOI_ADD_XSL_PROCESS);
        boolean exists = Files.exists(styleSheet, new LinkOption[0]);
        if (!exists) {
            String message = String.format("To create a DOI, the schema has to defined how to insert a DOI in the record. The schema_plugins/%s/process/%s was not found. Create the XSL transformation.", schema, DOI_ADD_XSL_PROCESS);
            throw new DoiClientException(String.format("Error creating  DOI: %s", message)).withMessageKey("exception.doi.serverErrorCreate").withDescriptionKey("exception.doi.serverErrorCreate.description", new String[]{message});
        }
        String doiPublicUrl = this.client.createPublicUrl("");
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("doi", doi);
        params.put("doiProxy", doiPublicUrl);
        return Xml.transform((Element)md, (Path)styleSheet, params);
    }

    public Element removeDOIValue(String doi, String schema, Element md) throws Exception {
        Path styleSheet = this.dm.getSchemaDir(schema).resolve(DOI_REMOVE_XSL_PROCESS);
        boolean exists = Files.exists(styleSheet, new LinkOption[0]);
        if (!exists) {
            String message = String.format("To remove a DOI, the schema has to defined how to remove a DOI in the record. The schema_plugins/%s/process/%s was not found. Create the XSL transformation.", schema, DOI_REMOVE_XSL_PROCESS);
            throw new DoiClientException(String.format("Error deleting  DOI: %s", message)).withMessageKey("exception.doi.serverErrorDelete").withDescriptionKey("exception.doi.serverErrorDelete.description", new String[]{message});
        }
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("doi", doi);
        return Xml.transform((Element)md, (Path)styleSheet, params);
    }

    private Element convertXmlToDataCiteFormat(String schema, Element md, String doi) throws Exception {
        Path styleSheet = this.dm.getSchemaDir(schema).resolve(this.isMedra ? DATACITE_MEDRA_XSL_CONVERSION_FILE : DATACITE_XSL_CONVERSION_FILE);
        boolean exists = Files.exists(styleSheet, new LinkOption[0]);
        if (!exists) {
            String message = String.format("To create a DOI, the record needs to be converted to the DataCite format (https://schema.datacite.org/). You need to create a formatter for this in schema_plugins/%s/%s. If the standard is a profile of ISO19139, you can simply point to the ISO19139 formatter.", schema, DATACITE_XSL_CONVERSION_FILE);
            throw new DoiClientException(String.format("Error creating  DOI: %s", message)).withMessageKey("exception.doi.serverErrorCreate").withDescriptionKey("exception.doi.serverErrorCreate.description", new String[]{message});
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(DOI_ID_PARAMETER, doi);
        return Xml.transform((Element)md, (Path)styleSheet, params);
    }

    private void checkInitialised() throws DoiClientException {
        if (!this.initialised) {
            throw new DoiClientException("DOI configuration is not complete. Check System Configuration and set the DOI configuration.").withMessageKey("exception.doi.configurationMissing").withDescriptionKey("exception.doi.configurationMissing.description", new String[0]);
        }
    }
}

