/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.doi.client;

import java.io.Closeable;
import java.text.MessageFormat;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpUriRequest;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.doi.client.BaseDoiClient;
import org.fao.geonet.doi.client.DoiClientException;
import org.fao.geonet.doi.client.IDoiClient;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.Log;
import org.springframework.http.client.ClientHttpResponse;

public class DoiDataciteClient
extends BaseDoiClient
implements IDoiClient {
    public DoiDataciteClient(String apiUrl, String username, String password, String doiPublicUrl) {
        this.apiUrl = apiUrl.endsWith("/") ? apiUrl : apiUrl + "/";
        this.doiPublicUrl = doiPublicUrl.endsWith("/") ? doiPublicUrl : doiPublicUrl + "/";
        this.username = username;
        this.password = password;
        this.requestFactory = (GeonetHttpRequestFactory)ApplicationContextHolder.get().getBean(GeonetHttpRequestFactory.class);
    }

    @Override
    public void createDoi(String doi, String url) throws DoiClientException {
        String requestBody = MessageFormat.format("doi={0}\nurl={1}", doi, url);
        String apiurl = this.createUrl("doi");
        this.create(apiurl, requestBody, "text/plain;charset=UTF-8", 201, String.format("DOI metadata created at %s.", apiurl));
    }

    @Override
    public String retrieveDoi(String doi) throws DoiClientException {
        return this.retrieve(this.createUrl("doi/" + doi));
    }

    @Override
    public String retrieveAllDoi(String doi) throws DoiClientException {
        return this.retrieve(this.createUrl("doi"));
    }

    @Override
    public void createDoiMetadata(String doi, String doiMetadata) throws DoiClientException {
        String apiurl = this.createUrl("metadata");
        this.create(apiurl, doiMetadata, "application/xml", 201, String.format("DOI metadata created at %s.", apiurl));
    }

    @Override
    public String retrieveDoiMetadata(String doi) throws DoiClientException {
        return this.retrieve(this.createUrl("metadata/" + doi));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void deleteDoiMetadata(String doi) throws DoiClientException {
        ClientHttpResponse httpResponse;
        block6: {
            httpResponse = null;
            HttpDelete deleteMethod = null;
            try {
                Log.debug((String)"geonetwork.doi", (Object)("   -- URL: " + this.apiUrl + "/metadata"));
                deleteMethod = new HttpDelete(this.createUrl("metadata/" + doi));
                httpResponse = this.executeRequest((HttpUriRequest)deleteMethod);
                int status = httpResponse.getRawStatusCode();
                Log.debug((String)"geonetwork.doi", (Object)("   -- Request status code: " + status));
                if (status != 404 && status != 200) {
                    Log.info((String)"geonetwork.doi", (Object)("Delete DOI metadata end -- Error: " + httpResponse.getStatusText()));
                    String message = httpResponse.getStatusText();
                    throw new DoiClientException(String.format("Error deleting DOI: %s", message)).withMessageKey("exception.doi.serverErrorDelete").withDescriptionKey("exception.doi.serverErrorDelete.description", new String[]{message});
                }
                Log.info((String)"geonetwork.doi", (Object)"DeleteDOI metadata end");
                if (deleteMethod == null) break block6;
            }
            catch (Exception ex) {
                try {
                    Log.error((String)"geonetwork.doi", (String)("   -- Error (exception): " + ex.getMessage()), (Throwable)ex);
                    throw new DoiClientException(String.format("Error deleting DOI: %s", ex.getMessage())).withMessageKey("exception.doi.serverErrorDelete").withDescriptionKey("exception.doi.serverErrorDelete.description", new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    if (deleteMethod != null) {
                        deleteMethod.releaseConnection();
                    }
                    IOUtils.closeQuietly(httpResponse);
                    throw throwable;
                }
            }
            deleteMethod.releaseConnection();
        }
        IOUtils.closeQuietly((Closeable)httpResponse);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void deleteDoi(String doi) throws DoiClientException {
        ClientHttpResponse httpResponse;
        block6: {
            httpResponse = null;
            HttpDelete deleteMethod = null;
            try {
                Log.debug((String)"geonetwork.doi", (Object)("   -- URL: " + this.apiUrl + "/metadata"));
                deleteMethod = new HttpDelete(this.createUrl("doi/" + doi));
                httpResponse = this.executeRequest((HttpUriRequest)deleteMethod);
                int status = httpResponse.getRawStatusCode();
                Log.debug((String)"geonetwork.doi", (Object)("   -- Request status code: " + status));
                if (status != 404 && status != 200) {
                    Log.info((String)"geonetwork.doi", (Object)("Delete DOI end -- Error: " + httpResponse.getStatusText()));
                    String message = httpResponse.getStatusText();
                    throw new DoiClientException(String.format("Error deleting DOI: %s", message)).withMessageKey("exception.doi.serverErrorDelete").withDescriptionKey("exception.doi.serverErrorDelete.description", new String[]{message});
                }
                Log.info((String)"geonetwork.doi", (Object)"DeleteDOI end");
                if (deleteMethod == null) break block6;
            }
            catch (Exception ex) {
                try {
                    Log.error((String)"geonetwork.doi", (String)("   -- Error (exception): " + ex.getMessage()), (Throwable)ex);
                    throw new DoiClientException(String.format("Error deleting DOI: %s", ex.getMessage())).withMessageKey("exception.doi.serverErrorDelete").withDescriptionKey("exception.doi.serverErrorDelete.description", new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    if (deleteMethod != null) {
                        deleteMethod.releaseConnection();
                    }
                    IOUtils.closeQuietly(httpResponse);
                    throw throwable;
                }
            }
            deleteMethod.releaseConnection();
        }
        IOUtils.closeQuietly((Closeable)httpResponse);
    }

    @Override
    public String createUrl(String service) {
        return this.apiUrl + service;
    }

    @Override
    public String createPublicUrl(String doi) {
        return this.doiPublicUrl + doi;
    }
}

