/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.doi.client;

import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Group;
import org.fao.geonet.kernel.datamanager.base.BaseMetadataUtils;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.GroupRepository;
import org.springframework.beans.factory.annotation.Autowired;

public class DoiBuilder {
    @Autowired
    GroupRepository groupRepository;

    public String create(String doiPattern, String prefix, AbstractMetadata metadata) {
        Optional groupOwner = metadata.getSourceInfo().getGroupOwner() != null ? this.groupRepository.findById((Object)metadata.getSourceInfo().getGroupOwner()) : Optional.empty();
        return prefix + "/" + doiPattern.replace("{{groupOwner}}", groupOwner.isPresent() ? ((Group)groupOwner.get()).getName() : "").replace("{{id}}", metadata.getId() + "").replace("{{uuid}}", metadata.getUuid());
    }

    public static String createDoi(String uuid) {
        DoiBuilder doiBuilder = (DoiBuilder)ApplicationContextHolder.get().getBean(DoiBuilder.class);
        SettingManager settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        String doiPrefix = settingManager.getValue("system/publication/doi/doikey");
        String doiPattern = StringUtils.defaultIfEmpty((String)settingManager.getValue("system/publication/doi/doipattern"), (String)"{{uuid}}");
        BaseMetadataUtils metadataUtils = (BaseMetadataUtils)ApplicationContextHolder.get().getBean(BaseMetadataUtils.class);
        AbstractMetadata metadata = metadataUtils.findOneByUuid(uuid);
        return doiBuilder.create(doiPattern, doiPrefix, metadata);
    }
}

