/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.wro4j;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.logging.log4j.Level;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Log;
import org.fao.geonet.wro4j.ClosureDependencyUriLocator;
import org.fao.geonet.wro4j.ClosureRequireDependencyManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import ro.isdc.wro.config.ReadOnlyContext;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.group.Group;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.util.StopWatch;

public class GeonetWroModelFactory
implements WroModelFactory {
    public static final String WRO_SOURCES_KEY = "wroSources";
    public static final String JS_SOURCE_EL = "jsSource";
    public static final String INCLUDE_EL = "include";
    public static final String FILE_ATT = "file";
    public static final String FILE_EL = "file";
    public static final String DECLARATIVE_EL = "declarative";
    public static final String DECLARATIVE_NAME_ATT = "name";
    public static final String MINIMIZED_ATT = "minimize";
    public static final String REQUIRE_EL = "require";
    public static final String CSS_SOURCE_EL = "cssSource";
    public static final String WEBAPP_ATT = "webappPath";
    public static final String PATH_ON_DISK_ATT = "pathOnDisk";
    public static final String CLASSPATH_PREFIX = "classpath:";
    public static final String GROUP_NAME_CLOSURE_DEPS = "closure_deps";
    public static final String TEMPLATE_PATTERN = "directive.js";
    private static final Pattern PATH_REPLACEMENT_MATCHER = Pattern.compile("\\{\\{(.+?)\\}\\}");
    private static final String NOT_MINIMIZED_EL = "notMinimized";
    @Inject
    private ReadOnlyContext _context;
    private Collection<Throwable> errors = Lists.newArrayList();
    private String _geonetworkRootDirectory = "";

    static String findGeonetworkRootDirectory(String sourcesXmlFile) {
        File currentFile;
        for (currentFile = new File(sourcesXmlFile); currentFile != null && !new File(currentFile, "web/src/main/webResources/WEB-INF/web.xml").exists(); currentFile = currentFile.getParentFile()) {
        }
        if (currentFile == null) {
            throw new AssertionError((Object)("Unable to find root geonetwork directory using '" + sourcesXmlFile + "' as a starting point"));
        }
        return currentFile.getAbsolutePath() + "/";
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WroModel create() {
        StopWatch stopWatch = new StopWatch("Create Wro Model using Geonetwork");
        try {
            WroModel wroModel;
            block11: {
                stopWatch.start("createModel");
                String sourcesXmlFile = this.getSourcesXmlFile();
                if (this.isMavenBuild() && this._geonetworkRootDirectory.isEmpty()) {
                    this._geonetworkRootDirectory = GeonetWroModelFactory.findGeonetworkRootDirectory(sourcesXmlFile);
                }
                FileInputStream sourcesInputStream = null;
                try {
                    sourcesInputStream = new FileInputStream(sourcesXmlFile);
                    WroModel model = this.createModel(sourcesXmlFile, sourcesInputStream);
                    this.logModel(model);
                    wroModel = model;
                    if (sourcesInputStream == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (sourcesInputStream != null) {
                            IOUtils.closeQuietly((InputStream)sourcesInputStream);
                        }
                        throw throwable;
                    }
                    catch (Error | RuntimeException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }
                IOUtils.closeQuietly((InputStream)sourcesInputStream);
            }
            return wroModel;
        }
        finally {
            stopWatch.stop();
            Log.info((String)"geonetwork.wro4j", (Object)stopWatch.prettyPrint());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WroModel createModel(String parentSourcesXmlFile, InputStream sourcesXmlFile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(sourcesXmlFile);
        WroModel model = new WroModel();
        Group closureDepsGroup = new Group(GROUP_NAME_CLOSURE_DEPS);
        NodeList includeNodes = doc.getElementsByTagName(INCLUDE_EL);
        for (int i = 0; i < includeNodes.getLength(); ++i) {
            Element include = (Element)includeNodes.item(i);
            if (!include.hasAttribute("file")) {
                throw new AssertionError((Object)"include elements must have a file attribute");
            }
            Collection<IncludesStream> streams = null;
            try {
                streams = this.openIncludesStream(parentSourcesXmlFile, include.getAttribute("file"));
                for (IncludesStream is : streams) {
                    InputStream stream = is.stream;
                    WroModel includedModel = this.createModel(is.locationLoadedFrom, stream);
                    for (Group group : includedModel.getGroups()) {
                        if (GROUP_NAME_CLOSURE_DEPS.equals(group.getName())) {
                            for (Resource resource : group.getResources()) {
                                closureDepsGroup.addResource(resource);
                            }
                            continue;
                        }
                        model.addGroup(group);
                    }
                }
                if (streams == null) continue;
            }
            catch (Exception e) {
                try {
                    this.errors.add(e);
                    Log.error((String)"geonetwork.wro4j", (String)"Error while loading wro4j model", (Throwable)e);
                    if (streams == null) continue;
                }
                catch (Throwable throwable) {
                    if (streams != null) {
                        for (IncludesStream stream : streams) {
                            IOUtils.closeQuietly((InputStream)stream.stream);
                        }
                    }
                    throw throwable;
                }
                for (IncludesStream stream : streams) {
                    IOUtils.closeQuietly((InputStream)stream.stream);
                }
                continue;
            }
            for (IncludesStream stream : streams) {
                IOUtils.closeQuietly((InputStream)stream.stream);
            }
            continue;
        }
        NodeList requireNodes = doc.getElementsByTagName(REQUIRE_EL);
        for (int i = 0; i < requireNodes.getLength(); ++i) {
            Element require = (Element)requireNodes.item(i);
            this.loadGroupsUsingRequireDependencyManagement(require, model, closureDepsGroup);
        }
        if (!closureDepsGroup.getResources().isEmpty()) {
            model.addGroup(closureDepsGroup);
        }
        NodeList declareNodes = doc.getElementsByTagName(DECLARATIVE_EL);
        for (int i = 0; i < declareNodes.getLength(); ++i) {
            Element declared = (Element)declareNodes.item(i);
            this.addExplicitlyDeclarativeGroups(declared, model);
        }
        return model;
    }

    public void setContext(ReadOnlyContext context) {
        this._context = context;
    }

    public void setGeonetworkRootDirectory(String geonetworkRootDirectory) {
        this._geonetworkRootDirectory = geonetworkRootDirectory;
    }

    private Collection<IncludesStream> openIncludesStream(String parentSourcesXmlFile, String includeFile) throws IOException {
        Collection<IncludesStream> includesStreams;
        if (includeFile.startsWith(CLASSPATH_PREFIX)) {
            Collection<IncludesStream> includesStreams2 = this.loadFromClasspath(includeFile);
            if (includesStreams2.isEmpty()) {
                String actualPath = includeFile.substring(CLASSPATH_PREFIX.length());
                includesStreams2 = this.loadFromClasspath("classpath:WEB-INF/classes/" + actualPath);
            }
            if (!includesStreams2.isEmpty()) {
                return includesStreams2;
            }
            throw new AssertionError((Object)("Unable to load: " + includeFile));
        }
        String relativePath = this.toRelativePath(parentSourcesXmlFile);
        if (relativePath.startsWith(CLASSPATH_PREFIX) && !(includesStreams = relativePath.equals(CLASSPATH_PREFIX) ? this.loadFromClasspath(relativePath + includeFile) : this.loadFromClasspath(relativePath + "/" + includeFile)).isEmpty()) {
            return includesStreams;
        }
        IncludesStream stream = this.tryToLoadAsURL(includeFile);
        if (stream != null) {
            return Collections.singleton(stream);
        }
        String pathWithRelativePortion = relativePath + "/" + includeFile;
        stream = this.tryToLoadAsURL(pathWithRelativePortion);
        if (stream != null) {
            return Collections.singleton(stream);
        }
        if (new File(includeFile).exists()) {
            return Collections.singleton(new IncludesStream(new FileInputStream(includeFile), includeFile));
        }
        File file = new File(relativePath, includeFile);
        if (file.exists()) {
            return Collections.singleton(new IncludesStream(new FileInputStream(file), file.getAbsolutePath()));
        }
        if (!this.isMavenBuild()) {
            ServletContext servletContext = this._context.getServletContext();
            try {
                File absolute = new File(servletContext.getRealPath(includeFile));
                if (absolute.exists()) {
                    return Collections.singleton(new IncludesStream(new FileInputStream(absolute), absolute.getAbsolutePath()));
                }
            }
            catch (Throwable absolute) {
                // empty catch block
            }
            try {
                File relative = new File(servletContext.getRealPath(pathWithRelativePortion));
                if (relative.exists()) {
                    return Collections.singleton(new IncludesStream(new FileInputStream(relative), relative.getAbsolutePath()));
                }
            }
            catch (Throwable t) {
                throw new RuntimeException("Error trying to load: '" + includeFile + "' with parent:'" + parentSourcesXmlFile, t);
            }
        }
        throw new AssertionError((Object)("Unable to locate include xml file. \n\trelativePath: " + relativePath + "\n\tinclude file: " + includeFile));
    }

    private String toRelativePath(String relativeToWithName) {
        String relativeTo;
        int i = relativeToWithName.replace('\\', '/').lastIndexOf(47);
        if (i > -1) {
            relativeTo = relativeToWithName.substring(0, i);
        } else {
            relativeTo = "";
            if (relativeToWithName.startsWith(CLASSPATH_PREFIX)) {
                relativeTo = CLASSPATH_PREFIX;
            }
        }
        return relativeTo;
    }

    private Collection<IncludesStream> loadFromClasspath(String includeFile) throws IOException {
        String path;
        String actualPath = includeFile.substring(CLASSPATH_PREFIX.length());
        Enumeration<URL> resources = GeonetWroModelFactory.class.getClassLoader().getResources(actualPath);
        ArrayList<IncludesStream> results = new ArrayList<IncludesStream>();
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            String file = url.getFile();
            if (file.matches("/.:/.*")) {
                file = file.substring(1);
            }
            String relativeFile = includeFile;
            if (new File(file).exists()) {
                relativeFile = file;
            }
            results.add(new IncludesStream(url.openStream(), relativeFile));
        }
        if (results.isEmpty() && !this.isMavenBuild() && (path = this._context.getServletContext().getRealPath(actualPath)) != null && new File(path).exists()) {
            results.add(new IncludesStream(new FileInputStream(path), path));
        }
        return results;
    }

    private IncludesStream tryToLoadAsURL(String includeFile) {
        try {
            return new IncludesStream(new URL(includeFile).openStream(), includeFile);
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private void addExplicitlyDeclarativeGroups(Element declareEl, WroModel model) {
        String defaultPathOnDisk = declareEl.getAttribute(PATH_ON_DISK_ATT);
        NodeList jsSources = declareEl.getElementsByTagName(JS_SOURCE_EL);
        if (!declareEl.hasAttribute(DECLARATIVE_NAME_ATT)) {
            throw new AssertionError((Object)"declarative elements require a name attribute.");
        }
        String name = declareEl.getAttribute(DECLARATIVE_NAME_ATT);
        Group group = new Group(name);
        for (int i = 0; i < jsSources.getLength(); ++i) {
            Element item = (Element)jsSources.item(i);
            ResourceDesc desc = this.parseSource(item, defaultPathOnDisk);
            boolean isMinimized = !item.hasAttribute(MINIMIZED_ATT) || Boolean.parseBoolean(item.getAttribute(MINIMIZED_ATT));
            Resource resource = this.createResource(isMinimized, desc, ResourceType.JS);
            group.addResource(resource);
        }
        NodeList cssSources = declareEl.getElementsByTagName(CSS_SOURCE_EL);
        for (int i = 0; i < cssSources.getLength(); ++i) {
            Element item = (Element)cssSources.item(i);
            ResourceDesc desc = this.parseSource(item, defaultPathOnDisk);
            boolean isMinimized = !item.hasAttribute(MINIMIZED_ATT) || Boolean.parseBoolean(item.getAttribute(MINIMIZED_ATT));
            Resource resource = this.createResource(isMinimized, desc, ResourceType.CSS);
            group.addResource(resource);
        }
        model.addGroup(group);
    }

    private Resource createResource(boolean isMinimized, ResourceDesc desc, ResourceType type) {
        File file = desc.root;
        Resource resource = new Resource();
        resource.setMinimize(isMinimized);
        resource.setType(type);
        resource.setUri(file.toURI().toString());
        return resource;
    }

    private void loadGroupsUsingRequireDependencyManagement(Element doc, WroModel model, Group closureDepsGroup) throws IOException {
        String defaultPathOnDisk = this.makePathReplacements(doc.getAttribute(PATH_ON_DISK_ATT));
        NodeList jsSources = doc.getElementsByTagName(JS_SOURCE_EL);
        ClosureRequireDependencyManager dependencyManager = this.configureJavascripDependencyManager(jsSources, defaultPathOnDisk);
        Map<String, Group> groups = this.addJavascriptGroupsByRequireDependencies(model, dependencyManager, closureDepsGroup);
        NodeList cssSources = doc.getElementsByTagName(CSS_SOURCE_EL);
        this.addCssGroupsByRequireDependencies(model, groups, cssSources, defaultPathOnDisk);
    }

    private String makePathReplacements(String path) {
        if (ApplicationContextHolder.get() == null) {
            return path;
        }
        GeonetworkDataDirectory dataDirectory = (GeonetworkDataDirectory)ApplicationContextHolder.get().getBean(GeonetworkDataDirectory.class);
        Matcher matcher = PATH_REPLACEMENT_MATCHER.matcher(path);
        StringBuffer builder = new StringBuffer();
        while (matcher.find()) {
            String group = matcher.group(1);
            try {
                Method method = dataDirectory.getClass().getMethod("get" + Character.toUpperCase(group.charAt(0)) + group.substring(1), new Class[0]);
                Object invoke = method.invoke((Object)dataDirectory, new Object[0]);
                matcher.appendReplacement(builder, invoke.toString().replace("\\", "\\\\"));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        matcher.appendTail(builder);
        return builder.toString();
    }

    private void logModel(WroModel model) {
        if (Log.isEnabledFor((String)"geonetwork.wro4j", (Level)Level.INFO)) {
            StringBuilder builder = new StringBuilder();
            int uriLength = 60;
            for (Group group : model.getGroups()) {
                builder.append("Group " + group.getName() + " contains:\n");
                for (Resource resource : group.getResources()) {
                    String uri = resource.getUri();
                    int min = Math.max(0, uri.length() - 60);
                    int max = resource.getUri().length();
                    uri = uri.substring(min, max);
                    if (min > 0) {
                        uri = "..." + uri;
                    }
                    builder.append("\t" + uri + "\n");
                }
                builder.append("\n\n");
            }
            Log.info((String)"geonetwork.wro4j", (Object)builder.toString());
        }
        if (!this.errors.isEmpty()) {
            Log.error((String)"geonetwork.wro4j", (Object)"Errors were encountered");
            for (Throwable error : this.errors) {
                Log.error((String)"geonetwork.wro4j", (String)"error", (Throwable)error);
            }
        }
    }

    private void addCssGroupsByRequireDependencies(WroModel model, Map<String, Group> groups, NodeList cssSources, String defaultPathOnDisk) {
        HashSet<String> cssGroups = new HashSet<String>();
        for (int i = 0; i < cssSources.getLength(); ++i) {
            Node cssSource = cssSources.item(i);
            Set<String> notMinimized = this.parseSetOfNotMinimized((Element)cssSource);
            ResourceDesc desc = this.parseSource((Element)cssSource, defaultPathOnDisk);
            Iterable<File> css = desc.files("css", "less");
            for (File file : css) {
                String name = file.getName();
                String groupId = name.substring(0, name.lastIndexOf(46));
                if (cssGroups.contains(groupId)) {
                    Log.warning((String)"geonetwork.wro4j", (Object)("There are at least two css file with the name: " + name + ". Only the first one will be used, ignoring: " + file.getPath()));
                    continue;
                }
                cssGroups.add(groupId);
                Group group = groups.containsKey(groupId) ? groups.get(groupId) : new Group(groupId);
                boolean isMinimized = true;
                for (String s : notMinimized) {
                    if (!file.getAbsolutePath().endsWith(s)) continue;
                    isMinimized = false;
                    break;
                }
                Resource resource = new Resource();
                resource.setMinimize(isMinimized);
                resource.setType(ResourceType.CSS);
                resource.setUri(file.toURI().toString());
                group.addResource(resource);
                if (groups.containsKey(groupId)) continue;
                model.addGroup(group);
            }
        }
    }

    private Map<String, Group> addJavascriptGroupsByRequireDependencies(WroModel model, ClosureRequireDependencyManager dependencyManager, Group closureDepsGroup) {
        Set<String> moduleIds = dependencyManager.getAllModuleIds();
        HashMap<String, Group> groupMap = new HashMap<String, Group>((int)((double)moduleIds.size() * 1.5));
        for (String moduleId : moduleIds) {
            Group group = new Group(moduleId);
            groupMap.put(moduleId, group);
            closureDepsGroup.addResource(ClosureDependencyUriLocator.createClosureDepResource(dependencyManager.getNode(moduleId)));
            Collection<ClosureRequireDependencyManager.Node> deps = dependencyManager.getTransitiveDependenciesFor(moduleId, true);
            ArrayList<Resource> resources = new ArrayList<Resource>();
            for (ClosureRequireDependencyManager.Node dep : deps) {
                group.addResource(this.createResourceFrom(dep));
                this.addTemplateResourceFrom(resources, dep);
                closureDepsGroup.addResource(ClosureDependencyUriLocator.createClosureDepResource(dep));
            }
            group.addResource(this.createResourceFrom(dependencyManager.getNode(moduleId)));
            if (resources.size() > 0) {
                group.addResource(this.getTemplateResource("template://header"));
                for (Resource resource : resources) {
                    group.addResource(resource);
                }
                group.addResource(this.getTemplateResource("template://footer"));
            }
            model.addGroup(group);
        }
        return groupMap;
    }

    private Resource createResourceFrom(ClosureRequireDependencyManager.Node dep) {
        Resource resource = new Resource();
        resource.setMinimize(dep.isMinimized);
        resource.setType(ResourceType.JS);
        Path path = IO.toPath((String)dep.path.replace("file:/D:", "/D"), (String[])new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            resource.setUri(path.toUri().toString());
        } else {
            resource.setUri(dep.path);
        }
        return resource;
    }

    private Resource getTemplateResource(String prefix) {
        Resource resource = new Resource();
        resource.setMinimize(false);
        resource.setType(ResourceType.JS);
        resource.setUri(prefix);
        return resource;
    }

    private void addTemplateResourceFrom(List<Resource> group, ClosureRequireDependencyManager.Node dep) {
        boolean isViewTemplate = dep.path.startsWith("/catalog/views/default/config.js");
        if (dep.path.toLowerCase().endsWith(TEMPLATE_PATTERN) || isViewTemplate) {
            Path dir;
            if (dep.path.startsWith("file:/")) {
                try {
                    dir = Paths.get(new URI(dep.path)).getParent();
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            } else {
                dir = Paths.get(dep.path, new String[0]).getParent();
            }
            if (dir == null) {
                throw new RuntimeException("Directory folder is missing!!");
            }
            Path resolve = dir;
            String dirPath = resolve.toString().replace('\\', '/');
            String prefix = "template://" + dirPath;
            group.add(this.getTemplateResource(prefix));
        }
    }

    private ClosureRequireDependencyManager configureJavascripDependencyManager(NodeList jsSources, String defaultPathOnDisk) throws IOException {
        ClosureRequireDependencyManager depManager = new ClosureRequireDependencyManager();
        for (int i = 0; i < jsSources.getLength(); ++i) {
            Node jsSource = jsSources.item(i);
            ResourceDesc desc = this.parseSource((Element)jsSource, defaultPathOnDisk);
            Set<String> notMinimized = this.parseSetOfNotMinimized((Element)jsSource);
            for (File file : desc.files("js")) {
                String path;
                if (this.isMavenBuild()) {
                    path = file.getAbsoluteFile().toURI().toString();
                } else {
                    path = desc.relativePath + file.getPath().substring(desc.finalPath.length());
                    if (!Files.exists(IO.toPath((String)path, (String[])new String[0]), new LinkOption[0])) {
                        path = '/' + path.replace('\\', '/').replaceAll("/+", "/");
                    }
                    if (path.startsWith("//")) {
                        path = path.substring(1);
                    }
                }
                depManager.addFile(path, file, notMinimized);
            }
        }
        depManager.validateGraph();
        return depManager;
    }

    private Set<String> parseSetOfNotMinimized(Element jsSource) {
        NodeList nodeList = jsSource.getElementsByTagName(NOT_MINIMIZED_EL);
        HashSet<String> notMinimized = new HashSet<String>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element notMinimizedEl = (Element)nodeList.item(i);
            NodeList files = notMinimizedEl.getElementsByTagName("file");
            for (int j = 0; j < files.getLength(); ++j) {
                notMinimized.add(files.item(j).getTextContent().trim());
            }
        }
        return notMinimized;
    }

    private ResourceDesc parseSource(Element sourceEl, String defaultPathOnDisk) {
        ResourceDesc desc = new ResourceDesc();
        if (!sourceEl.hasAttribute(WEBAPP_ATT)) {
            throw new AssertionError((Object)"No webappPath was found on jsSource");
        }
        desc.relativePath = this.makePathReplacements(sourceEl.getAttribute(WEBAPP_ATT));
        desc.relativePath = desc.relativePath.replace('\\', '/');
        desc.pathOnDisk = !sourceEl.hasAttribute(PATH_ON_DISK_ATT) ? defaultPathOnDisk : this.makePathReplacements(sourceEl.getAttribute(PATH_ON_DISK_ATT));
        if (desc.pathOnDisk == null) {
            throw new AssertionError((Object)"No pathOnDisk was found on jsSource or parent Element");
        }
        if (this.isMavenBuild()) {
            File relativePath;
            File pathOnDisk = new File(desc.pathOnDisk);
            desc.finalPath = pathOnDisk.isAbsolute() && pathOnDisk.exists() ? new File(desc.pathOnDisk, desc.relativePath).getPath() : ((relativePath = new File(desc.relativePath)).isAbsolute() && relativePath.exists() ? desc.relativePath : new File(this._geonetworkRootDirectory + desc.pathOnDisk, desc.relativePath).getPath());
            if (!new File(desc.finalPath).exists()) {
                throw new AssertionError((Object)("Neither '" + desc.finalPath + "' nor '" + new File(desc.pathOnDisk, desc.relativePath) + "' exist"));
            }
        } else {
            desc.finalPath = Files.exists(IO.toPath((String)desc.relativePath, (String[])new String[0]), new LinkOption[0]) ? desc.relativePath : this._context.getServletContext().getRealPath(desc.relativePath);
        }
        desc.root = new File(desc.finalPath);
        return desc;
    }

    private boolean isMavenBuild() {
        return this._context.getServletContext() == null;
    }

    public String getSourcesXmlFile() {
        String path;
        String[] split;
        String sourcesRawProperty = this.getConfigProperties().getProperty(WRO_SOURCES_KEY);
        if (this._context.getServletContext() != null && (split = sourcesRawProperty.split("WEB-INF/", 2)).length == 2 && (path = this._context.getServletContext().getRealPath("/WEB-INF/" + split[1])) != null) {
            return path;
        }
        return sourcesRawProperty;
    }

    protected Properties getConfigProperties() {
        return null;
    }

    private static class ResourceDesc {
        String relativePath;
        String pathOnDisk;
        String finalPath;
        File root;

        private ResourceDesc() {
        }

        public Iterable<File> files(final String ... extToCollect) {
            return new Iterable<File>(){

                @Override
                public Iterator<File> iterator() {
                    if (!root.exists()) {
                        throw new IllegalArgumentException(String.format("%s doesn't exist. It could be a missing library. Check the source if you have all dependency files required.", root));
                    }
                    if (root.isFile()) {
                        List suffixes = Arrays.stream(extToCollect).map(sufix -> "." + sufix).collect(Collectors.toList());
                        SuffixFileFilter suffixFilter = new SuffixFileFilter(suffixes);
                        if (suffixFilter.accept(root)) {
                            ArrayList<File> files = new ArrayList<File>(1);
                            files.add(root);
                            return files.iterator();
                        }
                        throw new IllegalArgumentException(String.format("%s exist but doesn't match the filter %s", root, Arrays.toString(extToCollect)));
                    }
                    if (!root.isDirectory()) {
                        throw new IllegalArgumentException(String.format("Directory '%s' is not a directory. It could be a missing library. Check the source if you have all dependency files required.", root));
                    }
                    return FileUtils.iterateFiles((File)root, (String[])extToCollect, (boolean)true);
                }
            };
        }
    }

    private static class IncludesStream {
        final InputStream stream;
        final String locationLoadedFrom;

        private IncludesStream(InputStream stream, String locationLoadedFrom) {
            this.stream = stream;
            this.locationLoadedFrom = locationLoadedFrom;
        }
    }
}

