/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.codecs;

import org.owasp.esapi.codecs.Codec;
import org.owasp.esapi.codecs.PushbackSequence;

public abstract class AbstractCodec<T>
implements Codec<T> {
    private final String[] hex = new String[256];

    public AbstractCodec() {
        for (char c = '\u0000'; c < '\u00ff'; c = (char)(c + 1)) {
            this.hex[c] = c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' ? null : this.toHex(c).intern();
        }
    }

    @Override
    public String encode(char[] immune, String input) {
        int point;
        StringBuilder sb = new StringBuilder();
        for (int offset = 0; offset < input.length(); offset += Character.charCount(point)) {
            point = input.codePointAt(offset);
            if (Character.isBmpCodePoint(point)) {
                sb.append(this.encodeCharacter(immune, new Character((char)point)));
                continue;
            }
            sb.append(this.encodeCharacter(immune, point));
        }
        return sb.toString();
    }

    @Override
    public String encodeCharacter(char[] immune, Character c) {
        return "" + c;
    }

    public String encodeCharacter(char[] immune, char c) {
        throw new IllegalArgumentException("You tried to call encodeCharacter with a char.  Nope.  Use Character instead!");
    }

    @Override
    public String encodeCharacter(char[] immune, int codePoint) {
        String rval = "";
        if (Character.isValidCodePoint(codePoint)) {
            rval = new StringBuilder().appendCodePoint(codePoint).toString();
        }
        return rval;
    }

    @Override
    public T decodeCharacter(PushbackSequence<T> input) {
        return input.next();
    }

    @Override
    public String getHexForNonAlphanumeric(char c) {
        if (c < '\u00ff') {
            return this.hex[c];
        }
        return this.toHex(c);
    }

    @Override
    public String getHexForNonAlphanumeric(int c) {
        if (c < 255) {
            return this.hex[c];
        }
        return this.toHex(c);
    }

    @Override
    public String toOctal(char c) {
        return Integer.toOctalString(c);
    }

    @Override
    public String toHex(char c) {
        return Integer.toHexString(c);
    }

    @Override
    public String toHex(int c) {
        return Integer.toHexString(c);
    }

    @Override
    public boolean containsCharacter(char c, char[] array) {
        for (char ch : array) {
            if (c != ch) continue;
            return true;
        }
        return false;
    }
}

