/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style.markwkt;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.geometry.jts.LiteShape;
import org.geotools.geometry.jts.WKTReader2;
import org.geotools.renderer.style.MarkFactory;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.filter.expression.Expression;

public class WKTMarkFactory
implements MarkFactory {
    protected static final Logger LOGGER = Logging.getLogger(WKTMarkFactory.class);
    public static final String WKT_PREFIX = "wkt://";
    public static final String WKTLIB_PREFIX = "wktlib://";
    public static final String WKT_SEPARATOR = "#";
    protected static URL ROOT_DIRECTORY = null;
    protected static final SoftValueHashMap<String, Map<String, String>> CACHE = new SoftValueHashMap();

    public void clearCache() {
        CACHE.clear();
    }

    public static void setRoot(URL root) {
        ROOT_DIRECTORY = root;
    }

    protected String getFromCache(String urlLib, String wktName) {
        Map library = (Map)CACHE.get((Object)urlLib);
        if (library != null) {
            return (String)library.get(wktName);
        }
        return null;
    }

    protected void addToCache(String urlLib) {
        HashMap<String, String> library = (HashMap<String, String>)CACHE.get((Object)urlLib);
        if (library == null) {
            Enumeration<?> names;
            library = new HashMap<String, String>();
            Properties propLib = null;
            try {
                propLib = this.loadLibrary(urlLib);
            }
            catch (IOException e) {
                LOGGER.log(Level.FINER, e.getMessage(), e);
                return;
            }
            Enumeration<?> e = names = propLib.propertyNames();
            while (e.hasMoreElements()) {
                String shpName = (String)e.nextElement();
                library.put(shpName, (String)propLib.get(shpName));
            }
            CACHE.put((Object)urlLib, library);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Shape getShape(Graphics2D graphics, Expression symbolUrl, Feature feature) throws Exception {
        if (symbolUrl == null) {
            return null;
        }
        String wellKnown = (String)symbolUrl.evaluate((Object)feature, String.class);
        if (!wellKnown.startsWith(WKT_PREFIX) && !wellKnown.startsWith(WKTLIB_PREFIX)) {
            return null;
        }
        String wkt = null;
        if (wellKnown.startsWith(WKT_PREFIX)) {
            wkt = wellKnown.substring(WKT_PREFIX.length());
        }
        if (wellKnown.startsWith(WKTLIB_PREFIX)) {
            String[] urlComponents = wellKnown.substring(WKTLIB_PREFIX.length()).split(WKT_SEPARATOR);
            WKTMarkFactory wKTMarkFactory = this;
            synchronized (wKTMarkFactory) {
                wkt = this.getFromCache(urlComponents[0], urlComponents[1]);
                if (wkt == null) {
                    this.addToCache(urlComponents[0]);
                    wkt = this.getFromCache(urlComponents[0], urlComponents[1]);
                }
            }
        }
        if (wkt == null) {
            LOGGER.info("This is not recognised a WKT symbol: " + wellKnown);
        }
        WKTReader2 reader = new WKTReader2();
        LiteShape shape = new LiteShape(reader.read(wkt), null, false);
        LOGGER.info("Created symbol from WKT " + wkt);
        return shape;
    }

    protected Properties loadLibrary(String libFile) throws IOException {
        Properties properties = new Properties();
        URL libUrl = null;
        try {
            libUrl = new URL(ROOT_DIRECTORY.toString() + "/" + libFile);
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.WARNING, "Could not parse WKT library URL: " + ROOT_DIRECTORY + "/" + libFile, e);
            return properties;
        }
        try (InputStream in = libUrl.openStream();){
            properties.load(in);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
        }
        return properties;
    }
}

