/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.harvester.wfsfeatures.worker;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.fao.geonet.harvester.wfsfeatures.model.WFSHarvesterParameter;
import org.fao.geonet.harvester.wfsfeatures.worker.OwsUtils;
import org.fao.geonet.harvester.wfsfeatures.worker.WFSClientWithStrategyInvestigator;
import org.fao.geonet.harvester.wfsfeatures.worker.WFSDataStoreWithStrategyInvestigator;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.data.wfs.impl.WFSDataAccessFactory;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class WFSHarvesterExchangeState
implements Serializable {
    public static final String MAPSERVER_STRATEGY = "mapserver";
    public static final String QGIS_STRATEGY = "qgis";
    public static final String INVESTIGATOR_STRATEGY = "investigator";
    private WFSHarvesterParameter parameters;
    private transient Logger logger = LogManager.getLogger((String)"geonetwork.harvest.wfs.features");
    private transient Map<String, String> fields = new LinkedHashMap<String, String>();
    private transient WFSDataStore wfsDatastore = null;
    private List<String> resolvedTypeNames = new ArrayList<String>();
    private String strategyId = null;

    public String getStrategyId() {
        return this.strategyId;
    }

    public WFSHarvesterParameter getParameters() {
        return this.parameters;
    }

    public WFSHarvesterExchangeState(WFSHarvesterParameter parameters) {
        this.parameters = parameters;
        this.checkTaskParameters();
    }

    public void setParameters(WFSHarvesterParameter parameters) {
        this.parameters = parameters;
    }

    public void setFields(Map<String, String> fields) {
        this.fields = fields;
    }

    public Map<String, String> getFields() {
        return this.fields;
    }

    public void setWfsDatastore(WFSDataStore wfsDatastore) {
        this.wfsDatastore = wfsDatastore;
    }

    public WFSDataStore getWfsDatastore() {
        return this.wfsDatastore;
    }

    public List<String> getResolvedTypeNames() {
        return this.resolvedTypeNames;
    }

    private void checkTaskParameters() {
        if (StringUtils.isEmpty((String)this.parameters.getUrl())) {
            String errorMsg = "Empty WFS server URL is not allowed.";
            this.logger.error(errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        if (StringUtils.isEmpty((String)this.parameters.getTypeName())) {
            String errorMsg = "Check configuration for WFS {}. Empty type name is not allowed.";
            this.logger.error(errorMsg, (Object)this.parameters.getUrl());
            throw new IllegalArgumentException(errorMsg);
        }
    }

    public void initDataStore() throws Exception {
        WFSDataStoreWithStrategyInvestigator factory = null;
        if (INVESTIGATOR_STRATEGY.equals(this.parameters.getStrategy())) {
            factory = new WFSDataStoreWithStrategyInvestigator();
            factory.init(this.parameters.getUrl(), this.parameters.getTypeName());
        } else {
            factory = new WFSDataStoreFactory();
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        try {
            String getCapUrl = OwsUtils.getGetCapabilitiesUrl(this.parameters.getUrl(), this.parameters.getVersion());
            this.logger.info("Connecting using GetCatapbilities URL '{}'.", (Object)getCapUrl);
            m.put(WFSDataAccessFactory.URL.key, getCapUrl);
            m.put(WFSDataAccessFactory.TIMEOUT.key, this.parameters.getTimeOut());
            m.put(WFSDataAccessFactory.TRY_GZIP.key, true);
            m.put(WFSDataAccessFactory.ENCODING.key, this.parameters.getEncoding());
            m.put(WFSDataAccessFactory.USEDEFAULTSRS.key, true);
            m.put(WFSDataAccessFactory.OUTPUTFORMAT.key, "GML3");
            m.put(WFSDataAccessFactory.LENIENT.key, true);
            if (!INVESTIGATOR_STRATEGY.equals(this.parameters.getStrategy()) && StringUtils.isNotEmpty((String)this.parameters.getStrategy())) {
                m.put(WFSDataAccessFactory.WFS_STRATEGY.key, this.parameters.getStrategy());
            }
            if (this.parameters.getMaxFeatures() != -1) {
                m.put(WFSDataAccessFactory.MAXFEATURES.key, this.parameters.getMaxFeatures());
            }
            this.wfsDatastore = factory.createDataStore(m);
            if (factory instanceof WFSDataStoreWithStrategyInvestigator) {
                WFSClientWithStrategyInvestigator wfsClientWithStrategyInvestigator = (WFSClientWithStrategyInvestigator)this.wfsDatastore.getWfsClient();
                this.strategyId = wfsClientWithStrategyInvestigator.getStrategyId();
                if (MAPSERVER_STRATEGY.equals(wfsClientWithStrategyInvestigator.getStrategyId())) {
                    HashMap<String, String> connectionParameters = new HashMap<String, String>();
                    connectionParameters.put("WFSDataStoreFactory:GET_CAPABILITIES_URL", this.parameters.getUrl());
                    this.wfsDatastore = (WFSDataStore)DataStoreFinder.getDataStore(connectionParameters);
                }
            }
        }
        catch (IOException e) {
            String errorMsg = String.format("Failed to create datastore from service using URL '%s'. Error is %s.", this.parameters.getUrl(), e.getMessage());
            this.logger.error(errorMsg);
            throw e;
        }
        catch (Exception e) {
            String errorMsg = String.format("Failed to GetCapabilities from service using URL '%s'. Error is %s.", this.parameters.getUrl(), e.getMessage());
            this.logger.error(errorMsg);
            throw e;
        }
        this.logger.info("Reading feature type '{}' schema structure.", (Object)this.parameters.getTypeName());
        String typeSeparator = ",";
        List<String> featureTypeList = Arrays.asList(this.parameters.getTypeName().split(typeSeparator));
        String[] datastoreTypeNames = this.wfsDatastore.getTypeNames();
        String datastoreTypeNamesList = Arrays.stream(datastoreTypeNames).collect(Collectors.joining(", "));
        for (String type : featureTypeList) {
            SimpleFeatureType sft = null;
            String resolvedFeatureTypeName = null;
            try {
                sft = this.wfsDatastore.getSchema(type);
                resolvedFeatureTypeName = type;
            }
            catch (IOException e) {
                this.logger.info(String.format("Type '%s' not found in data store. Available types are %s. Trying to found a match ignoring namespace.", this.parameters.getTypeName(), datastoreTypeNamesList));
                Optional<String> typeFound = Arrays.stream(datastoreTypeNames).filter(t -> t.endsWith(type)).findFirst();
                if (typeFound.isPresent()) {
                    resolvedFeatureTypeName = typeFound.get();
                    this.logger.info("Found a type '{}'.", (Object)resolvedFeatureTypeName);
                    sft = this.wfsDatastore.getSchema(resolvedFeatureTypeName);
                }
                throw new NoSuchElementException(String.format("No type found for '%s' (with or without namespace match).", this.parameters.getTypeName()));
            }
            if (sft != null) {
                List attributesDesc = sft.getAttributeDescriptors();
                for (AttributeDescriptor desc : attributesDesc) {
                    if (this.fields.containsKey(desc.getName().getLocalPart())) continue;
                    this.fields.put(desc.getName().getLocalPart(), OwsUtils.getTypeFromFeatureType(desc));
                }
            }
            this.resolvedTypeNames.add(resolvedFeatureTypeName);
        }
        this.logger.info("Successfully analyzed {} attributes in schema.", (Object)this.fields.size());
    }
}

