/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.util.Assert;

public final class DefaultOAuth2AuthenticatedPrincipal
implements OAuth2AuthenticatedPrincipal,
Serializable {
    private final Map<String, Object> attributes;
    private final Collection<GrantedAuthority> authorities;
    private final String name;

    public DefaultOAuth2AuthenticatedPrincipal(Map<String, Object> attributes, Collection<GrantedAuthority> authorities) {
        this(null, attributes, authorities);
    }

    public DefaultOAuth2AuthenticatedPrincipal(String name, Map<String, Object> attributes, Collection<GrantedAuthority> authorities) {
        Assert.notEmpty(attributes, (String)"attributes cannot be empty");
        this.attributes = Collections.unmodifiableMap(attributes);
        this.authorities = authorities != null ? Collections.unmodifiableCollection(authorities) : AuthorityUtils.NO_AUTHORITIES;
        this.name = name != null ? name : (String)this.attributes.get("sub");
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public String getName() {
        return this.name;
    }
}

