/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Tuple;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.SetJoin;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataDraft;
import org.fao.geonet.domain.MetadataDraft_;
import org.fao.geonet.domain.MetadataSourceInfo_;
import org.fao.geonet.domain.Metadata_;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.UserGroup;
import org.fao.geonet.domain.UserGroupId_;
import org.fao.geonet.domain.UserGroup_;
import org.fao.geonet.domain.UserSecurity_;
import org.fao.geonet.domain.User_;
import org.fao.geonet.repository.UserRepositoryCustom;
import org.fao.geonet.utils.Log;
import org.springframework.data.jpa.domain.Specification;

public class UserRepositoryCustomImpl
implements UserRepositoryCustom {
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public User findOne(String userId) {
        return (User)this.entityManager.find(User.class, (Object)Integer.valueOf(userId));
    }

    @Override
    public User findOneByEmail(@Nonnull String email) {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(User.class);
        Root root = query.from(User.class);
        SetJoin joinedEmailAddresses = root.join(User_.emailAddresses);
        query.where((Expression)cb.equal(cb.lower((Expression)joinedEmailAddresses), (Object)email.toLowerCase()));
        query.orderBy(new Order[]{cb.asc((Expression)root.get(User_.username))});
        List resultList = this.entityManager.createQuery(query).getResultList();
        if (resultList.isEmpty()) {
            return null;
        }
        if (resultList.size() > 1) {
            Log.error((String)"geonetwork.domain", (Object)String.format("The database is inconsistent.  There are multiple users with the email address: %s", email));
        }
        return (User)resultList.get(0);
    }

    @Override
    public User findOneByEmailAndSecurityAuthTypeIsNullOrEmpty(@Nonnull String email) {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(User.class);
        Root root = query.from(User.class);
        SetJoin joinedEmailAddresses = root.join(User_.emailAddresses);
        Path authTypePath = root.get(User_.security).get(UserSecurity_.authType);
        query.where((Expression)cb.and((Expression)cb.equal(cb.lower((Expression)joinedEmailAddresses), (Object)email.toLowerCase()), (Expression)cb.or((Expression)cb.isNull((Expression)authTypePath), (Expression)cb.equal(cb.trim((Expression)authTypePath), (Object)"")))).orderBy(new Order[]{cb.asc((Expression)root.get(User_.username))});
        List results = this.entityManager.createQuery(query).getResultList();
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() > 1) {
            Log.error((String)"geonetwork.domain", (Object)String.format("The database is inconsistent.  There are multiple users with the email address: %s", email));
        }
        return (User)results.get(0);
    }

    @Override
    public User findOneByUsernameAndSecurityAuthTypeIsNullOrEmpty(@Nonnull String username) {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(User.class);
        Root root = query.from(User.class);
        Path authTypePath = root.get(User_.security).get(UserSecurity_.authType);
        Path usernamePath = root.get(User_.username);
        query.where((Expression)cb.and((Expression)cb.equal(cb.lower((Expression)usernamePath), (Object)username.toLowerCase()), (Expression)cb.or((Expression)cb.isNull((Expression)authTypePath), (Expression)cb.equal(cb.trim((Expression)authTypePath), (Object)"")))).orderBy(new Order[]{cb.asc((Expression)root.get(User_.username))});
        List results = this.entityManager.createQuery(query).getResultList();
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() > 1) {
            Log.error((String)"geonetwork.domain", (Object)String.format("The database is inconsistent.  There are multiple users with username: %s", username));
        }
        return (User)results.get(0);
    }

    @Override
    @Nonnull
    public List<String> findDuplicatedUsernamesCaseInsensitive() {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(String.class);
        Root userRoot = query.from(User.class);
        query = query.select((Selection)cb.lower((Expression)userRoot.get(User_.username)));
        query.groupBy(new Expression[]{cb.lower((Expression)userRoot.get(User_.username))});
        query.having((Expression)cb.gt(cb.count((Expression)userRoot), (Number)1));
        return this.entityManager.createQuery(query).getResultList();
    }

    @Override
    @Nonnull
    public List<Pair<Integer, User>> findAllByGroupOwnerNameAndProfile(@Nonnull Collection<Integer> metadataIds, @Nullable Profile profile) {
        ArrayList<Pair<Integer, User>> results = new ArrayList<Pair<Integer, User>>();
        results.addAll(this.findAllByGroupOwnerNameAndProfileInternal(metadataIds, profile, false));
        results.addAll(this.findAllByGroupOwnerNameAndProfileInternal(metadataIds, profile, true));
        return results;
    }

    private List<Pair<Integer, User>> findAllByGroupOwnerNameAndProfileInternal(@Nonnull Collection<Integer> metadataIds, @Nullable Profile profile, boolean draft) {
        Predicate ownerPredicate;
        Predicate metadataPredicate;
        Root metadataRoot;
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(Tuple.class);
        Root userRoot = query.from(User.class);
        Root userGroupRoot = query.from(UserGroup.class);
        if (!draft) {
            metadataRoot = query.from(Metadata.class);
            query.multiselect(new Selection[]{metadataRoot.get(Metadata_.id), userRoot});
            metadataPredicate = metadataRoot.get(Metadata_.id).in(metadataIds);
            ownerPredicate = cb.equal((Expression)metadataRoot.get(Metadata_.sourceInfo).get(MetadataSourceInfo_.groupOwner), (Expression)userGroupRoot.get(UserGroup_.id).get(UserGroupId_.groupId));
        } else {
            metadataRoot = query.from(MetadataDraft.class);
            query.multiselect(new Selection[]{metadataRoot.get(MetadataDraft_.id), userRoot});
            metadataPredicate = metadataRoot.get(MetadataDraft_.id).in(metadataIds);
            ownerPredicate = cb.equal((Expression)metadataRoot.get(MetadataDraft_.sourceInfo).get(MetadataSourceInfo_.groupOwner), (Expression)userGroupRoot.get(UserGroup_.id).get(UserGroupId_.groupId));
        }
        Predicate userToGroupPredicate = cb.equal((Expression)userGroupRoot.get(UserGroup_.id).get(UserGroupId_.userId), (Expression)userRoot.get(User_.id));
        Predicate basePredicate = cb.and(new Predicate[]{metadataPredicate, ownerPredicate, userToGroupPredicate});
        if (profile != null) {
            Predicate profilePredicate = cb.equal((Expression)userGroupRoot.get(UserGroup_.id).get(UserGroupId_.profile), (Object)profile);
            query.where((Expression)cb.and((Expression)basePredicate, (Expression)profilePredicate));
        } else {
            query.where((Expression)basePredicate);
        }
        query.distinct(true);
        ArrayList<Pair<Integer, User>> results = new ArrayList<Pair<Integer, User>>();
        for (Tuple result : this.entityManager.createQuery(query).getResultList()) {
            Integer mdId = (Integer)result.get(0);
            User user = (User)result.get(1);
            results.add(Pair.read(mdId, user));
        }
        return results;
    }

    @Override
    @Nonnull
    public List<User> findAllUsersThatOwnMetadata() {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(User.class);
        Root metadataRoot = query.from(Metadata.class);
        Root userRoot = query.from(User.class);
        query.select((Selection)userRoot);
        Path ownerPath = metadataRoot.get(Metadata_.sourceInfo).get(MetadataSourceInfo_.owner);
        Predicate ownerExpression = cb.equal((Expression)ownerPath, (Expression)userRoot.get(User_.id));
        query.where((Expression)ownerExpression);
        query.distinct(true);
        return this.entityManager.createQuery(query).getResultList();
    }

    @Override
    @Nonnull
    public List<User> findAllUsersInUserGroups(@Nonnull Specification<UserGroup> userGroupSpec) {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(User.class);
        Root userGroupRoot = query.from(UserGroup.class);
        Root userRoot = query.from(User.class);
        query.select((Selection)userRoot);
        Path ownerPath = userGroupRoot.get(UserGroup_.id).get(UserGroupId_.userId);
        Predicate ownerExpression = cb.equal((Expression)ownerPath, (Expression)userRoot.get(User_.id));
        query.where((Expression)cb.and((Expression)ownerExpression, (Expression)userGroupSpec.toPredicate(userGroupRoot, query, cb)));
        query.distinct(true);
        return this.entityManager.createQuery(query).getResultList();
    }
}

