/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.repository;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.SingularAttribute;
import org.springframework.data.domain.Sort;

public class SortUtils {
    public static Path<?> toJPAPath(Sort.Order order, Root<?> ... roots) {
        String[] pathParts = order.getProperty().split("\\.");
        Path currentPathElement = null;
        for (String part : pathParts) {
            if (currentPathElement == null) {
                for (Root<?> root : roots) {
                    try {
                        currentPathElement = root.get(part);
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                }
                continue;
            }
            currentPathElement = currentPathElement.get(part);
        }
        return currentPathElement;
    }

    public static List<Order> sortToJpaOrders(CriteriaBuilder cb, Sort sort, Root<?> ... roots) {
        ArrayList<Order> orders = new ArrayList<Order>();
        for (Sort.Order order : sort) {
            Path<?> path = SortUtils.toJPAPath(order, roots);
            if (order.isAscending()) {
                orders.add(cb.asc(path));
                continue;
            }
            orders.add(cb.desc(path));
        }
        return orders;
    }

    public static String createPath(SingularAttribute<?, ?> ... attributes) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < attributes.length; ++i) {
            if (builder.length() > 0) {
                builder.append('.');
            }
            builder.append(attributes[i].getName());
        }
        return builder.toString();
    }

    public static Sort createSort(SingularAttribute<?, ?> ... attributes) {
        return Sort.by((String[])new String[]{SortUtils.createPath(attributes)});
    }

    public static Sort createSort(Sort.Direction direction, SingularAttribute<?, ?> ... attributes) {
        return Sort.by((Sort.Direction)direction, (String[])new String[]{SortUtils.createPath(attributes)});
    }
}

