/*
 * Decompiled with CFR 0.152.
 */
package net.opengis.gml311;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RelativePositionType implements Enumerator
{
    BEFORE(0, "Before", "Before"),
    AFTER(1, "After", "After"),
    BEGINS(2, "Begins", "Begins"),
    ENDS(3, "Ends", "Ends"),
    DURING(4, "During", "During"),
    EQUALS(5, "Equals", "Equals"),
    CONTAINS(6, "Contains", "Contains"),
    OVERLAPS(7, "Overlaps", "Overlaps"),
    MEETS(8, "Meets", "Meets"),
    OVERLAPPED_BY(9, "OverlappedBy", "OverlappedBy"),
    MET_BY(10, "MetBy", "MetBy"),
    BEGUN_BY(11, "BegunBy", "BegunBy"),
    ENDED_BY(12, "EndedBy", "EndedBy");

    public static final int BEFORE_VALUE = 0;
    public static final int AFTER_VALUE = 1;
    public static final int BEGINS_VALUE = 2;
    public static final int ENDS_VALUE = 3;
    public static final int DURING_VALUE = 4;
    public static final int EQUALS_VALUE = 5;
    public static final int CONTAINS_VALUE = 6;
    public static final int OVERLAPS_VALUE = 7;
    public static final int MEETS_VALUE = 8;
    public static final int OVERLAPPED_BY_VALUE = 9;
    public static final int MET_BY_VALUE = 10;
    public static final int BEGUN_BY_VALUE = 11;
    public static final int ENDED_BY_VALUE = 12;
    private static final RelativePositionType[] VALUES_ARRAY;
    public static final List<RelativePositionType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static RelativePositionType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            RelativePositionType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static RelativePositionType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            RelativePositionType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static RelativePositionType get(int value) {
        switch (value) {
            case 0: {
                return BEFORE;
            }
            case 1: {
                return AFTER;
            }
            case 2: {
                return BEGINS;
            }
            case 3: {
                return ENDS;
            }
            case 4: {
                return DURING;
            }
            case 5: {
                return EQUALS;
            }
            case 6: {
                return CONTAINS;
            }
            case 7: {
                return OVERLAPS;
            }
            case 8: {
                return MEETS;
            }
            case 9: {
                return OVERLAPPED_BY;
            }
            case 10: {
                return MET_BY;
            }
            case 11: {
                return BEGUN_BY;
            }
            case 12: {
                return ENDED_BY;
            }
        }
        return null;
    }

    private RelativePositionType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new RelativePositionType[]{BEFORE, AFTER, BEGINS, ENDS, DURING, EQUALS, CONTAINS, OVERLAPS, MEETS, OVERLAPPED_BY, MET_BY, BEGUN_BY, ENDED_BY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

