/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.utils;

import java.nio.file.Path;
import java.util.Vector;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.ProxyInfo;
import org.fao.geonet.utils.ProxyInfoObserver;
import org.fao.geonet.utils.ProxyParams;
import org.fao.geonet.utils.XmlResolver;
import org.fao.geonet.utils.nio.NioPathAwareCatalogResolver;

public final class Resolver
implements ProxyInfoObserver {
    private static int activeReaders = 0;
    private static int activeWriters = 0;
    private ProxyInfo proxyInfo;
    private XmlResolver xmlResolver;
    private CatalogResolver catResolver;
    private Path oasisCatalogPath;
    private String blankXSLFile;

    public Resolver() {
        this.oasisCatalogPath = null;
        this.beforeWrite();
        try {
            this.setUpXmlResolver();
        }
        finally {
            this.afterWrite();
        }
    }

    public Resolver(Path oasisCatalogPath) {
        this.oasisCatalogPath = oasisCatalogPath;
        this.beforeWrite();
        try {
            this.setUpXmlResolver();
        }
        finally {
            this.afterWrite();
        }
    }

    private void setUpXmlResolver() {
        CatalogManager catMan = new CatalogManager();
        catMan.setAllowOasisXMLCatalogPI(false);
        catMan.setCatalogClassName("org.apache.xml.resolver.Catalog");
        String catFiles = null;
        if (this.oasisCatalogPath == null) {
            catFiles = System.getProperty("jeeves.xml.catalog.files");
            if (catFiles == null) {
                catFiles = "";
            }
        } else {
            catFiles = this.oasisCatalogPath.toString();
        }
        if (Log.isDebugEnabled("jeeves")) {
            Log.debug("jeeves", "Using oasis catalog files " + catFiles);
        }
        this.setBlankXSLFile(System.getProperty("jeeves.xml.catalog.blankxslfile"));
        catMan.setCatalogFiles(catFiles);
        catMan.setIgnoreMissingProperties(true);
        catMan.setPreferPublic(true);
        catMan.setRelativeCatalogs(false);
        catMan.setUseStaticCatalog(false);
        String catVerbosity = System.getProperty("jeeves.xml.catalog.verbosity");
        if (catVerbosity == null) {
            catVerbosity = "1";
        }
        int iCatVerb = 1;
        try {
            iCatVerb = Integer.parseInt(catVerbosity);
        }
        catch (NumberFormatException nfe) {
            Log.error("jeeves", "Failed to parse jeeves.xml.catalog.verbosity " + catVerbosity, (Throwable)nfe);
        }
        if (Log.isDebugEnabled("jeeves")) {
            Log.debug("jeeves", "Using catalog resolver verbosity " + iCatVerb);
        }
        catMan.setVerbosity(iCatVerb);
        this.catResolver = new NioPathAwareCatalogResolver(catMan);
        Vector catalogs = this.catResolver.getCatalog().getCatalogManager().getCatalogFiles();
        String[] cats = new String[catalogs.size()];
        System.arraycopy(catalogs.toArray(), 0, cats, 0, catalogs.size());
        if (this.proxyInfo == null) {
            this.proxyInfo = new ProxyInfo();
        }
        ProxyParams proxyParams = this.proxyInfo.getProxyParams();
        this.xmlResolver = new XmlResolver(cats, proxyParams);
    }

    public void reset() {
        this.beforeWrite();
        try {
            this.setUpXmlResolver();
        }
        finally {
            this.afterWrite();
        }
    }

    public XmlResolver getXmlResolver() {
        this.beforeRead();
        try {
            XmlResolver xmlResolver = this.xmlResolver;
            return xmlResolver;
        }
        finally {
            this.afterRead();
        }
    }

    public CatalogResolver getCatalogResolver() {
        this.beforeRead();
        try {
            CatalogResolver catalogResolver = this.catResolver;
            return catalogResolver;
        }
        finally {
            this.afterRead();
        }
    }

    @Override
    public void update(ProxyInfo proxyInfo) {
        this.beforeWrite();
        try {
            this.proxyInfo = proxyInfo;
            proxyInfo.getProxyParams();
            this.setUpXmlResolver();
        }
        finally {
            this.afterWrite();
        }
    }

    private synchronized void beforeRead() {
        while (activeWriters > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        ++activeReaders;
    }

    private synchronized void afterRead() {
        --activeReaders;
        this.notifyAll();
    }

    private synchronized void beforeWrite() {
        while (activeReaders > 0 || activeWriters > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        ++activeWriters;
    }

    private synchronized void afterWrite() {
        --activeWriters;
        this.notifyAll();
    }

    public String getBlankXSLFile() {
        return this.blankXSLFile;
    }

    public void setBlankXSLFile(String blankXSLFile) {
        this.blankXSLFile = blankXSLFile;
    }
}

