/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.thesaurus;

import java.nio.file.Path;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.exceptions.TermNotFoundException;
import org.fao.geonet.kernel.KeywordBean;
import org.fao.geonet.kernel.Thesaurus;
import org.fao.geonet.kernel.ThesaurusFinder;
import org.fao.geonet.kernel.ThesaurusManager;
import org.fao.geonet.kernel.search.KeywordsSearcher;
import org.jdom.Content;
import org.jdom.Element;

public class GetTopConcept
implements Service {
    public void init(Path appPath, ServiceConfig params) throws Exception {
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        String sThesaurusName = Util.getParam((Element)params, (String)"thesaurus");
        String lang = Util.getParam((Element)params, (String)"lang", (String)context.getLanguage());
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        ThesaurusManager thesaurusMan = (ThesaurusManager)gc.getBean(ThesaurusManager.class);
        Element response = new Element("descKeys");
        Thesaurus the = thesaurusMan.getThesaurusByName(sThesaurusName);
        if (the == null) {
            return response;
        }
        String langForThesaurus = the.getIsoLanguageMapper().iso639_2_to_iso639_1(lang);
        KeywordsSearcher searcher = null;
        searcher = new KeywordsSearcher(context, (ThesaurusFinder)thesaurusMan);
        try {
            searcher.searchTopConcepts(sThesaurusName, new String[]{langForThesaurus});
            KeywordBean topConcept = new KeywordBean(the.getIsoLanguageMapper());
            topConcept.setThesaurusInfo(the);
            topConcept.setValue("topConcepts", langForThesaurus);
            topConcept.setUriCode(sThesaurusName);
            Element root = KeywordsSearcher.toRawElement((Element)response, (KeywordBean)topConcept);
            Element keywordType = new Element("narrower");
            for (KeywordBean kbr : searcher.getResults()) {
                keywordType.addContent((Content)kbr.toElement("eng", new String[]{context.getLanguage()}));
            }
            root.addContent((Content)keywordType);
        }
        catch (TermNotFoundException termNotFoundException) {
            // empty catch block
        }
        return response;
    }
}

