/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters;

import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.io.FileUtils;
import org.apache.jcs.access.exception.InvalidArgumentException;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.Constants;
import org.fao.geonet.ZipUtil;
import org.fao.geonet.api.records.formatters.AbstractFormatService;
import org.fao.geonet.api.records.formatters.ConfigFile;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.utils.FilePathChecker;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Xml;
import org.fao.oaipmh.exceptions.BadArgumentException;
import org.jdom.Content;
import org.jdom.Element;
import org.locationtech.jts.util.Assert;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="formatters", description="Formatter operations")
@Controller(value="formattersList")
public class FormatterAdminApi
extends AbstractFormatService {
    @Autowired
    GeonetworkDataDirectory dataDirectory;
    @Autowired
    SchemaManager schemaManager;
    private static final String[] extensions = new String[]{"properties", "xml", "xsl", "css", "js"};

    @Operation(summary="Get formatter files")
    @RequestMapping(method={RequestMethod.GET}, value={"/{portal}/api/formatters/{schema:.+}/{formatter}/files"}, produces={"application/json"})
    @ResponseBody
    @PreAuthorize(value="hasAuthority('UserAdmin')")
    public String getFormatterFiles(@PathVariable String formatter, @PathVariable String schema) throws Exception {
        Path schemaDir = null;
        if (schema != null && !"null".equals(schema)) {
            schemaDir = this.schemaManager.getSchemaDir(schema);
        }
        Path formatDir = this.getAndVerifyFormatDir(this.dataDirectory, "id", formatter, schemaDir).toRealPath(new LinkOption[0]);
        Element result = new Element("bundleFiles");
        this.makeTree("", formatDir, result);
        return Xml.getJSON((Element)result);
    }

    private void makeTree(String parentId, Path dir, Element result) throws IOException {
        try (DirectoryStream<Path> files = Files.newDirectoryStream(dir);){
            for (Path file : files) {
                Element element;
                String name = URLEncoder.encode(file.getFileName().toString(), Constants.ENCODING);
                String id = parentId + "/" + file.getFileName();
                if (Files.isDirectory(file, new LinkOption[0]) && this.legalFile(file)) {
                    element = new Element("dir");
                    this.makeTree(id, file, element);
                    if (element.getChildren().size() <= 0) continue;
                    element.setAttribute("leaf", "false");
                    element.setAttribute("text", file.getFileName().toString()).setAttribute("path", id).setAttribute("name", name);
                    result.addContent((Content)element);
                    continue;
                }
                if (!this.isEditibleFileType(file) || !this.legalFile(file)) continue;
                element = new Element("file");
                element.setAttribute("leaf", "true");
                element.setAttribute("text", file.getFileName().toString()).setAttribute("path", id).setAttribute("name", name);
                result.addContent((Content)element);
            }
        }
    }

    private boolean isEditibleFileType(Path f) {
        String fileName = f.getFileName().toString();
        for (String ext : extensions) {
            if (!fileName.endsWith("." + ext)) continue;
            return true;
        }
        return fileName.equalsIgnoreCase("README");
    }

    private boolean legalFile(Path f) throws IOException {
        return !f.getFileName().startsWith(".") && !Files.isHidden(f) && Files.isReadable(f) && Files.isWritable(f);
    }

    private void addFormatters(String schema, FormatterDataResponse response, Path root, Path file, boolean isSchemaPluginFormatter, boolean publishedOnly) throws IOException {
        if (!Files.exists(file, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(file, IO.DIRECTORIES_FILTER);){
            for (Path formatter : paths) {
                boolean add = true;
                if (FORMATTER_FILTER.accept(formatter)) {
                    ConfigFile config = new ConfigFile(formatter, true, null);
                    if (publishedOnly && !config.isPublished()) continue;
                    List<String> applicableSchemas = config.listOfApplicableSchemas();
                    if (!(schema.equalsIgnoreCase("all") || isSchemaPluginFormatter || applicableSchemas.contains(schema))) {
                        add = false;
                    }
                    if (!add) continue;
                    String path = root.relativize(formatter).toString().replace("\\", "/");
                    if (path.startsWith("/")) {
                        path = path.substring(1);
                    }
                    FormatterData formatterData = isSchemaPluginFormatter ? new FormatterData(schema, path) : new FormatterData(null, path);
                    response.add(formatterData);
                    continue;
                }
                this.addFormatters(schema, response, root, formatter, isSchemaPluginFormatter, publishedOnly);
            }
        }
    }

    @Operation(summary="Get formatters")
    @RequestMapping(method={RequestMethod.GET}, value={"/{portal}/api/formatters"}, produces={"application/json"})
    @ResponseBody
    @PreAuthorize(value="hasAuthority('UserAdmin')")
    public FormatterDataResponse listFormatters(@RequestParam(required=false) String id, @RequestParam(required=false) String uuid, @RequestParam(defaultValue="all") String schema, @RequestParam(defaultValue="false") boolean pluginOnly, @RequestParam(defaultValue="true") boolean publishedOnly) throws Exception {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        if (id != null || uuid != null) {
            try {
                this.loadMetadata((IMetadataUtils)applicationContext.getBean(IMetadataUtils.class), Integer.parseInt(this.resolveId(id, uuid)));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (schema == null) {
            schema = "all";
        }
        schema = schema.trim();
        FormatterDataResponse response = new FormatterDataResponse();
        if (!pluginOnly) {
            Path userXslDir = ((GeonetworkDataDirectory)applicationContext.getBean(GeonetworkDataDirectory.class)).getFormatterDir();
            this.addFormatters(schema, response, userXslDir, userXslDir, false, publishedOnly);
        }
        Set schemas = ((SchemaManager)applicationContext.getBean(SchemaManager.class)).getSchemas();
        for (String schemaName : schemas) {
            if (!schema.equals("all") && !schema.equals(schemaName)) continue;
            Path schemaDir = ((SchemaManager)applicationContext.getBean(SchemaManager.class)).getSchemaDir(schemaName);
            Path formatterDir = schemaDir.resolve("formatter");
            this.addFormatters(schemaName, response, formatterDir, formatterDir, true, publishedOnly);
        }
        return response;
    }

    @Operation(summary="Download a formatter as ZIP")
    @RequestMapping(method={RequestMethod.GET}, value={"/{portal}/api/formatters/{schema:.+}/{formatter}"}, produces={"application/zip"})
    @ResponseBody
    @PreAuthorize(value="hasAuthority('UserAdmin')")
    public void downloadFormatter(@PathVariable String formatter, @PathVariable String schema, @Parameter(hidden=true) HttpServletRequest request, @Parameter(hidden=true) HttpServletResponse response) throws Exception {
        Path schemaDir = null;
        if (schema != null && !"null".equals(schema)) {
            schemaDir = this.schemaManager.getSchemaDir(schema);
        }
        Path formatDir = this.getAndVerifyFormatDir(this.dataDirectory, "id", formatter, schemaDir);
        Path tmpDir = null;
        Path zippedFile = null;
        try {
            tmpDir = Files.createTempDirectory("gn-formatters-", new FileAttribute[0]);
            zippedFile = Files.createTempFile(tmpDir, formatter, ".zip", new FileAttribute[0]);
            try (FileSystem zipFs = ZipUtil.createZipFs((Path)zippedFile);
                 DirectoryStream<Path> paths = Files.newDirectoryStream(formatDir);){
                Path root = zipFs.getRootDirectories().iterator().next();
                for (Path path : paths) {
                    IO.copyDirectoryOrFile((Path)path, (Path)root, (boolean)true);
                }
            }
            response.setHeader("Content-Disposition", String.format("inline; filename=\"%s.zip\"", schema != null && !"null".equals(schema) ? schema + "-" + formatter : formatter));
            response.setHeader("Content-Length", String.valueOf(Files.size(zippedFile)));
            FileUtils.copyFile((File)zippedFile.toFile(), (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Error occurred while trying to download formatter bundle %s/%s.", schema, formatter));
        }
        finally {
            if (zippedFile != null) {
                FileUtils.deleteQuietly((File)zippedFile.toFile());
            }
            if (tmpDir != null) {
                FileUtils.deleteQuietly((File)tmpDir.toFile());
            }
        }
    }

    @Operation(summary="Delete a formatter")
    @RequestMapping(method={RequestMethod.DELETE}, value={"/{portal}/api/formatters/{schema:.+}/{formatter}"}, produces={"application/json"})
    @ResponseBody
    @PreAuthorize(value="hasAuthority('UserAdmin')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFormatter(@PathVariable String formatter, @PathVariable String schema) throws Exception {
        Path schemaDir = null;
        if (schema != null && !"null".equals(schema)) {
            schemaDir = this.schemaManager.getSchemaDir(schema);
        }
        Path formatDir = this.getAndVerifyFormatDir(this.dataDirectory, "id", formatter, schemaDir);
        try {
            IO.deleteFileOrDirectory((Path)formatDir);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Error occured while trying to remove the formatter %s/%s. Incorrect ID?", schema, formatter));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Import a XSLT formatter (usually a zip named 'schema-formatter.zip')")
    @RequestMapping(method={RequestMethod.POST}, value={"/{portal}/api/formatters"}, produces={"application/json"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    public void addFormatter(@RequestParam(value="file") MultipartFile[] file) throws Exception {
        for (MultipartFile f : file) {
            Path newBundle;
            String fileName = f.getOriginalFilename();
            String fileWithoutExtension = fileName.substring(0, fileName.indexOf("."));
            String[] tokens = fileWithoutExtension.split("-");
            String schema = tokens.length == 2 ? tokens[0] : null;
            String formatter = tokens.length == 2 ? tokens[1] : fileWithoutExtension;
            FilePathChecker.verify((String)schema);
            FilePathChecker.verify((String)formatter);
            FilePathChecker.verify((String)fileName);
            this.checkLegalId("id", formatter);
            if (schema != null && !"null".equals(schema)) {
                Path schemaDir = this.schemaManager.getSchemaDir(schema);
                newBundle = schemaDir.resolve("formatter").resolve(formatter);
                if (Files.exists(newBundle, new LinkOption[0])) {
                    throw new InvalidArgumentException(String.format("Formatter %s/%s already exists. Delete it first.", schema, formatter));
                }
            } else {
                Path userXslDir = this.dataDirectory.getFormatterDir();
                newBundle = userXslDir.resolve(formatter);
            }
            Path uploadedFile = this.dataDirectory.getUploadDir().resolve(fileName);
            byte[] data = ByteStreams.toByteArray((InputStream)f.getInputStream());
            Files.write(uploadedFile, data, new OpenOption[0]);
            try {
                Files.createDirectories(newBundle, new FileAttribute[0]);
                try (FileSystem zipFs = ZipUtil.openZipFs((Path)uploadedFile);){
                    Path root;
                    Path viewFile = this.findViewFile(zipFs);
                    if (viewFile == null) {
                        throw new BadArgumentException("A formatter zip file must contain a view.xsl file as one of its root files");
                    }
                    Path viewXslContainerDir = null;
                    Iterator<Path> iterator = zipFs.getRootDirectories().iterator();
                    while (iterator.hasNext() && (viewXslContainerDir = this.findViewXslContainerDir(root = iterator.next())) == null) {
                    }
                    if (viewXslContainerDir == null) {
                        throw new IllegalArgumentException(uploadedFile + " does not have a view.xsl file within it");
                    }
                    IO.copyDirectoryOrFile(viewXslContainerDir, (Path)newBundle, (boolean)false);
                }
                catch (IllegalArgumentException | UnsupportedOperationException e) {
                    this.handleRawXsl(uploadedFile, newBundle);
                }
                catch (Exception e) {
                    IO.deleteFileOrDirectory((Path)newBundle);
                    throw e;
                }
                this.addOptionalFiles(newBundle);
            }
            finally {
                IO.deleteFile((Path)uploadedFile, (boolean)false, (String)"geonetwork.formatter");
            }
        }
    }

    @Operation(summary="Get formatter file content")
    @RequestMapping(method={RequestMethod.GET}, value={"/{portal}/api/formatters/{schema:.+}/{formatter}/files/{file:.+}"}, produces={"text/plain"})
    @ResponseBody
    @PreAuthorize(value="hasAuthority('UserAdmin')")
    public String getFormatterFileContent(@PathVariable String formatter, @PathVariable String schema, @PathVariable String file) throws Exception {
        Path schemaDir = null;
        if (schema != null && !"null".equals(schema)) {
            schemaDir = this.schemaManager.getSchemaDir(schema);
        }
        FilePathChecker.verify((String)file);
        Path formatDir = this.getAndVerifyFormatDir(this.dataDirectory, "id", formatter, schemaDir);
        String absformatDir = formatDir.toAbsolutePath().toString();
        String absFile = formatDir.resolve(file).toAbsolutePath().toString();
        if (!absFile.startsWith(absformatDir)) {
            throw new BadParameterEx("file", (Object)file);
        }
        Path filePath = formatDir.resolve(file);
        if (!Files.exists(filePath, new LinkOption[0])) {
            throw new BadParameterEx("file", (Object)file);
        }
        return new String(Files.readAllBytes(formatDir.resolve(file)), Constants.ENCODING);
    }

    @Operation(summary="Update formatter file")
    @RequestMapping(value={"/{portal}/api/formatters/{schema:.+}/{formatter}/files/{file:.+}"}, produces={"text/plain"}, method={RequestMethod.POST})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    @PreAuthorize(value="hasAuthority('UserAdmin')")
    public void updateFormatterFile(@PathVariable String formatter, @PathVariable String schema, @PathVariable String file, @RequestParam(required=true) String data) throws Exception {
        Path schemaDir = null;
        if (schema != null && !"null".equals(schema)) {
            schemaDir = this.schemaManager.getSchemaDir(schema);
        }
        Path formatDir = this.getAndVerifyFormatDir(this.dataDirectory, "id", formatter, schemaDir);
        FilePathChecker.verify((String)file);
        Path toUpdate = formatDir.resolve(file);
        Files.write(toUpdate, Collections.singleton(data), Constants.CHARSET, new OpenOption[0]);
    }

    private Path findViewXslContainerDir(Path dir) throws IOException {
        if (Files.exists(dir.resolve("view.xsl"), new LinkOption[0])) {
            return dir;
        }
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(dir, IO.DIRECTORIES_FILTER);){
            for (Path childDir : paths) {
                Path container = this.findViewXslContainerDir(childDir);
                if (container == null) continue;
                Path path = container;
                return path;
            }
        }
        return null;
    }

    private Path findViewFile(FileSystem zipFs) throws IOException {
        Path rootView = zipFs.getPath("view.xsl", new String[0]);
        if (Files.exists(rootView, new LinkOption[0])) {
            return rootView;
        }
        String groovyView = "view.groovy";
        rootView = zipFs.getPath("view.groovy", new String[0]);
        if (Files.exists(rootView, new LinkOption[0])) {
            return rootView;
        }
        Path rootDir = zipFs.getRootDirectories().iterator().next();
        try (DirectoryStream<Path> dirs = Files.newDirectoryStream(rootDir, IO.DIRECTORIES_FILTER);){
            Iterator<Path> dirIter = dirs.iterator();
            if (dirIter.hasNext()) {
                Path next = dirIter.next();
                Assert.isTrue((!dirIter.hasNext() ? 1 : 0) != 0, (String)"The formatter/view zip file must either have a single root directory which contains the view file or it must have all formatter resources at the root of the directory");
                rootView = next.resolve("view.xsl");
                if (Files.exists(rootView, new LinkOption[0])) {
                    Path path = rootView;
                    return path;
                }
                rootView = next.resolve("view.groovy");
                if (Files.exists(rootView, new LinkOption[0])) {
                    Path path = rootView;
                    return path;
                }
            }
        }
        return null;
    }

    private void addOptionalFiles(Path file) throws IOException {
        ConfigFile.generateDefault(file);
        Path locDir = file.resolve("loc");
        if (!Files.exists(locDir, new LinkOption[0])) {
            Files.createDirectories(locDir, new FileAttribute[0]);
            try (PrintStream out = new PrintStream(Files.newOutputStream(locDir.resolve("README"), new OpenOption[0]), true, Constants.ENCODING);){
                out.println("If a formatter requires localization that cannot be found in strings or schema ");
                out.println("localization the format bundle can have a loc subfolder containing translations.");
                out.println();
                out.println("The xml document created will have the xml files from loc/<currentLoc>/ added to");
                out.println("xml documentation under the /root/resources tag.");
                out.println();
                out.println("If a localization folder is not found then the default language will be used.  ");
                out.println("if the default language also does not exist then the first localization will be used");
                out.println("but it is recommended to always have the default language localization");
                out.println("(unless language is fixed in the config.properties)");
            }
        }
    }

    private void handleRawXsl(Path uploadedFile, Path dir) throws IOException {
        Files.createDirectories(dir, new FileAttribute[0]);
        IO.moveDirectoryOrFile((Path)uploadedFile, (Path)dir.resolve("view.xsl"), (boolean)false);
    }

    @XmlRootElement(name="formatter")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static final class FormatterData
    implements Serializable {
        private static final long serialVersionUID = 2015204126746590712L;
        @XmlElement(name="schema")
        private final String schema;
        private final String id;

        public FormatterData(String schema, String id) {
            this.schema = schema;
            this.id = id;
        }

        public String toString() {
            return "FormatterData{schema ='" + this.schema + '\'' + ", id='" + this.id + '\'' + '}';
        }

        public String getSchema() {
            return this.schema;
        }

        public String getId() {
            return this.id;
        }
    }

    @XmlRootElement(name="formatters")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static final class FormatterDataResponse
    implements Serializable {
        private static final long serialVersionUID = 8674269207113596010L;
        @XmlElement(name="formatter")
        private final List<FormatterData> formatters = Lists.newArrayList();

        public void add(FormatterData formatterData) {
            this.formatters.add(formatterData);
        }

        public String toString() {
            return "FormatterDataResponse{" + this.formatters + '}';
        }

        public List<FormatterData> getFormatters() {
            return this.formatters;
        }
    }
}

