/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import jeeves.server.context.ServiceContext;
import jeeves.services.ReadWriteController;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.records.formatters.FormatType;
import org.fao.geonet.api.records.formatters.FormatterApi;
import org.fao.geonet.api.records.formatters.FormatterWidth;
import org.fao.geonet.api.records.formatters.cache.Key;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Source;
import org.fao.geonet.events.history.RecordValidationTriggeredEvent;
import org.fao.geonet.inspire.validator.InspireValidationRunnable;
import org.fao.geonet.inspire.validator.InspireValidatorUtils;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.EditLib;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.SourceRepository;
import org.fao.geonet.schema.iso19139.ISO19139Namespaces;
import org.fao.geonet.util.ThreadPool;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.NativeWebRequest;

@RequestMapping(value={"/{portal}/api/records"})
@Tag(name="records", description="Metadata record operations")
@Controller(value="inspire")
@PreAuthorize(value="hasAuthority('Editor')")
@ReadWriteController
public class InspireValidationApi {
    public static final String API_PARAM_INSPIRE_VALIDATION_MODE = "Define the encoding of the record to use. By default, ISO19139 are used as is and ISO19115-3 are converted to ISO19139.If mode = csw, a GetRecordById request is used.If mode = any portal id, then a GetRecordById request is used on this portal CSW entry point which may define custom CSW post processing. See https://github.com/geonetwork/core-geonetwork/pull/4493.";
    @Autowired
    SettingManager settingManager;
    @Autowired
    InspireValidatorUtils inspireValidatorUtils;
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    SourceRepository sourceRepository;
    String supportedSchemaRegex = "(iso19139|iso19115-3).*";
    @Autowired
    private SchemaManager schemaManager;
    @Autowired
    private ThreadPool threadPool;

    @Operation(summary="Get test suites available.", description="TG13, TG2, ...")
    @GetMapping(value={"/{metadataUuid}/validate/inspire/testsuites"}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of testsuites available."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseBody
    public Map<String, String[]> getTestSuites(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid) {
        return this.inspireValidatorUtils.getTestsuites();
    }

    @Operation(summary="Submit a record to the INSPIRE service for validation.", description="User MUST be able to edit the record to validate it. An INSPIRE endpoint must be configured in Settings. This activates an asyncronous process, this method does not return any report. This method returns an id to be used to get the report.")
    @PutMapping(value={"/{metadataUuid}/validate/inspire"}, produces={"text/plain"})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Check status of the report."), @ApiResponse(responseCode="404", description="Metadata not found."), @ApiResponse(responseCode="500", description="Service unavailable."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseBody
    public String validateRecordForInspire(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Test suite to run", required=false) @RequestParam String testsuite, @Parameter(description="Define the encoding of the record to use. By default, ISO19139 are used as is and ISO19115-3 are converted to ISO19139.If mode = csw, a GetRecordById request is used.If mode = any portal id, then a GetRecordById request is used on this portal CSW entry point which may define custom CSW post processing. See https://github.com/geonetwork/core-geonetwork/pull/4493.", required=false) @RequestParam(required=false) String mode, HttpServletResponse response, @Parameter(hidden=true) HttpServletRequest request, @Parameter(hidden=true) NativeWebRequest nativeRequest, @Parameter(hidden=true) HttpSession session) throws Exception {
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        new RecordValidationTriggeredEvent(Integer.valueOf(metadata.getId()), Integer.valueOf(ApiUtils.getUserSession(request.getSession()).getUserIdAsInt()), null).publish((ApplicationContext)appContext);
        if (metadata == null) {
            response.setStatus(404);
            return "";
        }
        String schema = metadata.getDataInfo().getSchemaId();
        if (!schema.matches(this.supportedSchemaRegex)) {
            response.setStatus(406);
            return String.format("INSPIRE validator does not support records in schema '%s'. Schema must match expression '%s' and have an ISO19139 formatter.", schema, this.supportedSchemaRegex);
        }
        String id = String.valueOf(metadata.getId());
        String inspireValidatorUrl = this.settingManager.getValue("system/inspire/remotevalidation/url");
        String inspireValidatorQueryUrl = this.settingManager.getValue("system/inspire/remotevalidation/urlquery");
        if (StringUtils.isEmpty((String)inspireValidatorQueryUrl)) {
            inspireValidatorQueryUrl = inspireValidatorUrl;
        }
        ServiceContext context = ApiUtils.createServiceContext(request);
        String getRecordByIdUrl = null;
        String testId = null;
        Element md = (Element)ApiUtils.getUserSession(session).getProperty("metadata.editing" + id);
        if (md == null) {
            response.setStatus(404);
            return String.format("Metadata with id '%s' not found in session. To be validated, the record must be in edition session.", id);
        }
        if (StringUtils.isEmpty((String)mode)) {
            if (!schema.equals("iso19139")) {
                try {
                    Key key = new Key(metadata.getId(), "eng", FormatType.xml, "iso19139", true, FormatterWidth._100);
                    FormatterApi formatterApi = new FormatterApi();
                    formatterApi.getClass();
                    FormatterApi.FormatMetadata formatMetadata = new FormatterApi.FormatMetadata(formatterApi, context, key, nativeRequest);
                    byte[] data = formatMetadata.call().data;
                    md = Xml.loadString((String)new String(data, StandardCharsets.UTF_8), (boolean)false);
                }
                catch (Exception e) {
                    response.setStatus(404);
                    return String.format("Metadata with id '%s' is in schema '%s'. No iso19139 formatter found. Error is %s", id, schema, e.getMessage());
                }
            } else {
                EditLib editLib = ((DataManager)appContext.getBean(DataManager.class)).getEditLib();
                editLib.removeEditingInfo(md);
                editLib.contractElements(md);
            }
            md.detach();
            Attribute schemaLocAtt = this.schemaManager.getSchemaLocation("iso19139", context);
            if (schemaLocAtt != null && md.getAttribute(schemaLocAtt.getName(), schemaLocAtt.getNamespace()) == null) {
                md.setAttribute(schemaLocAtt);
                md.removeNamespaceDeclaration(schemaLocAtt.getNamespace());
                md.addNamespaceDeclaration(schemaLocAtt.getNamespace());
            }
            InputStream metadataToTest = this.convertElement2InputStream(md);
            testId = this.inspireValidatorUtils.submitFile(context, inspireValidatorUrl, inspireValidatorQueryUrl, metadataToTest, testsuite, metadata.getUuid());
        } else {
            String portal = "srv";
            if (!"srv".equals(mode)) {
                Source source = this.sourceRepository.findOneByUuid(mode);
                if (source == null) {
                    response.setStatus(404);
                    return String.format("Portal %s not found. There is no CSW endpoint at this URL that we can send to the validator.", mode);
                }
                portal = mode;
            }
            getRecordByIdUrl = String.format("%s%s/eng/csw?SERVICE=CSW&REQUEST=GetRecordById&VERSION=2.0.2&OUTPUTSCHEMA=%s&ELEMENTSETNAME=full&ID=%s", this.settingManager.getBaseURL(), portal, ISO19139Namespaces.GMD.getURI(), metadataUuid);
            testId = this.inspireValidatorUtils.submitUrl(context, inspireValidatorUrl, inspireValidatorQueryUrl, getRecordByIdUrl, testsuite, metadata.getUuid());
        }
        this.threadPool.runTask((Runnable)new InspireValidationRunnable(context, inspireValidatorUrl, testId, metadata.getId()));
        return testId;
    }

    private InputStream convertElement2InputStream(Element md) throws TransformerFactoryConfigurationError, TransformerException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        XMLOutputter xmlOutput = new XMLOutputter();
        try {
            xmlOutput.output(new Document(md), (OutputStream)outputStream);
        }
        catch (IOException e) {
            Log.error((String)"jeeves.service", (String)"Error in conversion of document before sending", (Throwable)e);
        }
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    @Operation(summary="Check the status of validation with the INSPIRE service.", description="User MUST be able to edit the record to validate it. An INSPIRE endpoint must be configured in Settings. If the process is complete an object with status is returned. ")
    @GetMapping(value={"/{testId}/validate/inspire"}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Report ready."), @ApiResponse(responseCode="201", description="Report not ready."), @ApiResponse(responseCode="404", description="Report id not found."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseBody
    public Map<String, String> checkValidation(@Parameter(description="Test identifier", required=true) @PathVariable String testId, HttpServletRequest request, @Parameter(hidden=true) HttpServletResponse response, @Parameter(hidden=true) HttpSession session) throws Exception {
        String inspireValidatorUrl = this.settingManager.getValue("system/inspire/remotevalidation/url");
        ServiceContext context = ApiUtils.createServiceContext(request);
        try {
            if (this.inspireValidatorUtils.isReady(context, inspireValidatorUrl, testId)) {
                HashMap<String, String> values = new HashMap<String, String>();
                values.put("status", this.inspireValidatorUtils.isPassed(context, inspireValidatorUrl, testId));
                values.put("report", this.inspireValidatorUtils.getReportUrl(inspireValidatorUrl, testId));
                response.setStatus(200);
                return values;
            }
        }
        catch (ResourceNotFoundException e) {
            response.setStatus(404);
            return new HashMap<String, String>();
        }
        catch (Exception e) {
            response.setStatus(500);
            return new HashMap<String, String>();
        }
        response.setStatus(201);
        return new HashMap<String, String>();
    }
}

