/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records;

import com.google.common.collect.ImmutableSet;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import jeeves.services.ReadWriteController;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.elasticsearch.action.search.SearchResponse;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.records.MetadataUtils;
import org.fao.geonet.api.records.model.related.AssociatedRecord;
import org.fao.geonet.api.records.model.related.RelatedItemType;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.guiapi.search.XsltResponseWriter;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.SelectionManager;
import org.fao.geonet.kernel.ThesaurusManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.mef.MEFLib;
import org.fao.geonet.kernel.search.EsFilterBuilder;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.fao.geonet.kernel.setting.SettingInfo;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.languages.IsoLanguagesMapper;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.util.XslUtil;
import org.fao.geonet.utils.Log;
import org.fao.geonet.web.DefaultLanguage;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/{portal}/api/records"})
@Tag(name="records", description="Metadata record operations")
@Controller(value="catalogs")
@ReadWriteController
public class CatalogApi {
    public static Set<String> FIELDLIST_PDF = ImmutableSet.builder().add((Object)"id").add((Object)"uuid").add((Object)"tag").add((Object)"codelist_spatialRepresentationType_text").add((Object)"codelist_maintenanceAndUpdateFrequency_text").add((Object)"format").add((Object)"overview").add((Object)"link").add((Object)"standardName").add((Object)"schema").add((Object)"geom").add((Object)"sourceCatalogue").add((Object)"changeDate").add((Object)"resourceTitleObject").add((Object)"resourceAbstractObject").build();
    @Autowired
    DefaultLanguage defaultLanguage;
    @Autowired
    ThesaurusManager thesaurusManager;
    @Autowired
    MetadataRepository metadataRepository;
    @Autowired
    IMetadataUtils metadataUtils;
    @Autowired
    SchemaManager schemaManager;
    @Autowired
    DataManager dataManager;
    @Autowired
    GeonetworkDataDirectory dataDirectory;
    @Autowired
    SettingManager settingManager;
    @Autowired
    EsSearchManager searchManager;
    @Autowired
    AccessManager accessManage;
    @Autowired
    SettingInfo settingInfo;
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    IsoLanguagesMapper isoLanguagesMapper;
    @Autowired
    private ServletContext servletContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Get a set of metadata records as ZIP", description="Metadata Exchange Format (MEF) is returned. MEF is a ZIP file containing the metadata as XML and some others files depending on the version requested. See https://docs.geonetwork-opensource.org/latest/annexes/mef-format/.")
    @RequestMapping(value={"/zip"}, method={RequestMethod.GET}, consumes={"*/*"}, produces={"application/zip", "application/x-gn-mef-1-zip", "application/x-gn-mef-2-zip"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Return requested records as ZIP."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to view the resource.")})
    @ResponseBody
    public void exportAsMef(@Parameter(description="Record UUIDs. If null current selection is used.", required=false, example="") @RequestParam(required=false) String[] uuids, @Parameter(description="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @Parameter(description="MEF file format.", required=false) @RequestParam(required=false, defaultValue="FULL") MEFLib.Format format, @Parameter(description="With related records (parent and service).", required=false) @RequestParam(required=false, defaultValue="false") boolean withRelated, @Parameter(description="Resolve XLinks in the records.", required=false) @RequestParam(required=false, defaultValue="true") boolean withXLinksResolved, @Parameter(description="Preserve XLink URLs in the records.", required=false) @RequestParam(required=false, defaultValue="false") boolean withXLinkAttribute, @RequestParam(required=false, defaultValue="true") boolean addSchemaLocation, @Parameter(description="Download the approved version", required=false) @RequestParam(required=false, defaultValue="true") boolean approved, @Parameter(hidden=true) HttpSession httpSession, @Parameter(hidden=true) HttpServletResponse response, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        Path file = null;
        Path stylePath = this.dataDirectory.getWebappDir().resolve("xml/schemas/");
        UserSession session = ApiUtils.getUserSession(httpSession);
        Set<String> uuidList = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, session);
        Log.info((String)"geonetwork.mef", (Object)"Create export task for selected metadata(s).");
        SelectionManager selectionManger = SelectionManager.getManager((UserSession)session);
        Log.info((String)"geonetwork.mef", (Object)("Current record(s) in selection: " + uuidList.size()));
        ServiceContext context = ApiUtils.createServiceContext(request);
        String acceptHeader = StringUtils.isBlank((String)request.getHeader("Accept")) ? "application/x-gn-mef-2-zip" : request.getHeader("Accept");
        MEFLib.Version version = MEFLib.Version.find((String)acceptHeader);
        if (version == MEFLib.Version.V1) {
            throw new IllegalArgumentException("MEF version 1 only support one record. Use the /records/{uuid}/formatters/zip to retrieve that format");
        }
        Set<String> allowedUuid = new HashSet<String>();
        for (String uuid : uuidList) {
            try {
                ApiUtils.canViewRecord(uuid, request);
                allowedUuid.add(uuid);
            }
            catch (Exception e) {
                Log.debug((String)"geonetwork.api", (Object)String.format("Not allowed to export record '%s'.", uuid));
            }
        }
        selectionManger.close("metadata");
        selectionManger.addAllSelection("metadata", allowedUuid);
        if (withRelated) {
            int maxhits = Integer.parseInt(this.settingInfo.getSelectionMaxRecords());
            HashSet tmpUuid = new HashSet();
            for (String uuid : allowedUuid) {
                Map<RelatedItemType, List<AssociatedRecord>> associated = MetadataUtils.getAssociated(context, (AbstractMetadata)this.metadataRepository.findOneByUuid(uuid), RelatedItemType.values(), 0, maxhits);
                associated.forEach((type, list) -> list.forEach(r -> tmpUuid.add(r.getUuid())));
            }
            if (selectionManger.addAllSelection("metadata", tmpUuid)) {
                Log.info((String)"geonetwork.mef", (Object)"Child and services added into the selection");
            }
            allowedUuid = selectionManger.getSelection("metadata");
        }
        Log.info((String)"geonetwork.mef", (Object)("Building MEF2 file with " + uuidList.size() + " records."));
        try {
            file = MEFLib.doMEF2Export((ServiceContext)context, allowedUuid, (String)format.toString(), (boolean)false, (Path)stylePath, (boolean)withXLinksResolved, (boolean)withXLinkAttribute, (boolean)false, (boolean)addSchemaLocation, (boolean)approved);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HHmmss");
            String fileName = String.format("%s-%s.zip", this.settingManager.getSiteName().replace(" ", ""), df.format(new Date()));
            response.setHeader("Content-Disposition", String.format("inline; filename=\"%s\"", fileName));
            response.setHeader("Content-Length", String.valueOf(Files.size(file)));
            response.setContentType("application/x-gn-mef-2-zip");
            FileUtils.copyFile((File)file.toFile(), (OutputStream)response.getOutputStream());
        }
        finally {
            selectionManger.close("metadata");
            if (file != null) {
                FileUtils.deleteQuietly((File)file.toFile());
            }
        }
    }

    @Operation(summary="Get a set of metadata records as PDF", description="The PDF is a short summary of each records with links to the complete metadata record in different format (ie. landing page on the portal, XML)")
    @RequestMapping(value={"/pdf"}, method={RequestMethod.GET}, consumes={"*/*"}, produces={"application/pdf"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Return requested records as PDF."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to view the resource.")})
    @ResponseBody
    public void exportAsPdf(@Parameter(description="Record UUIDs. If null current selection is used.", required=false, example="") @RequestParam(required=false) String[] uuids, @Parameter(description="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @RequestParam(required=false, defaultValue="eng") String language, @Parameter(hidden=true) @RequestParam Map<String, String> allRequestParams, @Parameter(hidden=true) HttpSession httpSession, @Parameter(hidden=true) HttpServletResponse httpResponse, @Parameter(hidden=true) HttpServletRequest httpRequest) throws Exception {
        UserSession session = ApiUtils.getUserSession(httpSession);
        Set<String> uuidList = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, session);
        int maxhits = Integer.parseInt(this.settingInfo.getSelectionMaxRecords());
        SearchResponse searchResponse = this.searchManager.query(String.format("uuid:(\"%s\") AND NOT draft:\"y\"", String.join((CharSequence)"\" OR \"", uuidList)), EsFilterBuilder.buildPermissionsFilter((ServiceContext)ApiUtils.createServiceContext(httpRequest)), FIELDLIST_PDF, 0, maxhits);
        HashMap<String, Object> params = new HashMap<String, Object>();
        Element request = new Element("request");
        allRequestParams.forEach((key, value) -> {
            Element n = new Element(key);
            n.setText(value);
            request.addContent((Content)n);
        });
        if (!this.languageUtils.getUiLanguages().contains(language)) {
            language = this.languageUtils.getDefaultUiLanguage();
        }
        String langCode = "lang" + language;
        Element response = new Element("response");
        Arrays.asList(searchResponse.getHits().getHits()).forEach(h -> {
            Element r = new Element("metadata");
            Map source = h.getSourceAsMap();
            source.forEach((key, v) -> {
                if (v instanceof String) {
                    Element t = new Element(key);
                    t.setText((String)v);
                    r.addContent((Content)t);
                } else if (v instanceof HashMap && key.endsWith("Object")) {
                    Element t = new Element(key);
                    HashMap textFields = (HashMap)v;
                    String textValue = textFields.get(langCode) != null ? (String)textFields.get(langCode) : (String)textFields.get("default");
                    t.setText(textValue);
                    r.addContent((Content)t);
                } else if (v instanceof ArrayList && key.equals("link")) {
                    ((ArrayList)v).forEach(i -> {
                        Element t = new Element(key);
                        HashMap linkProperties = (HashMap)i;
                        t.setText((String)linkProperties.get("description") + "|" + (String)linkProperties.get("name") + "|" + (String)linkProperties.get("url") + "|" + (String)linkProperties.get("protocol"));
                        r.addContent((Content)t);
                    });
                } else if (v instanceof HashMap && key.equals("overview")) {
                    Element t = new Element(key);
                    HashMap overviewProperties = (HashMap)v;
                    t.setText((String)overviewProperties.get("url") + "|" + (String)overviewProperties.get("name"));
                    r.addContent((Content)t);
                } else if (v instanceof ArrayList) {
                    ((ArrayList)v).forEach(i -> {
                        if (i instanceof HashMap && key.equals("overview")) {
                            Element t = new Element(key);
                            HashMap overviewProperties = (HashMap)i;
                            t.setText((String)overviewProperties.get("url") + "|" + (String)overviewProperties.get("name"));
                            r.addContent((Content)t);
                        } else if (i instanceof HashMap) {
                            Element t = new Element(key);
                            HashMap tags = (HashMap)i;
                            t.setText((String)tags.get("default"));
                            r.addContent((Content)t);
                        } else {
                            Element t = new Element(key);
                            t.setText((String)i);
                            r.addContent((Content)t);
                        }
                    });
                } else if (v instanceof HashMap && key.equals("geom")) {
                    Element t = new Element(key);
                    t.setText(((HashMap)v).get("coordinates").toString());
                    r.addContent((Content)t);
                } else if (!(v instanceof HashMap)) {
                    Element t = new Element(key);
                    t.setText(v.toString());
                    r.addContent((Content)t);
                }
            });
            response.addContent((Content)r);
        });
        String language2Code = XslUtil.twoCharLangCode((String)language, (String)"eng").toLowerCase();
        new XsltResponseWriter("env", "search", language).withJson(String.format("catalog/locales/%s-v4.json", language2Code)).withJson(String.format("catalog/locales/%s-core.json", language2Code)).withJson(String.format("catalog/locales/%s-search.json", language2Code)).withXml(response).withParams(params).withXsl("xslt/services/pdf/portal-present-fop.xsl").asPdf(httpResponse, this.replaceFilenamePlaceholder(this.settingManager.getValue("metadata/pdfReport/pdfName"), "pdf"));
    }

    @Operation(summary="Get a set of metadata records as CSV", description="The CSV is a short summary of each records.")
    @RequestMapping(value={"/csv"}, method={RequestMethod.GET}, consumes={"*/*"}, produces={"text/csv"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Return requested records as CSV."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to view the resource.")})
    @ResponseBody
    public void exportAsCsv(@Parameter(description="Record UUIDs. If null current selection is used.", required=false, example="") @RequestParam(required=false) String[] uuids, @Parameter(description="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @RequestParam(required=false, defaultValue="eng") String language, @Parameter(hidden=true) @RequestParam Map<String, String> allRequestParams, @Parameter(hidden=true) HttpSession httpSession, @Parameter(hidden=true) HttpServletResponse httpResponse, @Parameter(hidden=true) HttpServletRequest httpRequest) throws Exception {
        UserSession session = ApiUtils.getUserSession(httpSession);
        Set<String> uuidList = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, session);
        int maxhits = Integer.parseInt(this.settingInfo.getSelectionMaxRecords());
        ServiceContext context = ApiUtils.createServiceContext(httpRequest);
        SearchResponse searchResponse = this.searchManager.query(String.format("uuid:(\"%s\")", String.join((CharSequence)"\" or \"", uuidList)), EsFilterBuilder.buildPermissionsFilter((ServiceContext)ApiUtils.createServiceContext(httpRequest)), EsSearchManager.FIELDLIST_CORE, 0, maxhits);
        Element response = new Element("response");
        Arrays.asList(searchResponse.getHits().getHits()).forEach(h -> {
            try {
                response.addContent((Content)this.dataManager.getMetadata(context, (String)h.getSourceAsMap().get("id"), false, false, false));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        if (!this.languageUtils.getUiLanguages().contains(language)) {
            language = this.languageUtils.getDefaultUiLanguage();
        }
        Element r = new XsltResponseWriter(null, "search", language).withParams(allRequestParams.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).withXml(response).withXsl("xslt/services/csv/csv-search.xsl").asElement();
        String fileName = this.replaceFilenamePlaceholder(this.settingManager.getValue("metadata/csvReport/csvName"), "csv");
        httpResponse.setContentType("text/csv");
        httpResponse.addHeader("Content-Disposition", "attachment; filename=" + fileName);
        httpResponse.setContentLength(r.getText().length());
        httpResponse.getWriter().write(r.getText());
    }

    private String replaceFilenamePlaceholder(String fileName, String extension) {
        if (StringUtils.isEmpty((String)fileName)) {
            fileName = "document." + extension;
        } else {
            if (!fileName.endsWith("." + extension)) {
                fileName = fileName + "." + extension;
            }
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("siteName", this.settingManager.getSiteName());
            Calendar c = Calendar.getInstance();
            values.put("year", c.get(1) + "");
            values.put("month", c.get(2) + "");
            values.put("day", c.get(5) + "");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
            SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            values.put("date", dateFormat.format(c.getTime()));
            values.put("datetime", datetimeFormat.format(c.getTime()));
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HHmmss");
            values.put("ISOdatetime", df.format(new Date()));
            StrSubstitutor sub = new StrSubstitutor(values, "{", "}");
            fileName = sub.replace(fileName);
        }
        return fileName;
    }
}

