/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.page.Page;

public class PageProperties
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String language;
    private String pageId;
    private List<Page.PageSection> sections;
    private Page.PageStatus status;
    private String link;
    private String content;
    private String label;
    private Page.PageFormat format;
    private List<String> groups;
    private Page page;

    public PageProperties() {
    }

    public PageProperties(Page p) {
        this.page = p;
        this.language = p.getPageIdentity().getLanguage();
        this.pageId = p.getPageIdentity().getLinkText();
        this.format = p.getFormat();
        this.link = p.getLink();
        this.sections = p.getSections();
        this.status = p.getStatus();
        this.label = p.getLabel();
        if (CollectionUtils.isNotEmpty((Collection)p.getGroups())) {
            this.groups = new ArrayList<String>();
            for (Group g : p.getGroups()) {
                this.groups.add(g.getName());
            }
        }
    }

    public String toString() {
        return String.format("Entity of type %s with id: %s", this.getClass().getName(), this.getPageId());
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getPageId() {
        return this.pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public List<Page.PageSection> getSections() {
        return this.sections;
    }

    public void setSections(List<Page.PageSection> sections) {
        this.sections = sections;
    }

    public Page.PageStatus getStatus() {
        return this.status;
    }

    public void setStatus(Page.PageStatus status) {
        this.status = status;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Page.PageFormat getFormat() {
        return this.format;
    }

    public void setFormat(Page.PageFormat format) {
        this.format = format;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }
}

