/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.ecql;

import java.io.StringReader;
import java.util.List;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.text.commons.ICompiler;
import org.geotools.filter.text.commons.IToken;
import org.geotools.filter.text.commons.Result;
import org.geotools.filter.text.commons.TokenAdapter;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQLFilterBuilder;
import org.geotools.filter.text.generated.parsers.ECQLParser;
import org.geotools.filter.text.generated.parsers.Node;
import org.geotools.filter.text.generated.parsers.ParseException;
import org.geotools.filter.text.generated.parsers.TokenMgrError;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.BinaryExpression;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.DistanceBufferOperator;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.During;

public class ECQLCompiler
extends ECQLParser
implements ICompiler {
    private static final String ATTRIBUTE_PATH_SEPARATOR = "/";
    private final String source;
    private final ECQLFilterBuilder builder;

    public ECQLCompiler(String txtSource, FilterFactory filterFactory) {
        super(new StringReader(txtSource));
        assert (filterFactory != null) : "filterFactory cannot be null";
        this.source = txtSource;
        this.builder = new ECQLFilterBuilder(txtSource, filterFactory);
    }

    @Override
    public void compileFilter() throws CQLException {
        try {
            super.FilterCompilationUnit();
        }
        catch (TokenMgrError tokenError) {
            throw new CQLException(tokenError.getMessage(), this.getTokenInPosition(0), this.source);
        }
        catch (CQLException e) {
            throw e;
        }
        catch (ParseException e) {
            throw new CQLException(e.getMessage(), this.getTokenInPosition(0), e.getCause(), this.source);
        }
    }

    @Override
    public void compileExpression() throws CQLException {
        try {
            super.ExpressionCompilationUnit();
        }
        catch (TokenMgrError tokenError) {
            throw new CQLException(tokenError.getMessage(), this.getTokenInPosition(0), this.source);
        }
        catch (CQLException e) {
            throw e;
        }
        catch (ParseException e) {
            throw new CQLException(e.getMessage(), this.getTokenInPosition(0), e.getCause(), this.source);
        }
    }

    @Override
    public void compileFilterList() throws CQLException {
        try {
            super.FilterListCompilationUnit();
        }
        catch (TokenMgrError tokenError) {
            throw new CQLException(tokenError.getMessage(), this.getTokenInPosition(0), this.source);
        }
        catch (CQLException e) {
            throw e;
        }
        catch (ParseException e) {
            throw new CQLException(e.getMessage(), this.getTokenInPosition(0), e.getCause(), this.source);
        }
    }

    @Override
    public final String getSource() {
        return this.source;
    }

    @Override
    public final Filter getFilter() throws CQLException {
        return this.builder.getFilter();
    }

    @Override
    public final Expression getExpression() throws CQLException {
        return this.builder.getExpression();
    }

    @Override
    public IToken getTokenInPosition(int index) {
        return TokenAdapter.newAdapterFor(super.getToken(index));
    }

    @Override
    public List<Filter> getFilterList() throws CQLException {
        return this.builder.getFilterList();
    }

    @Override
    public final void jjtreeOpenNodeScope(Node n) {
    }

    @Override
    public final void jjtreeCloseNodeScope(Node n) throws ParseException {
        try {
            Object built = this.build(n);
            IToken tokenAdapter = TokenAdapter.newAdapterFor(this.token);
            Result r = new Result(built, tokenAdapter, n.getType());
            this.builder.pushResult(r);
        }
        catch (CQLException e) {
            throw e;
        }
        finally {
            n.dispose();
        }
    }

    private Object build(Node n) throws CQLException {
        switch (n.getType()) {
            case 68: {
                return this.builder.buildLiteralInteger(this.getTokenInPosition(0).toString());
            }
            case 69: {
                return this.builder.buildLiteralDouble(this.getTokenInPosition(0).toString());
            }
            case 67: {
                return this.builder.bulidNegativeNumber();
            }
            case 72: {
                return this.builder.buildLiteralString(this.getTokenInPosition(0).toString());
            }
            case 62: {
                return this.builder.buildIdentifier(63);
            }
            case 63: {
                return this.builder.buildIdentifierPart(this.getTokenInPosition(0));
            }
            case 64: {
                return this.builder.buildSimpleAttribute();
            }
            case 65: {
                return this.builder.buildCompoundAttribute(64, ATTRIBUTE_PATH_SEPARATOR);
            }
            case 73: {
                return this.builder.buildFunction(74);
            }
            case 74: {
                return n;
            }
            case 75: {
                return n;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                return this.buildBinaryExpression(n.getType());
            }
            case 2: {
                return this.buildLogicFilter(2);
            }
            case 1: {
                return this.buildLogicFilter(1);
            }
            case 3: {
                return this.buildLogicFilter(3);
            }
            case 57: {
                return this.builder.buildBetween();
            }
            case 56: {
                return this.builder.buildNotBetween();
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                return this.buildBinaryComparasionOperator(n.getType());
            }
            case 36: {
                BinaryComparisonOperator eq = this.buildBinaryComparasionOperator(31);
                Not notFilter = this.builder.buildNotFilter((Filter)eq);
                return notFilter;
            }
            case 53: {
                return this.builder.buildLikeFilter(true);
            }
            case 52: {
                return this.builder.buildNotLikeFilter(true);
            }
            case 55: {
                return this.builder.buildLikeFilter(false);
            }
            case 54: {
                return this.builder.buildNotLikeFilter(false);
            }
            case 37: {
                return this.builder.buildPropertyIsNull();
            }
            case 38: {
                return this.builder.buildPorpertyNotIsNull();
            }
            case 66: {
                return this.builder.buildDateExpression(this.getTokenInPosition(0));
            }
            case 48: {
                return this.builder.buildDateTimeExpression(this.getTokenInPosition(0));
            }
            case 49: {
                return this.builder.buildDurationExpression(this.getTokenInPosition(0));
            }
            case 47: {
                return this.builder.buildPeriodBetweenDates();
            }
            case 46: {
                return this.builder.buildPeriodDateAndDuration();
            }
            case 45: {
                return this.builder.buildPeriodDurationAndDate();
            }
            case 39: {
                return this.builder.buildTEquals();
            }
            case 40: {
                return this.buildBefore();
            }
            case 42: {
                return this.buildAfterPredicate();
            }
            case 43: {
                return this.buildDuring();
            }
            case 41: {
                return this.buildBeforeOrDuring();
            }
            case 44: {
                return this.buildDuringOrAfter();
            }
            case 50: {
                return this.builder.buildPropertyExists();
            }
            case 51: {
                PropertyIsEqualTo filter = this.builder.buildPropertyExists();
                Not filterPropNotExist = this.builder.buildNotFilter((Filter)filter);
                return filterPropNotExist;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                return this.buildBinarySpatialOperator(n.getType());
            }
            case 20: 
            case 21: {
                return this.buildBBox(n.getType());
            }
            case 17: {
                return this.builder.buildSpatialRelateFilter();
            }
            case 19: {
                return this.builder.buildDE9IM(this.getToken((int)0).image);
            }
            case 24: {
                return this.builder.buildTolerance();
            }
            case 25: {
                return this.builder.buildDistanceUnit(this.getTokenInPosition(0));
            }
            case 22: 
            case 23: {
                return this.buildDistanceBufferOperator(n.getType());
            }
            case 76: {
                return this.builder.buildCoordinate();
            }
            case 79: {
                return this.builder.buildPointText();
            }
            case 77: {
                return this.builder.buildLineString(76);
            }
            case 80: {
                return this.builder.buildPolygon(77);
            }
            case 81: {
                return this.builder.buildMultiPoint(79);
            }
            case 82: {
                return this.builder.buildMultiLineString(77);
            }
            case 83: {
                return this.builder.buildMultiPolygon(80);
            }
            case 27: {
                return this.builder.buildReferencedGeometryLiteral();
            }
            case 26: {
                return this.builder.buildGeometryLiteral();
            }
            case 28: {
                return this.builder.buildSimpleGeometryLiteral();
            }
            case 84: {
                return this.builder.buildGeometryCollection(28);
            }
            case 78: {
                return this.builder.buildGeometry();
            }
            case 85: {
                return this.builder.buildEnvelope(TokenAdapter.newAdapterFor(n.getToken()));
            }
            case 29: {
                return Filter.INCLUDE;
            }
            case 30: {
                return Filter.EXCLUDE;
            }
            case 70: {
                return this.builder.buildTrueLiteral();
            }
            case 71: {
                return this.builder.buildFalseLiteral();
            }
            case 5: {
                return this.builder.buildFeatureID(this.getTokenInPosition(0));
            }
            case 4: {
                return this.builder.buildFilterId(5);
            }
            case 7: {
                return this.builder.buildInPredicate(8);
            }
            case 6: {
                Or orFilter = this.builder.buildInPredicate(8);
                Not notOrFilter = this.builder.buildNotFilter((Filter)orFilter);
                return notOrFilter;
            }
        }
        return null;
    }

    private BinaryExpression buildBinaryExpression(int nodeType) throws CQLException {
        BinaryExpression expr = null;
        switch (nodeType) {
            case 58: {
                expr = this.builder.buildAddExpression();
                break;
            }
            case 59: {
                expr = this.builder.buildSubtractExression();
                break;
            }
            case 60: {
                expr = this.builder.buildMultiplyExpression();
                break;
            }
            case 61: {
                expr = this.builder.buildDivideExpression();
                break;
            }
        }
        return expr;
    }

    private Filter buildLogicFilter(int nodeType) throws CQLException {
        try {
            Filter logicFilter;
            switch (nodeType) {
                case 2: {
                    logicFilter = this.builder.buildAndFilter();
                    break;
                }
                case 1: {
                    logicFilter = this.builder.buildOrFilter();
                    break;
                }
                case 3: {
                    logicFilter = this.builder.buildNotFilter();
                    break;
                }
                default: {
                    throw new CQLException("Expression not supported. And, Or, Not is required", this.getTokenInPosition(0), this.source);
                }
            }
            return logicFilter;
        }
        catch (IllegalFilterException ife) {
            throw new CQLException("Exception building LogicFilter", this.getTokenInPosition(0), ife, this.source);
        }
    }

    private BinarySpatialOperator buildBinarySpatialOperator(int nodeType) throws CQLException {
        BinarySpatialOperator filter = null;
        switch (nodeType) {
            case 9: {
                filter = this.builder.buildSpatialEqualFilter();
                break;
            }
            case 10: {
                filter = this.builder.buildSpatialDisjointFilter();
                break;
            }
            case 11: {
                filter = this.builder.buildSpatialIntersectsFilter();
                break;
            }
            case 12: {
                filter = this.builder.buildSpatialTouchesFilter();
                break;
            }
            case 13: {
                filter = this.builder.buildSpatialCrossesFilter();
                break;
            }
            case 14: {
                filter = this.builder.buildSpatialWithinFilter();
                break;
            }
            case 15: {
                filter = this.builder.buildSpatialContainsFilter();
                break;
            }
            case 16: {
                filter = this.builder.buildSpatialOverlapsFilter();
                break;
            }
            default: {
                throw new CQLException("Binary spatial operator unexpected");
            }
        }
        return filter;
    }

    private BBOX buildBBox(int nodeType) throws CQLException {
        if (nodeType == 21) {
            return this.builder.buildBBoxWithCRS();
        }
        return this.builder.buildBBox();
    }

    private DistanceBufferOperator buildDistanceBufferOperator(int nodeType) throws CQLException {
        DistanceBufferOperator filter = null;
        switch (nodeType) {
            case 22: {
                filter = this.builder.buildSpatialDWithinFilter();
                break;
            }
            case 23: {
                filter = this.builder.buildSpatialBeyondFilter();
                break;
            }
            default: {
                throw new CQLException("Binary spatial operator unexpected");
            }
        }
        return filter;
    }

    private Filter buildBeforeOrDuring() throws CQLException {
        Or filter = null;
        Result node = this.builder.peekResult();
        switch (node.getNodeType()) {
            case 45: 
            case 46: 
            case 47: {
                filter = this.builder.buildBeforeOrDuring();
                break;
            }
            default: {
                throw new CQLException("unexpeted date time expression in temporal predicate.", node.getToken(), this.source);
            }
        }
        return filter;
    }

    private Or buildDuringOrAfter() throws CQLException {
        Or filter = null;
        Result node = this.builder.peekResult();
        switch (node.getNodeType()) {
            case 45: 
            case 46: 
            case 47: {
                filter = this.builder.buildDuringOrAfter();
                break;
            }
            default: {
                throw new CQLException("unexpeted date time expression in temporal predicate.", node.getToken(), this.source);
            }
        }
        return filter;
    }

    private Before buildBefore() throws CQLException {
        Before filter = null;
        Result node = this.builder.peekResult();
        switch (node.getNodeType()) {
            case 48: {
                filter = this.builder.buildBeforeDate();
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                filter = this.builder.buildBeforePeriod();
                break;
            }
            default: {
                throw new CQLException("unexpeted date time expression in temporal predicate.", node.getToken(), this.source);
            }
        }
        return filter;
    }

    private During buildDuring() throws CQLException {
        During filter = null;
        Result node = this.builder.peekResult();
        switch (node.getNodeType()) {
            case 45: 
            case 46: 
            case 47: {
                filter = this.builder.buildDuringPeriod();
                break;
            }
            default: {
                throw new CQLException("unexpeted period expression in temporal predicate.", node.getToken(), this.source);
            }
        }
        return filter;
    }

    private After buildAfterPredicate() throws CQLException {
        After filter = null;
        Result node = this.builder.peekResult();
        switch (node.getNodeType()) {
            case 48: {
                filter = this.builder.buildAfterDate();
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                filter = this.builder.buildAfterPeriod();
                break;
            }
            default: {
                throw new CQLException("unexpeted date time expression in temporal predicate.", node.getToken(), this.source);
            }
        }
        return filter;
    }

    private BinaryComparisonOperator buildBinaryComparasionOperator(int filterType) throws CQLException {
        switch (filterType) {
            case 31: {
                return this.builder.buildEquals();
            }
            case 32: {
                return this.builder.buildGreater();
            }
            case 33: {
                return this.builder.buildLess();
            }
            case 34: {
                return this.builder.buildGreaterOrEqual();
            }
            case 35: {
                return this.builder.buildLessOrEqual();
            }
        }
        throw new CQLException("unexpeted filter type.");
    }
}

