/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.csw.services.getrecords.es;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.fao.geonet.kernel.csw.services.getrecords.IFieldMapper;
import org.fao.geonet.kernel.csw.services.getrecords.es.Expression2CswVisitor;
import org.fao.geonet.utils.DateUtil;
import org.fao.geonet.utils.Log;
import org.geotools.filter.visitor.AbstractFilterVisitor;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.WKTReader;
import org.opengis.filter.And;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNil;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.AnyInteracts;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.EndedBy;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.Meets;
import org.opengis.filter.temporal.MetBy;
import org.opengis.filter.temporal.OverlappedBy;
import org.opengis.filter.temporal.TContains;
import org.opengis.filter.temporal.TEquals;
import org.opengis.filter.temporal.TOverlaps;
import org.opengis.geometry.BoundingBox;

public class CswFilter2Es
extends AbstractFilterVisitor {
    private static final String BINARY_OPERATOR_AND = "AND";
    private static final String BINARY_OPERATOR_OR = "OR";
    private static final String SPECIAL_RE = "([" + Pattern.quote("+-&|!(){}[]^\\\"~*?:/") + "])";
    private static final String SPECIAL_LIKE_RE = "(?<!\\\\)([" + Pattern.quote("+-&|!(){}[]^\"~:/") + "])";
    private static final String TEMPLATE_NOT = " {\"bool\": {\n            \"must_not\": [\n             %s\n            ]\n          }}";
    private static final String TEMPLATE_AND = " {\"bool\": {\n            \"must\": [\n             %s\n            ]\n          }}";
    private static final String TEMPLATE_AND_WITH_FILTER = " \"bool\": {\n            \"must\": [\n             %s\n            ]\n          ,\"filter\":{\"query_string\":{\"query\":\"%s\"}}}";
    private static final String TEMPLATE_OR = " {\"bool\": {\n            \"should\": [\n             %s\n            ]\n          }}";
    private static final String TEMPLATE_OR_WITH_FILTER = " \"bool\": {\n            \"should\": [\n             %s\n            ]\n          ,\"filter\":{\"query_string\":{\"query\":\"%s\"}}, \"minimum_should_match\" : 1}";
    private static final String TEMPLATE_MATCH = "{\"query_string\": {\n        \"fields\": [\"%s\"],\n        \"query\": \"%s\"\n    }}";
    private static final String TEMPLATE_PROPERTY_IS_NOT = " {\"bool\": {\n            \"must_not\": {\"query_string\": {\n        \"fields\": [\"%s\"],\n        \"query\": \"%s\"\n    }}          }}";
    private static final String TEMPLATE_RANGE = " {\n        \"range\" : {\n            \"%s\" : {\n                \"%s\" : %s\n            }\n        }\n    }";
    private static final String TEMPLATE_BETWEEN = " {\n        \"range\" : {\n            \"%s\" : {\n                \"gte\" : %s,\n                \"lte\" : %s\n            }\n        }\n    }";
    private static final String TEMPLATE_IS_LIKE = "{\"query_string\": {\n        \"fields\": [\"%s\"],\n        \"query\": \"%s\"\n    }}";
    private static final String TEMPLATE_SPATIAL = "{ \"geo_shape\": {\"geom\": {\n                        \t\"shape\": {\n                            \t\"type\": \"%s\",\n                            \t\"coordinates\" : %s\n                        \t},\n                        \t\"relation\": \"%s\"\n                    \t}}}";
    private final StringBuilder outQueryString = new StringBuilder();
    private final Expression2CswVisitor expressionVisitor;
    Deque<String> stack = new ArrayDeque<String>();
    private boolean useFilter = true;

    public CswFilter2Es(IFieldMapper fieldMapper) {
        this.expressionVisitor = new Expression2CswVisitor(this.stack, fieldMapper);
    }

    public static String translate(Filter filter, IFieldMapper fieldMapper) {
        CswFilter2Es translator = new CswFilter2Es(fieldMapper);
        if (filter != null) {
            filter.accept((FilterVisitor)translator, (Object)translator);
        }
        return translator.getFilter();
    }

    protected static String escapeLiteral(String text) {
        return text.replaceAll(SPECIAL_RE, "\\\\$1");
    }

    protected static String quoteString(String text) {
        return String.format("\"%s\"", text);
    }

    protected static String escapeLikeLiteral(String text) {
        return text.replaceAll(SPECIAL_LIKE_RE, "\\\\$1");
    }

    protected static String convertLikePattern(PropertyIsLike filter) {
        String result = filter.getLiteral();
        String wildcardChar = filter.getWildCard();
        String escapeWildcardDefault = filter.getEscape() + "*";
        result = result.replaceAll(Pattern.quote(wildcardChar), "*");
        result = result.replaceAll(Pattern.quote(escapeWildcardDefault), wildcardChar);
        if (wildcardChar.equals("%")) {
            result = result.replace(wildcardChar, "%%");
        }
        if (!filter.getSingleChar().equals("?")) {
            String singleChar = filter.getSingleChar();
            String escapeSinglecharDefault = filter.getEscape() + "?";
            result = result.replaceAll(Pattern.quote(singleChar), "?");
            result = result.replaceAll(Pattern.quote(escapeSinglecharDefault), singleChar);
            if (singleChar.equals("%")) {
                result = result.replace(singleChar, "%%");
            }
        }
        result = StringEscapeUtils.escapeJson((String)CswFilter2Es.escapeLikeLiteral(result));
        return result;
    }

    public String getFilter() {
        String condition;
        String string = condition = this.stack.isEmpty() ? "" : this.stack.pop();
        if (!condition.startsWith(" \"bool\":")) {
            condition = String.format(TEMPLATE_AND_WITH_FILTER, condition, "%s");
        }
        condition = StringUtils.isEmpty((String)condition) ? "{\"bool\":{\"must\":[{\"query_string\":{\"query\":\"*\"}}],\"filter\":{\"query_string\":{\"query\":\"%s\"}}}" : "{" + condition + "}";
        this.outQueryString.append(condition);
        return this.outQueryString.toString();
    }

    public Object visit(And filter, Object extraData) {
        return this.visitBinaryLogic((BinaryLogicOperator)filter, BINARY_OPERATOR_AND, extraData);
    }

    private Object visitBinaryLogic(BinaryLogicOperator filter, String operator, Object extraData) {
        String filterCondition;
        if (operator.equals(BINARY_OPERATOR_AND)) {
            filterCondition = this.useFilter ? TEMPLATE_AND_WITH_FILTER : TEMPLATE_AND;
        } else if (operator.equals(BINARY_OPERATOR_OR)) {
            filterCondition = this.useFilter ? TEMPLATE_OR_WITH_FILTER : TEMPLATE_OR;
        } else {
            throw new NotImplementedException();
        }
        if (this.useFilter) {
            this.useFilter = false;
        }
        for (Filter sub : filter.getChildren()) {
            sub.accept((FilterVisitor)this, extraData);
        }
        int n = filter.getChildren().size();
        ArrayList<String> conditionList = new ArrayList<String>(n);
        for (int i = n; i > 0; --i) {
            conditionList.add(this.stack.pop());
        }
        int count = StringUtils.countMatches((String)filterCondition, (String)"%s");
        filterCondition = count == 1 ? String.format(filterCondition, String.join((CharSequence)",", conditionList)) : String.format(filterCondition, String.join((CharSequence)",", conditionList), "%s");
        this.stack.push(filterCondition);
        return this;
    }

    public Object visit(Id filter, Object extraData) {
        throw new NotImplementedException();
    }

    public Object visit(Not filter, Object extraData) {
        String filterNot = TEMPLATE_NOT;
        filter.getFilter().accept((FilterVisitor)this, extraData);
        filterNot = String.format(filterNot, this.stack.pop());
        this.stack.push(filterNot);
        return this;
    }

    public Object visit(Or filter, Object extraData) {
        return this.visitBinaryLogic((BinaryLogicOperator)filter, BINARY_OPERATOR_OR, extraData);
    }

    public Object visit(PropertyIsBetween filter, Object extraData) {
        String dataPropertyLowerValue;
        String filterBetween = TEMPLATE_BETWEEN;
        if (!(filter.getExpression() instanceof PropertyName)) {
            throw new IllegalArgumentException("Invalid expression property provided");
        }
        if (!(filter.getLowerBoundary() instanceof Literal)) {
            throw new IllegalArgumentException("Invalid expression lower boundary literal provided");
        }
        if (!(filter.getUpperBoundary() instanceof Literal)) {
            throw new IllegalArgumentException("Invalid expression upper boundary literal provided");
        }
        filter.getExpression().accept((ExpressionVisitor)this.expressionVisitor, extraData);
        filter.getLowerBoundary().accept((ExpressionVisitor)this.expressionVisitor, extraData);
        filter.getUpperBoundary().accept((ExpressionVisitor)this.expressionVisitor, extraData);
        String dataPropertyUpperValue = this.stack.pop();
        if (!NumberUtils.isNumber((String)dataPropertyUpperValue)) {
            dataPropertyUpperValue = StringEscapeUtils.escapeJson((String)CswFilter2Es.quoteString(dataPropertyUpperValue));
        }
        if (!NumberUtils.isNumber((String)(dataPropertyLowerValue = this.stack.pop()))) {
            dataPropertyLowerValue = StringEscapeUtils.escapeJson((String)CswFilter2Es.quoteString(dataPropertyLowerValue));
        }
        String dataPropertyName = this.stack.pop();
        filterBetween = String.format(filterBetween, dataPropertyName, dataPropertyLowerValue, dataPropertyUpperValue);
        this.stack.push(filterBetween);
        return this;
    }

    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        this.checkFilterExpressionsInBinaryComparisonOperator((BinaryComparisonOperator)filter);
        filter.getExpression1().accept((ExpressionVisitor)this.expressionVisitor, extraData);
        filter.getExpression2().accept((ExpressionVisitor)this.expressionVisitor, extraData);
        String dataPropertyValue = this.stack.pop();
        String dataPropertyName = this.stack.pop();
        String filterEqualTo = String.format("{\"query_string\": {\n        \"fields\": [\"%s\"],\n        \"query\": \"%s\"\n    }}", dataPropertyName, StringEscapeUtils.escapeJson((String)CswFilter2Es.escapeLiteral(dataPropertyValue)));
        this.stack.push(filterEqualTo);
        return this;
    }

    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        String filterPropertyIsNot = TEMPLATE_PROPERTY_IS_NOT;
        this.checkFilterExpressionsInBinaryComparisonOperator((BinaryComparisonOperator)filter);
        filter.getExpression1().accept((ExpressionVisitor)this.expressionVisitor, extraData);
        filter.getExpression2().accept((ExpressionVisitor)this.expressionVisitor, extraData);
        String dataPropertyValue = this.stack.pop();
        String dataPropertyName = this.stack.pop();
        filterPropertyIsNot = String.format(filterPropertyIsNot, dataPropertyName, StringEscapeUtils.escapeJson((String)CswFilter2Es.escapeLiteral(dataPropertyValue)));
        this.stack.push(filterPropertyIsNot);
        return this;
    }

    public Object visitRange(BinaryComparisonOperator filter, String operator, Object extraData) {
        boolean isDate;
        String filterRange = TEMPLATE_RANGE;
        this.checkFilterExpressionsInBinaryComparisonOperator(filter);
        filter.getExpression1().accept((ExpressionVisitor)this.expressionVisitor, extraData);
        filter.getExpression2().accept((ExpressionVisitor)this.expressionVisitor, extraData);
        String dataPropertyValue = this.stack.pop();
        String dataPropertyName = this.stack.pop();
        boolean bl = isDate = DateUtil.parseBasicOrFullDateTime((String)dataPropertyValue) != null;
        if (isDate) {
            dataPropertyValue = CswFilter2Es.quoteString(dataPropertyValue);
        } else if (!NumberUtils.isNumber((String)dataPropertyValue)) {
            dataPropertyValue = StringEscapeUtils.escapeJson((String)CswFilter2Es.quoteString(dataPropertyValue));
        }
        filterRange = String.format(filterRange, dataPropertyName, operator, dataPropertyValue);
        this.stack.push(filterRange);
        return this;
    }

    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        return this.visitRange((BinaryComparisonOperator)filter, "gt", extraData);
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        return this.visitRange((BinaryComparisonOperator)filter, "gte", extraData);
    }

    public Object visit(PropertyIsLessThan filter, Object extraData) {
        return this.visitRange((BinaryComparisonOperator)filter, "lt", extraData);
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        return this.visitRange((BinaryComparisonOperator)filter, "lte", extraData);
    }

    public Object visit(PropertyIsLike filter, Object extraData) {
        String filterIsLike = "{\"query_string\": {\n        \"fields\": [\"%s\"],\n        \"query\": \"%s\"\n    }}";
        String expression = CswFilter2Es.convertLikePattern(filter);
        filter.getExpression().accept((ExpressionVisitor)this.expressionVisitor, extraData);
        filterIsLike = String.format(filterIsLike, this.stack.pop(), expression);
        this.stack.push(filterIsLike);
        return this;
    }

    public Object visit(PropertyIsNull filter, Object extraData) {
        this.outQueryString.append("(-");
        filter.getExpression().accept((ExpressionVisitor)this.expressionVisitor, extraData);
        this.outQueryString.append(":[* TO *])");
        return this;
    }

    public Object visit(PropertyIsNil filter, Object extraData) {
        this.outQueryString.append("(-");
        filter.getExpression().accept((ExpressionVisitor)this.expressionVisitor, extraData);
        this.outQueryString.append(":[* TO *])");
        return this;
    }

    private String fillTemplateSpatial(String shapeType, String coords, String relation) {
        return String.format(TEMPLATE_SPATIAL, shapeType, coords, relation);
    }

    public Object visit(BBOX filter, Object extraData) {
        BoundingBox bbox = filter.getBounds();
        double x0 = bbox.getMinX();
        double x1 = bbox.getMaxX();
        double y0 = bbox.getMinY();
        double y1 = bbox.getMaxY();
        String coordsValue = String.format(Locale.US, "[[%f, %f], [%f, %f]]", x0, y1, x1, y0);
        String filterSpatial = this.fillTemplateSpatial("envelope", coordsValue, "intersects");
        this.stack.push(filterSpatial);
        return this;
    }

    private Object addGeomFilter(BinarySpatialOperator filter, String geoOperator, Object extraData) {
        if (filter.getExpression2() != null && filter.getExpression1() != null) {
            filter.getExpression1().accept((ExpressionVisitor)this.expressionVisitor, extraData);
        }
        Expression geoExpression = filter.getExpression2() == null ? filter.getExpression1() : filter.getExpression2();
        geoExpression.accept((ExpressionVisitor)this.expressionVisitor, extraData);
        String geom = this.stack.pop();
        this.stack.pop();
        WKTReader reader = new WKTReader();
        try {
            String filterSpatial;
            Geometry geometryJts = reader.read(geom);
            if (geometryJts instanceof Polygon) {
                Polygon polygonGeom = (Polygon)geometryJts;
                String coordinatesText = this.buildCoordinatesString(polygonGeom.getCoordinates());
                filterSpatial = this.fillTemplateSpatial("polygon", String.format("[[%s]]", coordinatesText), geoOperator);
            } else if (geometryJts instanceof Point) {
                Point pointGeom = (Point)geometryJts;
                String coordsValue = String.format(Locale.US, "[%f, %f]", pointGeom.getX(), pointGeom.getY());
                filterSpatial = this.fillTemplateSpatial("point", coordsValue, geoOperator);
            } else if (geometryJts instanceof LineString) {
                LineString lineStringGeom = (LineString)geometryJts;
                String coordinatesText = this.buildCoordinatesString(lineStringGeom.getCoordinates());
                filterSpatial = this.fillTemplateSpatial("linestring", String.format("[%s]", coordinatesText), geoOperator);
            } else {
                filterSpatial = null;
            }
            this.stack.push(filterSpatial);
        }
        catch (Exception ex) {
            Log.error((String)"geonetwork.csw", (String)"Error parsing geospatial object", (Throwable)ex);
            throw new IllegalArgumentException("Invalid expression for spatial filter", ex);
        }
        return this;
    }

    public Object visit(Beyond filter, Object extraData) {
        throw new NotImplementedException();
    }

    public Object visit(Contains filter, Object extraData) {
        return this.addGeomFilter((BinarySpatialOperator)filter, "contains", extraData);
    }

    public Object visit(Crosses filter, Object extraData) {
        return this.addGeomFilter((BinarySpatialOperator)filter, "intersects", extraData);
    }

    public Object visit(Disjoint filter, Object extraData) {
        return this.addGeomFilter((BinarySpatialOperator)filter, "disjoint", extraData);
    }

    public Object visit(DWithin filter, Object extraData) {
        throw new NotImplementedException();
    }

    public Object visit(Equals filter, Object extraData) {
        throw new NotImplementedException();
    }

    public Object visit(Intersects filter, Object extraData) {
        return this.addGeomFilter((BinarySpatialOperator)filter, "intersects", extraData);
    }

    public Object visit(Overlaps filter, Object extraData) {
        return this.addGeomFilter((BinarySpatialOperator)filter, "intersects", extraData);
    }

    public Object visit(Touches filter, Object extraData) {
        throw new NotImplementedException();
    }

    public Object visit(Within filter, Object extraData) {
        return this.addGeomFilter((BinarySpatialOperator)filter, "within", extraData);
    }

    public Object visit(After after, Object extraData) {
        throw new NotImplementedException();
    }

    public Object visit(AnyInteracts anyInteracts, Object extraData) {
        throw new NotImplementedException();
    }

    public Object visit(Before before, Object extraData) {
        throw new NotImplementedException();
    }

    public Object visit(Begins begins, Object extraData) {
        throw new NotImplementedException();
    }

    public Object visit(BegunBy begunBy, Object extraData) {
        throw new NotImplementedException();
    }

    public Object visit(During during, Object extraData) {
        throw new NotImplementedException();
    }

    public Object visit(EndedBy endedBy, Object extraData) {
        throw new NotImplementedException();
    }

    public Object visit(Ends ends, Object extraData) {
        throw new NotImplementedException();
    }

    public Object visit(Meets meets, Object extraData) {
        throw new NotImplementedException();
    }

    public Object visit(MetBy metBy, Object extraData) {
        throw new NotImplementedException();
    }

    public Object visit(OverlappedBy overlappedBy, Object extraData) {
        throw new NotImplementedException();
    }

    public Object visit(TContains contains, Object extraData) {
        throw new NotImplementedException();
    }

    public Object visit(TEquals equals, Object extraData) {
        throw new NotImplementedException();
    }

    public Object visit(TOverlaps contains, Object extraData) {
        throw new NotImplementedException();
    }

    private String buildCoordinatesString(Coordinate[] coordinates) {
        ArrayList<String> coordinatesList = new ArrayList<String>();
        for (Coordinate c : coordinates) {
            String coordsValue = String.format(Locale.US, "[%f, %f] ", c.getX(), c.getY());
            coordinatesList.add(coordsValue);
        }
        return String.join((CharSequence)" , ", coordinatesList);
    }

    private void checkFilterExpressionsInBinaryComparisonOperator(BinaryComparisonOperator filter) {
        if (!(filter.getExpression1() instanceof PropertyName)) {
            throw new IllegalArgumentException("Invalid expression property provided");
        }
        if (!(filter.getExpression2() instanceof Literal)) {
            throw new IllegalArgumentException("Invalid expression literal provided");
        }
    }
}

