/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections4.map.CaseInsensitiveMap;

public class URIs {
    public static URL buildURL(URL baseURL, Map<String, String> kvp) {
        String uri = URIs.buildURL(baseURL.toExternalForm(), null, kvp, "UTF-8");
        try {
            return new URL(uri);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static URL buildURL(URL baseURL, Map<String, String> kvp, String encoding) {
        String uri = URIs.buildURL(baseURL.toExternalForm(), null, kvp, encoding);
        try {
            return new URL(uri);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static String buildURL(String baseURL, Map<String, String> kvp) {
        return URIs.buildURL(baseURL, null, kvp, "UTF-8");
    }

    public static String buildURL(String baseURL, String path, Map<String, String> kvp, String encoding) {
        StringBuilder baseURLBuffer = new StringBuilder(baseURL);
        LinkedHashMap<String, String> kvpBuffer = new LinkedHashMap<String, String>();
        if (kvp != null) {
            kvpBuffer.putAll(kvp);
        }
        String result = path != null ? URIs.appendContextPath(baseURLBuffer.toString(), path) : baseURLBuffer.toString();
        StringBuilder params = new StringBuilder();
        for (Map.Entry entry : kvpBuffer.entrySet()) {
            params.append((String)entry.getKey());
            params.append("=");
            String value = (String)entry.getValue();
            if (value != null) {
                String encoded = URIs.urlEncode(value, encoding);
                params.append(encoded);
            }
            params.append("&");
        }
        if (params.length() > 1) {
            params.setLength(params.length() - 1);
            result = URIs.appendQueryString(result, params.toString());
        }
        return result;
    }

    public static String appendContextPath(String url, String contextPath) {
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        if (contextPath.startsWith("/")) {
            contextPath = contextPath.substring(1);
        }
        return url + (contextPath.isEmpty() ? "" : "/" + contextPath);
    }

    public static String urlEncode(String value, String valueEncoding) {
        try {
            return URLEncoder.encode(new String(value.getBytes(), valueEncoding), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("This is unexpected", e);
        }
    }

    public static String urlDecode(String value) {
        try {
            return URLDecoder.decode(new String(value.getBytes(), StandardCharsets.UTF_8), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("This is unexpected", e);
        }
    }

    public static String appendQueryString(String url, String queryString) {
        if (url.endsWith("?") || url.endsWith("&")) {
            return url + queryString;
        }
        if (url.indexOf(63) != -1) {
            return url + "&" + queryString;
        }
        return url + "?" + queryString;
    }

    public static Map<String, String> parseQueryString(String queryString) {
        if (queryString == null || queryString.length() == 0) {
            return Collections.emptyMap();
        }
        String[] params = queryString.split("&");
        CaseInsensitiveMap kvpMap = new CaseInsensitiveMap();
        for (String kvp : params) {
            String[] split = kvp.split("=");
            if (split[0].length() <= 0) continue;
            String key = split[0];
            String value = split.length > 1 ? URIs.urlDecode(split[1]) : null;
            kvpMap.put(key, value);
        }
        return kvpMap;
    }
}

