/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal;

import java.io.IOException;
import org.geotools.data.wfs.internal.GetParser;
import org.geotools.data.wfs.internal.WFSRequest;
import org.geotools.data.wfs.internal.WFSResponse;
import org.geotools.http.HTTPResponse;
import org.geotools.ows.ServiceException;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;

public class GetFeatureResponse
extends WFSResponse {
    private final GetParser<SimpleFeature> features;
    private boolean featuresReturned;

    public GetFeatureResponse(WFSRequest originatingRequest, HTTPResponse httpResponse, GetParser<SimpleFeature> features) throws ServiceException, IOException {
        super(originatingRequest, httpResponse);
        this.features = features;
    }

    public GetParser<SimpleFeature> getFeatures() {
        return this.features;
    }

    public GetParser<SimpleFeature> getFeatures(GeometryFactory geometryFactory) {
        if (this.featuresReturned) {
            throw new IllegalStateException("getFeatures can be called only once");
        }
        GetParser<SimpleFeature> features = this.getFeatures();
        if (geometryFactory != null) {
            features.setGeometryFactory(geometryFactory);
        }
        this.featuresReturned = true;
        return features;
    }

    public GetParser<SimpleFeature> getSimpleFeatures(GeometryFactory geometryFactory) {
        GetParser<SimpleFeature> rawFeatures = this.getFeatures(geometryFactory);
        FeatureType featureType = rawFeatures.getFeatureType();
        if (featureType instanceof SimpleFeatureType) {
            return rawFeatures;
        }
        throw new UnsupportedOperationException("implementa adapting to SimpleFeature");
    }
}

