/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.oaipmh;

import java.util.ArrayList;
import org.fao.geonet.Util;
import org.fao.geonet.exceptions.BadInputEx;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.harvest.harvester.AbstractParams;
import org.fao.geonet.kernel.harvest.harvester.oaipmh.Search;
import org.jdom.Element;

public class OaiPmhParams
extends AbstractParams {
    public String url;
    public String xslfilter;
    public String icon;
    private ArrayList<Search> alSearches = new ArrayList();

    public OaiPmhParams(DataManager dm) {
        super(dm);
    }

    @Override
    public void create(Element node) throws BadInputEx {
        super.create(node);
        Element site = node.getChild("site");
        Element searches = node.getChild("searches");
        this.url = Util.getParam((Element)site, (String)"url", (String)"");
        this.icon = Util.getParam((Element)site, (String)"icon", (String)"");
        this.xslfilter = Util.getParam((Element)site, (String)"xslfilter", (String)"");
        this.addSearches(searches);
    }

    @Override
    public void update(Element node) throws BadInputEx {
        super.update(node);
        Element site = node.getChild("site");
        Element searches = node.getChild("searches");
        this.url = Util.getParam((Element)site, (String)"url", (String)this.url);
        this.icon = Util.getParam((Element)site, (String)"icon", (String)this.icon);
        this.xslfilter = Util.getParam((Element)site, (String)"xslfilter", (String)"");
        if (searches != null) {
            this.addSearches(searches);
        }
    }

    public Iterable<Search> getSearches() {
        return this.alSearches;
    }

    public boolean isSearchEmpty() {
        return this.alSearches.isEmpty();
    }

    @Override
    public OaiPmhParams copy() {
        OaiPmhParams copy = new OaiPmhParams(this.dm);
        this.copyTo(copy);
        copy.url = this.url;
        copy.icon = this.icon;
        copy.xslfilter = this.xslfilter;
        copy.setValidate(this.getValidate());
        for (Search s : this.alSearches) {
            copy.alSearches.add(s.copy());
        }
        return copy;
    }

    private void addSearches(Element searches) throws BadInputEx {
        this.alSearches.clear();
        if (searches == null) {
            return;
        }
        for (Object o : searches.getChildren("search")) {
            Element search = (Element)o;
            this.alSearches.add(new Search(search));
        }
    }

    @Override
    public String getIcon() {
        return this.icon;
    }
}

