/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.geonet.v4;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.kernel.harvest.harvester.geonet.BaseSearch;
import org.fao.geonet.utils.Log;
import org.jdom.Element;

class Search
extends BaseSearch {
    public Search() {
    }

    public Search(Element search) throws BadParameterEx {
        super(search);
    }

    public static Search createEmptySearch(int from, int to) throws BadParameterEx {
        Search s = new Search(new Element("search"));
        s.setRange(from, to);
        return s;
    }

    public Search copy() {
        Search s = new Search();
        s.freeText = this.freeText;
        s.title = this.title;
        s.abstractText = this.abstractText;
        s.keywords = this.keywords;
        s.sourceUuid = this.sourceUuid;
        s.from = this.from;
        s.to = this.to;
        return s;
    }

    public String createElasticsearchQuery() {
        String sourceFilter = "";
        if (StringUtils.isNotBlank((CharSequence)this.sourceUuid)) {
            sourceFilter = String.format(",{\"term\": {\"sourceCatalogue\": \"%s\"}}", this.sourceUuid);
        }
        String freeTextFilter = "";
        if (StringUtils.isNotBlank((CharSequence)this.freeText)) {
            freeTextFilter = String.format(",{\"query_string\": {\"query\": \"(any.\\\\*:(%s) OR any.common:(%s))\", \"default_operator\": \"AND\"}}", this.freeText, this.freeText);
        }
        String titleFilter = "";
        if (StringUtils.isNotBlank((CharSequence)this.title)) {
            titleFilter = String.format(",{\"query_string\": {\"query\": \"(resourceTitleObject.\\\\*:(%s))\", \"default_operator\": \"AND\"}}", this.title);
        }
        String abstractFilter = "";
        if (StringUtils.isNotBlank((CharSequence)this.abstractText)) {
            abstractFilter = String.format(",{\"query_string\": {\"query\": \"(resourceAbstractObject.\\\\*:(%s))\", \"default_operator\": \"AND\"}}", this.abstractText);
        }
        String keywordFilter = "";
        if (StringUtils.isNotBlank((CharSequence)this.keywords)) {
            abstractFilter = String.format(",{\"term\": {\"tag.default\": \"%s\"}}", this.keywords);
        }
        String queryBody = String.format("{\n    \"from\": %d,\n    \"size\": %d,\n    \"sort\": [\"_score\"],\n    \"query\": {\"bool\": {\"must\": [{\"terms\": {\"isTemplate\": [\"n\"]}}%s%s%s%s%s]}},\n    \"_source\": {\"includes\": [\n        \"uuid\",\n        \"id\",\n        \"isTemplate\",\n        \"sourceCatalogue\",\n        \"dateStamp\",\n        \"documentStandard\"\n    ]},\n    \"track_total_hits\": true\n}", this.from, this.to, sourceFilter, freeTextFilter, titleFilter, abstractFilter, keywordFilter);
        if (Log.isDebugEnabled((String)"geonetwork.harvest-man")) {
            Log.debug((String)"geonetwork.harvest-man", (Object)("Search request is " + queryBody));
        }
        return queryBody;
    }

    public void setRange(int from, int to) {
        this.from = from;
        this.to = to;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("from", this.from).append("to", this.to).append("freeText", (Object)this.freeText).append("title", (Object)this.title).append("abstrac", (Object)this.abstractText).append("keywords", (Object)this.keywords).append("sourceUuid", (Object)this.sourceUuid).toString();
    }
}

