/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.geonet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Logger;
import org.fao.geonet.MetadataResourceDatabaseMigration;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.records.attachments.Store;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataResource;
import org.fao.geonet.domain.MetadataResourceVisibility;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.exceptions.NoSchemaMatchesException;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.UpdateDatestamp;
import org.fao.geonet.kernel.datamanager.IMetadataIndexer;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataOperations;
import org.fao.geonet.kernel.datamanager.IMetadataSchemaUtils;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.harvest.BaseAligner;
import org.fao.geonet.kernel.harvest.harvester.CategoryMapper;
import org.fao.geonet.kernel.harvest.harvester.GroupMapper;
import org.fao.geonet.kernel.harvest.harvester.HarvestError;
import org.fao.geonet.kernel.harvest.harvester.HarvestResult;
import org.fao.geonet.kernel.harvest.harvester.HarvesterUtil;
import org.fao.geonet.kernel.harvest.harvester.RecordInfo;
import org.fao.geonet.kernel.harvest.harvester.UUIDMapper;
import org.fao.geonet.kernel.harvest.harvester.geonet.BaseGeonetParams;
import org.fao.geonet.kernel.harvest.harvester.geonet.Group;
import org.fao.geonet.kernel.mef.IMEFVisitor;
import org.fao.geonet.kernel.mef.IVisitor;
import org.fao.geonet.kernel.mef.Importer;
import org.fao.geonet.kernel.mef.MEF2Visitor;
import org.fao.geonet.kernel.mef.MEFLib;
import org.fao.geonet.kernel.mef.MEFVisitor;
import org.fao.geonet.kernel.search.IndexingMode;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.jdom.JDOMException;

public abstract class BaseGeoNetworkAligner<P extends BaseGeonetParams>
extends BaseAligner<P> {
    public static final String GENERAL = "general";
    protected final Logger log;
    protected final ServiceContext context;
    protected final DataManager dataMan;
    protected final IMetadataManager metadataManager;
    protected final IMetadataIndexer metadataIndexer;
    protected final IMetadataOperations metadataOperations;
    protected final IMetadataUtils metadataUtils;
    protected final IMetadataSchemaUtils metadataSchemaUtils;
    protected final MetadataRepository metadataRepository;
    protected final SettingManager settingManager;
    protected final AccessManager accessManager;
    protected CategoryMapper localCategory;
    protected GroupMapper localGroups;
    protected UUIDMapper localUuids;
    protected String processName;
    protected String preferredSchema;
    protected Map<String, Object> processParams = new HashMap<String, Object>();
    protected HarvestResult result;
    protected Map<String, Map<String, String>> hmRemoteGroups = new HashMap<String, Map<String, String>>();

    public BaseGeoNetworkAligner(AtomicBoolean cancelMonitor, Logger log, ServiceContext context, P params) {
        super(cancelMonitor);
        this.log = log;
        this.context = context;
        this.params = params;
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        this.metadataIndexer = (IMetadataIndexer)gc.getBean(IMetadataIndexer.class);
        this.metadataManager = (IMetadataManager)gc.getBean(IMetadataManager.class);
        this.metadataOperations = (IMetadataOperations)gc.getBean(IMetadataOperations.class);
        this.metadataUtils = (IMetadataUtils)gc.getBean(IMetadataUtils.class);
        this.metadataSchemaUtils = (IMetadataSchemaUtils)gc.getBean(IMetadataSchemaUtils.class);
        this.metadataRepository = (MetadataRepository)gc.getBean(MetadataRepository.class);
        this.settingManager = (SettingManager)gc.getBean(SettingManager.class);
        this.accessManager = (AccessManager)gc.getBean(AccessManager.class);
        this.dataMan = (DataManager)gc.getBean(DataManager.class);
        this.result = new HarvestResult();
    }

    public HarvestResult align(SortedSet<RecordInfo> records, List<HarvestError> errors) throws Exception {
        String id;
        this.log.info("Start of alignment for : " + ((BaseGeonetParams)this.params).getName());
        this.localCategory = new CategoryMapper(this.context);
        this.localGroups = new GroupMapper(this.context);
        this.localUuids = new UUIDMapper((IMetadataUtils)this.context.getBean(IMetadataUtils.class), ((BaseGeonetParams)this.params).getUuid());
        Pair<String, Map<String, Object>> filter = HarvesterUtil.parseXSLFilter(((BaseGeonetParams)this.params).xslfilter);
        this.processName = (String)filter.one();
        this.processParams = (Map)filter.two();
        for (String uuid : this.localUuids.getUUIDs()) {
            if (this.cancelMonitor.get()) {
                return this.result;
            }
            try {
                if (this.exists(records, uuid)) continue;
                id = this.localUuids.getID(uuid);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("  - Removing old metadata with id:" + id);
                }
                this.metadataManager.deleteMetadata(this.context, id);
                ++this.result.locallyRemoved;
            }
            catch (Throwable t) {
                this.log.error("Couldn't remove metadata with uuid " + uuid);
                this.log.error(t);
                ++this.result.unchangedMetadata;
            }
        }
        this.preferredSchema = ((ServiceConfig)this.context.getBean(ServiceConfig.class)).getMandatoryValue("preferredSchema");
        if (this.preferredSchema == null) {
            this.preferredSchema = "iso19139";
        }
        block10: for (RecordInfo ri : records) {
            if (this.cancelMonitor.get()) {
                return this.result;
            }
            try {
                ++this.result.totalMetadata;
                if (!this.metadataSchemaUtils.existsSchema(ri.schema) && !ri.schema.startsWith("iso19139.")) {
                    this.log.info("  - Metadata skipped due to unknown schema. uuid:" + ri.uuid + ", schema:" + ri.schema);
                    ++this.result.unknownSchema;
                    continue;
                }
                id = this.metadataUtils.getMetadataId(ri.uuid);
                String localRating = this.settingManager.getValue("system/localrating/enable");
                if (id == null) {
                    this.log.debug("Adding record with uuid " + ri.uuid);
                    this.addMetadata(ri, localRating.equals("basic"), ri.uuid);
                    continue;
                }
                if (this.localUuids.getID(ri.uuid) == null) {
                    ++this.result.datasetUuidExist;
                    switch (((BaseGeonetParams)this.params).getOverrideUuid()) {
                        case OVERRIDE: {
                            this.updateMetadata(ri, id, localRating.equals("basic"), ((BaseGeonetParams)this.params).useChangeDateForUpdate(), this.localUuids.getChangeDate(ri.uuid), (Boolean)true);
                            this.log.info("Overriding record with uuid " + ri.uuid);
                            ++this.result.updatedMetadata;
                            if (!((BaseGeonetParams)this.params).isIfRecordExistAppendPrivileges()) continue block10;
                            this.addPrivileges(id, ((BaseGeonetParams)this.params).getPrivileges(), this.localGroups, this.context);
                            ++this.result.privilegesAppendedOnExistingRecord;
                            break;
                        }
                        case RANDOM: {
                            this.log.info("Generating random uuid for remote record with uuid " + ri.uuid);
                            this.addMetadata(ri, localRating.equals("basic"), UUID.randomUUID().toString());
                            break;
                        }
                        case SKIP: {
                            this.log.debug("Skipping record with uuid " + ri.uuid);
                            ++this.result.uuidSkipped;
                            break;
                        }
                    }
                    continue;
                }
                this.log.debug("Updating record with uuid " + ri.uuid);
                this.updateMetadata(ri, id, localRating.equals("basic"), ((BaseGeonetParams)this.params).useChangeDateForUpdate(), this.localUuids.getChangeDate(ri.uuid), (Boolean)false);
                if (!((BaseGeonetParams)this.params).isIfRecordExistAppendPrivileges()) continue;
                this.addPrivileges(id, ((BaseGeonetParams)this.params).getPrivileges(), this.localGroups, this.context);
                ++this.result.privilegesAppendedOnExistingRecord;
            }
            catch (Throwable t) {
                this.log.error("Couldn't insert or update metadata with uuid " + ri.uuid);
                this.log.error(t);
                ++this.result.unchangedMetadata;
            }
        }
        this.metadataIndexer.forceIndexChanges();
        this.log.info("End of alignment for : " + ((BaseGeonetParams)this.params).getName());
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMetadata(final RecordInfo ri, final String id, final boolean localRating, boolean useChangeDate, String localChangeDate, final Boolean force) throws Exception {
        final Element[] md = new Element[]{null};
        final Element[] publicFiles = new Element[]{null};
        final Element[] privateFiles = new Element[]{null};
        if (this.localUuids.getID(ri.uuid) == null && !force.booleanValue()) {
            this.log.info("  - Skipped metadata managed by another harvesting node. uuid:" + ri.uuid + ", name:" + ((BaseGeonetParams)this.params).getName());
        } else if (force.booleanValue() || !useChangeDate || ri.isMoreRecentThan(localChangeDate)) {
            Path mefFile = null;
            try {
                mefFile = this.retrieveMEF(ri.uuid);
                String fileType = "mef";
                MEFLib.Version version = MEFLib.getMEFVersion((Path)mefFile);
                if (version != null && version.equals((Object)MEFLib.Version.V2)) {
                    fileType = "mef2";
                }
                MEF2Visitor visitor = fileType.equals("mef2") ? new MEF2Visitor() : new MEFVisitor();
                MEFLib.visit((Path)mefFile, (IVisitor)visitor, (IMEFVisitor)new IMEFVisitor(){

                    public void handleMetadata(Element mdata, int index) throws Exception {
                        md[index] = mdata;
                    }

                    public void handleMetadataFiles(DirectoryStream<Path> files, Element info, int index) throws Exception {
                        Element metadataValidForImport = BaseGeoNetworkAligner.this.extractValidMetadataForImport(files, info);
                        if (metadataValidForImport != null) {
                            this.handleMetadata(metadataValidForImport, index);
                        }
                    }

                    public void handleInfo(Element info, int index) throws Exception {
                        BaseGeoNetworkAligner.this.updateMetadata(ri, id, md[index], info, localRating, force);
                        publicFiles[index] = info.getChild("public");
                        privateFiles[index] = info.getChild("private");
                    }

                    public void handlePublicFile(String file, String changeDate, InputStream is, int index) throws Exception {
                        BaseGeoNetworkAligner.this.handleFile(id, file, MetadataResourceVisibility.PUBLIC, changeDate, is, publicFiles[index]);
                    }

                    public void handleFeatureCat(Element md2, int index) throws Exception {
                    }

                    public void handlePrivateFile(String file, String changeDate, InputStream is, int index) throws Exception {
                        BaseGeoNetworkAligner.this.handleFile(id, file, MetadataResourceVisibility.PRIVATE, changeDate, is, privateFiles[index]);
                    }
                });
            }
            catch (Exception e) {
                ++this.result.unretrievable;
            }
            finally {
                if (mefFile != null) {
                    FileUtils.deleteQuietly((File)mefFile.toFile());
                }
            }
        } else {
            ++this.result.unchangedMetadata;
        }
    }

    private void updateMetadata(RecordInfo ri, String id, Element md, Element info, boolean localRating, boolean force) throws Exception {
        Element categs;
        String rating;
        Metadata metadata;
        String date = this.localUuids.getChangeDate(ri.uuid);
        try {
            Integer groupIdVal = null;
            if (StringUtils.isNotEmpty((String)((BaseGeonetParams)this.params).getOwnerIdGroup())) {
                groupIdVal = this.getGroupOwner();
            }
            ((BaseGeonetParams)this.params).getValidate().validate(this.dataMan, this.context, md, groupIdVal);
        }
        catch (Exception e) {
            this.log.info("Ignoring invalid metadata uuid: " + ri.uuid);
            ++this.result.doesNotValidate;
            return;
        }
        if (!force && !ri.isMoreRecentThan(date)) {
            this.log.info("  - XML not changed for local metadata with uuid:" + ri.uuid);
            ++this.result.unchangedMetadata;
            metadata = this.metadataRepository.findOneById(Integer.parseInt(id));
            if (metadata == null) {
                throw new NoSuchElementException("Unable to find a metadata with ID: " + id);
            }
        } else {
            if (((BaseGeonetParams)this.params).mefFormatFull && ri.schema.startsWith("iso19139")) {
                MetadataResourceDatabaseMigration.updateMetadataResourcesLink((Element)md, null, (SettingManager)this.settingManager);
            }
            if (!((BaseGeonetParams)this.params).xslfilter.isEmpty()) {
                md = HarvesterUtil.processMetadata(this.metadataSchemaUtils.getSchema(ri.schema), md, this.processName, this.processParams);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("  - Updating local metadata with id=" + id);
            }
            boolean validate = false;
            boolean ufo = ((BaseGeonetParams)this.params).mefFormatFull;
            boolean updateDateStamp = true;
            String language = this.context.getLanguage();
            this.metadataManager.updateMetadata(this.context, id, md, validate, ufo, language, ri.changeDate, updateDateStamp, IndexingMode.none);
            metadata = this.metadataRepository.findOneById(Integer.parseInt(id));
            ++this.result.updatedMetadata;
            if (force) {
                metadata.getHarvestInfo().setUuid(((BaseGeonetParams)this.params).getUuid());
                metadata.getSourceInfo().setSourceId(((BaseGeonetParams)this.params).getUuid());
                this.metadataManager.save((AbstractMetadata)metadata);
            }
        }
        metadata.getCategories().clear();
        this.addCategories((AbstractMetadata)metadata, ((BaseGeonetParams)this.params).getCategories(), this.localCategory, this.context, null, true);
        metadata = this.metadataRepository.findOneById(Integer.parseInt(id));
        Element general = info.getChild(GENERAL);
        String popularity = general.getChildText("popularity");
        if (!localRating && (rating = general.getChildText("rating")) != null) {
            metadata.getDataInfo().setRating(Integer.parseInt(rating));
        }
        if (popularity != null) {
            metadata.getDataInfo().setPopularity(Integer.parseInt(popularity));
        }
        if (((BaseGeonetParams)this.params).createRemoteCategory && (categs = info.getChild("categories")) != null) {
            Importer.addCategoriesToMetadata((AbstractMetadata)metadata, (Element)categs, (ServiceContext)this.context);
        }
        if (((ArrayList)((BaseGeonetParams)this.params).getGroupCopyPolicy()).isEmpty()) {
            this.addPrivileges(id, ((BaseGeonetParams)this.params).getPrivileges(), this.localGroups, this.context);
        } else {
            this.addPrivilegesFromGroupPolicy(id, info.getChild("privileges"));
        }
        this.metadataManager.save((AbstractMetadata)metadata);
        this.metadataIndexer.indexMetadata(id, true, IndexingMode.full);
    }

    protected void removeOldFile(ServiceContext context, Logger log, Store store, String metadataUuid, Element infoFiles, MetadataResourceVisibility visibility) throws Exception {
        List resources = store.getResources(context, metadataUuid, visibility, null, Boolean.valueOf(true));
        for (MetadataResource resource : resources) {
            if (infoFiles == null || this.existsFile(resource.getId(), infoFiles)) continue;
            if (log.isDebugEnabled()) {
                log.debug("  - Removing old " + metadataUuid + " file with name=" + resource.getFilename());
            }
            store.delResource(context, metadataUuid, visibility, resource.getFilename(), Boolean.valueOf(true));
        }
    }

    protected boolean exists(SortedSet<RecordInfo> records, String uuid) {
        RecordInfo recordToTest = new RecordInfo(uuid, null);
        return records.contains(recordToTest);
    }

    protected void addPrivilegesFromGroupPolicy(String id, Element privil) throws Exception {
        Map<String, Set<String>> groupOper = this.buildPrivileges(privil);
        Iterable<Group> iterable = ((BaseGeonetParams)this.params).getGroupCopyPolicy();
        for (Group remoteGroup : iterable) {
            Set<String> oper = groupOper.get(remoteGroup.name);
            if (oper == null) {
                this.log.info("    - Remote group has been removed or no privileges exist : " + remoteGroup.name);
                continue;
            }
            String localGrpId = this.localGroups.getID(remoteGroup.name);
            if (localGrpId == null) {
                if (remoteGroup.policy != Group.CopyPolicy.CREATE_AND_COPY) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("    - Creating local group : " + remoteGroup.name);
                }
                if ((localGrpId = this.createGroup(remoteGroup.name)) == null) {
                    this.log.info("    - Specified group was not found remotely : " + remoteGroup.name);
                    continue;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("    - Setting privileges for group : " + remoteGroup.name);
                }
                this.addOperations(id, localGrpId, oper);
                continue;
            }
            if (remoteGroup.policy == Group.CopyPolicy.COPY_TO_INTRANET) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("    - Setting privileges for 'intranet' group");
                }
                this.addOperations(id, "0", oper);
                continue;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("    - Setting privileges for group : " + remoteGroup.name);
            }
            this.addOperations(id, localGrpId, oper);
        }
    }

    protected void addOperations(String id, String groupId, Set<String> oper) throws Exception {
        for (String opName : oper) {
            int opId = this.accessManager.getPrivilegeId(opName);
            if (opId == 0 || opId == 1 || opId == 5 || opId == 6) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("       --> " + opName);
                }
                this.metadataOperations.setOperation(this.context, id, groupId, opId + "");
                continue;
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("       --> " + opName + " (skipped)");
        }
    }

    protected String createGroup(String name) {
        Map<String, String> hm = this.hmRemoteGroups.get(name);
        if (hm == null) {
            return null;
        }
        org.fao.geonet.domain.Group group = new org.fao.geonet.domain.Group().setName(name);
        group.getLabelTranslations().putAll(hm);
        group = (org.fao.geonet.domain.Group)((GroupRepository)this.context.getBean(GroupRepository.class)).save((Object)group);
        int id = group.getId();
        this.localGroups.add(name, id + "");
        return id + "";
    }

    protected Map<String, Set<String>> buildPrivileges(Element privil) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        for (Object o : privil.getChildren("group")) {
            Element group = (Element)o;
            String name = group.getAttributeValue("name");
            HashSet<String> set = new HashSet<String>();
            map.put(name, set);
            for (Object op : group.getChildren("operation")) {
                Element oper = (Element)op;
                name = oper.getAttributeValue("name");
                set.add(name);
            }
        }
        return map;
    }

    protected boolean existsFile(String fileName, Element files) {
        List list = files.getChildren("file");
        for (Element elem : list) {
            String name = elem.getAttributeValue("name");
            if (!fileName.equals(name)) continue;
            return true;
        }
        return false;
    }

    protected void saveFile(Store store, String metadataUuid, String file, MetadataResourceVisibility visibility, String changeDate, InputStream is) throws Exception {
        ISODate locIsoDate;
        Store.ResourceHolder resourceHolder;
        ISODate remIsoDate = new ISODate(changeDate);
        try {
            resourceHolder = store.getResource(this.context, metadataUuid, visibility, file, Boolean.valueOf(true));
        }
        catch (ResourceNotFoundException ex) {
            resourceHolder = null;
        }
        boolean saveFile = resourceHolder != null && resourceHolder.getMetadata() != null ? remIsoDate.timeDifferenceInSeconds(locIsoDate = new ISODate(resourceHolder.getMetadata().getLastModification().getTime(), false)) > 0L : true;
        if (saveFile) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("  - Adding remote " + metadataUuid + "  file with name:" + file);
            }
            store.putResource(this.context, metadataUuid, file, is, remIsoDate.toDate(), visibility, Boolean.valueOf(true));
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("  - Nothing to do in dir " + metadataUuid + " for file with name:" + file);
        }
    }

    protected void handleFile(String id, String file, MetadataResourceVisibility visibility, String changeDate, InputStream is, Element files) throws Exception {
        if (files == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("  - No file found in info.xml. Cannot update file:" + file);
            }
        } else {
            Store store = (Store)this.context.getBean("resourceStore", Store.class);
            IMetadataUtils metadataUtils = (IMetadataUtils)this.context.getBean(IMetadataUtils.class);
            String metadataUuid = metadataUtils.getMetadataUuid(id);
            this.removeOldFile(this.context, this.log, store, metadataUuid, files, visibility);
            this.saveFile(store, metadataUuid, file, visibility, changeDate, is);
        }
    }

    protected abstract Path retrieveMEF(String var1) throws URISyntaxException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMetadata(final RecordInfo ri, final boolean localRating, final String uuid) throws Exception {
        final String[] id = new String[]{null};
        final Element[] md = new Element[]{null};
        Path mefFile = null;
        try {
            mefFile = this.retrieveMEF(uuid);
            String fileType = "mef";
            MEFLib.Version version = MEFLib.getMEFVersion((Path)mefFile);
            if (version != null && version.equals((Object)MEFLib.Version.V2)) {
                fileType = "mef2";
            }
            MEF2Visitor visitor = fileType.equals("mef2") ? new MEF2Visitor() : new MEFVisitor();
            MEFLib.visit((Path)mefFile, (IVisitor)visitor, (IMEFVisitor)new IMEFVisitor(){

                public void handleMetadata(Element mdata, int index) throws Exception {
                    md[index] = mdata;
                }

                public void handleMetadataFiles(DirectoryStream<Path> files, Element info, int index) throws Exception {
                    Element metadataValidForImport = BaseGeoNetworkAligner.this.extractValidMetadataForImport(files, info);
                    if (metadataValidForImport != null) {
                        this.handleMetadata(metadataValidForImport, index);
                    }
                }

                public void handleInfo(Element info, int index) throws Exception {
                    Element schemaInfo;
                    Element general;
                    Element metadata = md[index];
                    String schema = BaseGeoNetworkAligner.this.metadataSchemaUtils.autodetectSchema(metadata, null);
                    if (info != null && info.getContentSize() != 0 && (general = info.getChild(BaseGeoNetworkAligner.GENERAL)) != null && general.getContentSize() != 0 && (schemaInfo = general.getChild("schema")) != null) {
                        schemaInfo.setText(schema);
                    }
                    if (info != null) {
                        id[index] = BaseGeoNetworkAligner.this.addMetadata(ri, md[index], info, localRating, uuid);
                    }
                }

                public void handlePublicFile(String file, String changeDate, InputStream is, int index) throws Exception {
                    this.handleFile(file, changeDate, is, index, MetadataResourceVisibility.PUBLIC);
                }

                private void handleFile(String file, String changeDate, InputStream is, int index, MetadataResourceVisibility visibility) throws Exception {
                    if (id[index] == null) {
                        return;
                    }
                    if (BaseGeoNetworkAligner.this.log.isDebugEnabled()) {
                        BaseGeoNetworkAligner.this.log.debug("    - Adding remote " + visibility + " file with name: " + file);
                    }
                    Store store = (Store)BaseGeoNetworkAligner.this.context.getBean("resourceStore", Store.class);
                    String metadataUuid = BaseGeoNetworkAligner.this.metadataUtils.getMetadataUuid(id[index]);
                    store.putResource(BaseGeoNetworkAligner.this.context, metadataUuid, file, is, new ISODate(changeDate).toDate(), visibility, Boolean.valueOf(true));
                }

                public void handleFeatureCat(Element md2, int index) throws Exception {
                }

                public void handlePrivateFile(String file, String changeDate, InputStream is, int index) throws Exception {
                    if (((BaseGeonetParams)((BaseGeoNetworkAligner)BaseGeoNetworkAligner.this).params).mefFormatFull) {
                        this.handleFile(file, changeDate, is, index, MetadataResourceVisibility.PRIVATE);
                    }
                }
            });
        }
        catch (Exception e) {
            this.log.info("  - Skipped unretrievable metadata (maybe has been removed) with uuid:" + ri.uuid);
            ++this.result.unretrievable;
            this.log.error((Throwable)e);
        }
        finally {
            if (mefFile != null) {
                FileUtils.deleteQuietly((File)mefFile.toFile());
            }
        }
    }

    private String addMetadata(RecordInfo ri, Element md, Element info, boolean localRating, String uuid) throws Exception {
        Element categs;
        String rating;
        Element general = info.getChild(GENERAL);
        String createDate = general.getChildText("createDate");
        String changeDate = general.getChildText("changeDate");
        String isTemplate = general.getChildText("isTemplate");
        String siteId = general.getChildText("siteId");
        String popularity = general.getChildText("popularity");
        String schema = general.getChildText("schema");
        isTemplate = "true".equals(isTemplate) ? "y" : "n";
        if (this.log.isDebugEnabled()) {
            this.log.debug("  - Adding metadata with remote uuid:" + ri.uuid);
        }
        try {
            Integer groupIdVal = null;
            if (StringUtils.isNotEmpty((String)((BaseGeonetParams)this.params).getOwnerIdGroup())) {
                groupIdVal = this.getGroupOwner();
            }
            ((BaseGeonetParams)this.params).getValidate().validate(this.dataMan, this.context, md, groupIdVal);
        }
        catch (Exception e) {
            this.log.info("Ignoring invalid metadata uuid: " + uuid);
            ++this.result.doesNotValidate;
            return null;
        }
        if (((BaseGeonetParams)this.params).mefFormatFull && ri.schema.startsWith("iso19139")) {
            MetadataResourceDatabaseMigration.updateMetadataResourcesLink((Element)md, null, (SettingManager)this.settingManager);
        }
        if (!((BaseGeonetParams)this.params).xslfilter.isEmpty()) {
            md = HarvesterUtil.processMetadata(this.metadataSchemaUtils.getSchema(schema), md, this.processName, this.processParams);
        }
        boolean ufo = ((BaseGeonetParams)this.params).mefFormatFull;
        Metadata metadata = new Metadata();
        metadata.setUuid(uuid);
        metadata.getDataInfo().setSchemaId(schema).setRoot(md.getQualifiedName()).setType(MetadataType.lookup((String)isTemplate)).setCreateDate(new ISODate(createDate)).setChangeDate(new ISODate(changeDate));
        metadata.getSourceInfo().setSourceId(siteId).setOwner(Integer.valueOf(this.getOwner()));
        metadata.getHarvestInfo().setHarvested(true).setUuid(((BaseGeonetParams)this.params).getUuid());
        try {
            metadata.getSourceInfo().setGroupOwner(Integer.valueOf(((BaseGeonetParams)this.params).getOwnerIdGroup()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.addCategories((AbstractMetadata)metadata, ((BaseGeonetParams)this.params).getCategories(), this.localCategory, this.context, null, false);
        metadata = this.metadataManager.insertMetadata(this.context, (AbstractMetadata)metadata, md, IndexingMode.none, ufo, UpdateDatestamp.NO, false, false);
        String id = String.valueOf(metadata.getId());
        if (!localRating && (rating = general.getChildText("rating")) != null) {
            metadata.getDataInfo().setRating(Integer.valueOf(rating).intValue());
        }
        if (popularity != null) {
            metadata.getDataInfo().setPopularity(Integer.valueOf(popularity).intValue());
        }
        if (((BaseGeonetParams)this.params).createRemoteCategory && (categs = info.getChild("categories")) != null) {
            Importer.addCategoriesToMetadata((AbstractMetadata)metadata, (Element)categs, (ServiceContext)this.context);
        }
        if (((ArrayList)((BaseGeonetParams)this.params).getGroupCopyPolicy()).isEmpty()) {
            this.addPrivileges(id, ((BaseGeonetParams)this.params).getPrivileges(), this.localGroups, this.context);
        } else {
            this.addPrivilegesFromGroupPolicy(id, info.getChild("privileges"));
        }
        ((IMetadataManager)this.context.getBean(IMetadataManager.class)).save((AbstractMetadata)metadata);
        this.metadataIndexer.indexMetadata(id, true, IndexingMode.full);
        ++this.result.addedMetadata;
        return id;
    }

    private Element extractValidMetadataForImport(DirectoryStream<Path> files, Element info) throws IOException, JDOMException {
        Element general;
        String finalPreferredSchema = this.preferredSchema;
        String infoSchema = "_none_";
        if (info != null && info.getContentSize() != 0 && (general = info.getChild(GENERAL)) != null && general.getContentSize() != 0 && general.getChildText("schema") != null) {
            infoSchema = general.getChildText("schema");
        }
        Path lastUnknownMetadataFolderName = null;
        if (Log.isDebugEnabled((String)"geonetwork.mef")) {
            Log.debug((String)"geonetwork.mef", (Object)"Multiple metadata files");
        }
        HashMap<String, Pair> mdFiles = new HashMap<String, Pair>();
        for (Path file : files) {
            if (!Files.isRegularFile(file, new LinkOption[0])) continue;
            Element metadata = Xml.loadFile((Path)file);
            try {
                Path parent = file.getParent();
                Path parent2 = parent.getParent();
                String metadataSchema = this.metadataSchemaUtils.autodetectSchema(metadata, null);
                if (metadataSchema == null) continue;
                String currFile = "Found metadata file " + parent2.relativize(file);
                mdFiles.put(metadataSchema, Pair.read((Object)currFile, (Object)metadata));
            }
            catch (NoSchemaMatchesException e) {
                Path parent2;
                Path parent = file.getParent();
                if (parent != null && (parent2 = parent.getParent()) != null) {
                    lastUnknownMetadataFolderName = parent2.relativize(parent);
                }
                this.log.debug("No schema match for " + lastUnknownMetadataFolderName + file.getFileName() + ".");
            }
            catch (NullPointerException e) {
                this.log.error("Check the schema directory");
                this.log.error((Throwable)e);
            }
        }
        if (mdFiles.isEmpty()) {
            this.log.debug("No valid metadata file found" + (lastUnknownMetadataFolderName == null ? "" : " in " + lastUnknownMetadataFolderName) + ".");
            return null;
        }
        Pair mdInform = (Pair)mdFiles.get(infoSchema);
        if (mdInform != null) {
            this.log.debug((String)mdInform.one() + " with info.xml schema (" + infoSchema + ").");
            Element metadataValidForImport = (Element)mdInform.two();
            return metadataValidForImport;
        }
        mdInform = (Pair)mdFiles.get(finalPreferredSchema);
        if (mdInform != null) {
            this.log.debug((String)mdInform.one() + " with preferred schema (" + finalPreferredSchema + ").");
            Element metadataValidForImport = (Element)mdInform.two();
            return metadataValidForImport;
        }
        String metadataSchema = (String)mdFiles.keySet().toArray()[0];
        mdInform = (Pair)mdFiles.get(metadataSchema);
        this.log.debug((String)mdInform.one() + " with known schema (" + metadataSchema + ").");
        Element metadataValidForImport = (Element)mdInform.two();
        return metadataValidForImport;
    }
}

