/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.openidconnect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.kernel.security.openidconnect.OIDCConfiguration;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.util.StringUtils;

public class OIDCRoleProcessor {
    @Autowired
    public OIDCConfiguration oidcConfiguration;

    public Map<Profile, List<String>> getProfileGroups(OidcIdToken idToken) {
        List<String> oidcOriginalRoleNames = this.getTokenRoles(idToken);
        oidcOriginalRoleNames.add(this.oidcConfiguration.minimumProfile);
        List<String> roleNames = this.simpleConvertRoles(oidcOriginalRoleNames);
        return this.getProfileGroups(roleNames);
    }

    public Map<Profile, List<String>> getProfileGroups(Map attributes) {
        List<String> oidcOriginalRoleNames = this.getTokenRoles(attributes);
        oidcOriginalRoleNames.add(this.oidcConfiguration.minimumProfile);
        List<String> roleNames = this.simpleConvertRoles(oidcOriginalRoleNames);
        return this.getProfileGroups(roleNames);
    }

    public Map<Profile, List<String>> getProfileGroups(OAuth2User user) {
        List<String> oidcOriginalRoleNames = this.getTokenRoles(user);
        oidcOriginalRoleNames.add(this.oidcConfiguration.minimumProfile);
        List<String> roleNames = this.simpleConvertRoles(oidcOriginalRoleNames);
        return this.getProfileGroups(roleNames);
    }

    public Profile getProfile(OidcIdToken idToken) {
        return this.getProfile(idToken.getClaims());
    }

    public Profile getProfile(OAuth2User user) {
        return this.getProfile(user.getAttributes());
    }

    public List<String> getTokenRoles(OidcIdToken idToken) {
        return this.getTokenRoles(idToken.getClaims());
    }

    public List<String> getTokenRoles(OAuth2User user) {
        return this.getTokenRoles(user.getAttributes());
    }

    public List<String> simpleConvertRoles(List<String> originalRoleNames) {
        return originalRoleNames.stream().map(x -> this.oidcConfiguration.roleConverter.get(x) == null ? x : this.oidcConfiguration.roleConverter.get(x)).distinct().collect(Collectors.toList());
    }

    public Collection<? extends GrantedAuthority> createAuthorities(RoleHierarchy roleHierarchy, OAuth2User user) {
        return this.createAuthorities(roleHierarchy, user.getAttributes());
    }

    public Collection<? extends GrantedAuthority> createAuthorities(RoleHierarchy roleHierarchy, Map<String, Object> claims) {
        List<String> oidcOriginalRoleNames = this.getTokenRoles(claims);
        return this.createAuthorities(roleHierarchy, oidcOriginalRoleNames);
    }

    public Collection<? extends GrantedAuthority> createAuthorities(RoleHierarchy roleHierarchy, List<String> oidcOriginalRoleNames) {
        oidcOriginalRoleNames.add(this.oidcConfiguration.minimumProfile);
        List<String> roleNames = this.simpleConvertRoles(oidcOriginalRoleNames);
        Map<Profile, List<String>> profileGroups = this.getProfileGroups(roleNames);
        List authorities = profileGroups.keySet().stream().map(x -> new SimpleGrantedAuthority(x.toString())).collect(Collectors.toList());
        return roleHierarchy.getReachableGrantedAuthorities(authorities);
    }

    public Profile getProfile(Map<String, Object> attributes) {
        List<String> oidcOriginalRoleNames = this.getTokenRoles(attributes);
        oidcOriginalRoleNames.add(this.oidcConfiguration.minimumProfile);
        List<String> roleNames = this.simpleConvertRoles(oidcOriginalRoleNames);
        Map<Profile, List<String>> profileGroups = this.getProfileGroups(roleNames);
        Profile profile = this.getMaxProfile(profileGroups);
        return profile;
    }

    public Profile getMaxProfile(Map<Profile, List<String>> profileGroups) {
        Profile maxProfile = null;
        for (Profile p : profileGroups.keySet()) {
            if (maxProfile == null) {
                maxProfile = p;
                continue;
            }
            if (maxProfile.compareTo((Enum)p) < 0) continue;
            maxProfile = p;
        }
        if (maxProfile == null) {
            maxProfile = Profile.Guest;
        }
        return maxProfile;
    }

    public Map<Profile, List<String>> getProfileGroups(List<String> rolesInToken) {
        String roleGroupSeparator = this.oidcConfiguration.groupPermissionSeparator;
        HashMap<Profile, List<String>> profileGroups = new HashMap<Profile, List<String>>();
        HashSet<String> roleGroupList = new HashSet<String>();
        for (String role : rolesInToken) {
            if (role.contains(roleGroupSeparator)) {
                Log.debug((String)"geonetwork.security", (Object)("Identified group:profile (" + role + ") from user token."));
                roleGroupList.add(role);
                continue;
            }
            Profile p = Profile.findProfileIgnoreCase((String)role);
            if (p == null || profileGroups.containsKey(p)) continue;
            profileGroups.put(p, new ArrayList());
        }
        for (String rg : roleGroupList) {
            String[] rg_role_groups = rg.split(roleGroupSeparator);
            if (rg_role_groups.length == 0 || StringUtils.isEmpty((Object)rg_role_groups[0])) continue;
            Profile p = null;
            if (rg_role_groups.length >= 1) {
                p = Profile.findProfileIgnoreCase((String)rg_role_groups[1]);
            }
            if (p == null) continue;
            List groups = profileGroups.containsKey(p) ? (List)profileGroups.get(p) : new ArrayList();
            if (rg_role_groups.length > 1) {
                groups.add(rg_role_groups[0]);
            }
            profileGroups.put(p, groups);
        }
        return profileGroups;
    }

    public List<String> getTokenRoles(Map<String, Object> attributes) {
        String pathToRoles = this.oidcConfiguration.getIdTokenRoleLocation();
        return this.getTokenRoles(attributes, pathToRoles);
    }

    public List<String> getTokenRoles(Map<String, Object> attributes, String pathToRoles) {
        if (!StringUtils.hasText((String)pathToRoles)) {
            Log.debug((String)"geonetwork.security", (Object)"oidc: pathToRoles is null/empty - cannot process");
            return new ArrayList<String>();
        }
        String[] paths = pathToRoles.trim().split("\\.");
        Map info = attributes;
        for (int t = 0; t < paths.length; ++t) {
            String path = paths[t];
            Object o = info.get(path);
            if (o == null) {
                Log.debug((String)"geonetwork.security", (Object)("oidc: pathToRoles - cannot find path component named: " + path));
                return new ArrayList<String>();
            }
            if (o instanceof Map) {
                info = (Map)o;
            }
            if (!(o instanceof List)) continue;
            if (t == paths.length - 1) {
                return new ArrayList<String>((List)o);
            }
            Log.debug((String)"geonetwork.security", (Object)("oidc: pathToRoles - found a list instead of item at " + path));
            return new ArrayList<String>();
        }
        Log.debug((String)"geonetwork.security", (Object)("oidc: pathToRoles - couldn't find role list - " + pathToRoles));
        return new ArrayList<String>();
    }
}

