/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.openidconnect;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.fao.geonet.kernel.security.openidconnect.GeonetworkClientRegistrationProvider;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.DefaultOAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;

public class HardcodedRegistrationIdOAuth2AuthorizationRequestResolver
implements OAuth2AuthorizationRequestResolver {
    ClientRegistrationRepository clientRegistrationRepository;
    String authorizationRequestBaseUri;
    AntPathRequestMatcher authorizationRequestMatcher;
    DefaultOAuth2AuthorizationRequestResolver wrappedResolver;

    public HardcodedRegistrationIdOAuth2AuthorizationRequestResolver(ClientRegistrationRepository clientRegistrationRepository, String authorizationRequestBaseUri) {
        this.clientRegistrationRepository = clientRegistrationRepository;
        this.authorizationRequestBaseUri = authorizationRequestBaseUri;
        this.authorizationRequestMatcher = new AntPathRequestMatcher(authorizationRequestBaseUri);
        this.wrappedResolver = new DefaultOAuth2AuthorizationRequestResolver(clientRegistrationRepository, authorizationRequestBaseUri);
    }

    public OAuth2AuthorizationRequest resolve(HttpServletRequest request) {
        if (!this.authorizationRequestMatcher.matches(request)) {
            return null;
        }
        HttpServletRequestWrapper wrappedRequest = new HttpServletRequestWrapper(request){

            public String getParameter(String name) {
                if (!name.equals("action")) {
                    return super.getParameter(name);
                }
                String value = super.getParameter(name);
                if (value == null) {
                    return "login";
                }
                return value;
            }
        };
        return this.wrappedResolver.resolve((HttpServletRequest)wrappedRequest, GeonetworkClientRegistrationProvider.CLIENTREGISTRATION_NAME);
    }

    public OAuth2AuthorizationRequest resolve(HttpServletRequest request, String clientRegistrationId) {
        if (!this.authorizationRequestMatcher.matches(request)) {
            return null;
        }
        HttpServletRequestWrapper wrappedRequest = new HttpServletRequestWrapper(request){

            public String getParameter(String name) {
                if (!name.equals("action")) {
                    return super.getParameter(name);
                }
                String value = super.getParameter(name);
                if (value == null) {
                    return "authorize";
                }
                return value;
            }
        };
        return this.wrappedResolver.resolve((HttpServletRequest)wrappedRequest, GeonetworkClientRegistrationProvider.CLIENTREGISTRATION_NAME);
    }
}

