/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.datamanager.base;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.constants.Edit;
import org.fao.geonet.constants.Geonet;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.MetadataValidation;
import org.fao.geonet.domain.MetadataValidationId;
import org.fao.geonet.domain.MetadataValidationStatus;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.domain.SchematronRequirement;
import org.fao.geonet.exceptions.JeevesException;
import org.fao.geonet.exceptions.SchematronValidationErrorEx;
import org.fao.geonet.exceptions.XSDValidationErrorEx;
import org.fao.geonet.kernel.SchematronValidator;
import org.fao.geonet.kernel.SchematronValidatorExternalMd;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataSchemaUtils;
import org.fao.geonet.kernel.datamanager.IMetadataValidator;
import org.fao.geonet.kernel.datamanager.base.BaseErrorHandlerAttachingErrorToElem;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.MetadataValidationRepository;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.fao.geonet.utils.XmlErrorHandler;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.transaction.annotation.Transactional;

public class BaseMetadataValidator
implements IMetadataValidator,
BaseErrorHandlerAttachingErrorToElem.ElementDecorator {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"geonetwork.datamanager");
    @Autowired
    private IMetadataSchemaUtils metadataSchemaUtils;
    @Autowired
    private SchematronValidator schematronValidator;
    @Autowired
    private SchematronValidatorExternalMd schematronValidatorExternalMd;
    @Autowired
    private MetadataValidationRepository validationRepository;
    @Autowired
    @Lazy
    private SettingManager settingManager;
    private IMetadataManager metadataManager;
    public static final Filter ErrorFinder = new Filter(){
        private static final long serialVersionUID = 1L;

        public boolean matches(Object obj) {
            if (obj instanceof Element) {
                Element element = (Element)obj;
                String name = element.getName();
                if (name.equals("error")) {
                    return true;
                }
                if (name.equals("failed-assert")) {
                    return true;
                }
            }
            return false;
        }
    };
    public static final Filter ReportFinder = new Filter(){
        private static final long serialVersionUID = 1L;

        public boolean matches(Object obj) {
            Element element;
            String name;
            return obj instanceof Element && ((name = (element = (Element)obj).getName()).equals("report") || name.equals("xsderrors"));
        }
    };

    @Override
    public void setMetadataManager(IMetadataManager metadataManager) {
        this.metadataManager = metadataManager;
    }

    @Override
    public void validateExternalMetadata(String schema, Element xml, ServiceContext context, String fileName, Integer groupOwner) throws Exception {
        this.setNamespacePrefix(xml);
        XmlErrorHandler eh = new XmlErrorHandler();
        Element xsdErrors = this.validateInfo(schema, xml, eh);
        if (xsdErrors != null) {
            if (!fileName.equals(" ")) {
                throw new XSDValidationErrorEx("XSD Validation error(s):\n" + Xml.getString((Element)xsdErrors) + "(in " + fileName + "): ", (Object)xsdErrors);
            }
            throw new XSDValidationErrorEx("XSD Validation error(s):\n" + Xml.getString((Element)xsdErrors), (Object)xsdErrors);
        }
        Element schemaTronReport = this.doSchemaTronForEditor(schema, xml, context.getLanguage(), groupOwner);
        xml.detach();
        if (schemaTronReport != null && schemaTronReport.getContent().size() > 0) {
            ArrayList<Namespace> theNSs = new ArrayList<Namespace>();
            theNSs.add(Namespace.getNamespace((String)"geonet", (String)"http://www.fao.org/geonetwork"));
            theNSs.add(Namespace.getNamespace((String)"svrl", (String)"http://purl.oclc.org/dsdl/svrl"));
            List informationalReports = Xml.selectNodes((Element)schemaTronReport, (String)("geonet:report[@geonet:required != '" + SchematronRequirement.REQUIRED + "']"), theNSs);
            for (Object informationalReport : informationalReports) {
                ((Element)informationalReport).detach();
            }
            List failedAssert = Xml.selectNodes((Element)schemaTronReport, (String)("geonet:report[@geonet:required = '" + SchematronRequirement.REQUIRED + "']/svrl:schematron-output/svrl:failed-assert"), theNSs);
            List failedSchematronVerification = Xml.selectNodes((Element)schemaTronReport, (String)("geonet:report[@geonet:required = '" + SchematronRequirement.REQUIRED + "']/geonet:schematronVerificationError"), theNSs);
            if (!failedAssert.isEmpty() || !failedSchematronVerification.isEmpty()) {
                StringBuilder errorReport = new StringBuilder();
                String errorReportSeparator = "";
                Iterator reports = schemaTronReport.getDescendants(ReportFinder);
                while (reports.hasNext()) {
                    Element report = (Element)reports.next();
                    Element schematronVerificationError = report.getChild("schematronVerificationError", Edit.NAMESPACE);
                    if (schematronVerificationError != null) {
                        errorReport.append(errorReportSeparator).append("schematronVerificationError: " + schematronVerificationError.getTextTrim());
                        errorReportSeparator = ", ";
                        continue;
                    }
                    Iterator errors = report.getDescendants(ErrorFinder);
                    while (errors.hasNext()) {
                        String reportType;
                        Element err = (Element)errors.next();
                        StringBuilder msg = new StringBuilder();
                        if (err.getName().equals("failed-assert")) {
                            reportType = report.getAttributeValue("rule", Edit.NAMESPACE);
                            reportType = reportType == null ? "No name for rule" : reportType;
                            Iterator descendants = err.getDescendants();
                            while (descendants.hasNext()) {
                                Object node = descendants.next();
                                if (!(node instanceof Element)) continue;
                                String textTrim = ((Element)node).getTextTrim();
                                msg.append(textTrim).append(" \n");
                            }
                        } else {
                            reportType = "Xsd Error";
                            msg.append(err.getChildText("message", Edit.NAMESPACE));
                        }
                        if (msg.length() <= 0) continue;
                        errorReport.append(errorReportSeparator).append(reportType).append(':').append((CharSequence)msg);
                        errorReportSeparator = ", ";
                    }
                }
                throw new SchematronValidationErrorEx("Schematron errors detected for file '" + fileName + "' - " + errorReport, (Object)schemaTronReport);
            }
        }
    }

    @Override
    public void setNamespacePrefix(Element md) {
        Namespace ns = md.getNamespace();
        if (ns != Namespace.NO_NAMESPACE && md.getNamespacePrefix().equals("")) {
            ns = Namespace.getNamespace((String)"gmd", (String)md.getNamespace().getURI());
            this.setNamespacePrefix(md, ns);
        }
    }

    @Override
    public void setNamespacePrefix(Element md, Namespace ns) {
        String xsiTypeValue;
        Attribute xsiType;
        if (md.getNamespaceURI().equals(ns.getURI())) {
            md.setNamespace(ns);
        }
        if ((xsiType = md.getAttribute("type", Geonet.Namespaces.XSI)) != null && StringUtils.isNotEmpty((String)(xsiTypeValue = xsiType.getValue())) && !xsiTypeValue.contains(":")) {
            xsiType.setValue(ns.getPrefix() + ":" + xsiType.getValue());
        }
        for (Object o : md.getChildren()) {
            this.setNamespacePrefix((Element)o, ns);
        }
    }

    @Override
    public void validate(String schema, Element md) throws Exception {
        XmlErrorHandler eh;
        Element xsdErrors;
        if (Log.isTraceEnabled((String)"geonetwork.datamanager")) {
            Log.trace((String)"geonetwork.datamanager", (Object)"Validating record ");
            Log.trace((String)"geonetwork.datamanager", (Object)new XMLOutputter().outputString(md));
        }
        if ((xsdErrors = this.validateInfo(schema, md, eh = new XmlErrorHandler())) != null) {
            throw new XSDValidationErrorEx("XSD Validation error(s):\n" + Xml.getString((Element)xsdErrors), (Object)xsdErrors);
        }
    }

    private Element validateInfo(String schema, Element md, XmlErrorHandler eh) throws Exception {
        boolean isSchemaLocationDefinedInMd;
        if (this.settingManager.getValueAsBool("system/metadata/validation/removeSchemaLocation", false)) {
            md.removeAttribute("schemaLocation", Geonet.Namespaces.XSI);
        }
        String schemaLoc = md.getAttributeValue("schemaLocation", Geonet.Namespaces.XSI);
        LOGGER.debug("Extracted schemaLocation of {}", (Object)schemaLoc);
        boolean noChoiceButToUseSchemaLocation = schema == null;
        boolean bl = isSchemaLocationDefinedInMd = schemaLoc != null && schemaLoc != "";
        if (noChoiceButToUseSchemaLocation || isSchemaLocationDefinedInMd) {
            return Xml.validateInfo((Element)md, (XmlErrorHandler)eh, (String)schema);
        }
        return Xml.validateInfo((Path)this.metadataSchemaUtils.getSchemaDir(schema).resolve("schema.xsd"), (Element)md, (XmlErrorHandler)eh, (String)schema);
    }

    @Override
    public Element doSchemaTronForEditor(String schema, Element md, String lang, Integer groupOwner) throws Exception {
        this.metadataManager.getEditLib().enumerateTree(md);
        Element schemaTronXmlReport = this.getSchemaTronXmlReport(schema, md, lang, null, groupOwner);
        this.metadataManager.getEditLib().removeEditingInfo(md);
        return schemaTronXmlReport;
    }

    private Element getXSDXmlReport(String schema, Element md, boolean forEditing) {
        BaseErrorHandlerAttachingErrorToElem errorHandler;
        if (forEditing) {
            errorHandler = new BaseErrorHandlerAttachingErrorToElem();
            errorHandler.setElementDecorator(this);
        } else {
            errorHandler = new XmlErrorHandler();
        }
        errorHandler.setNs(Edit.NAMESPACE);
        try {
            Element xsdErrors = this.validateInfo(schema, md, errorHandler);
            if (forEditing) {
                errorHandler.attachReports();
            }
            return xsdErrors;
        }
        catch (Exception e) {
            return JeevesException.toElement((Throwable)e);
        }
    }

    @Override
    public Element buildErrorReport(String type, String errorCode, String message, String xpath) {
        Element report = new Element("validationReport", Edit.NAMESPACE);
        report.setAttribute("type", type, Edit.NAMESPACE);
        report.setAttribute("path", xpath, Edit.NAMESPACE);
        report.setAttribute("error", errorCode, Edit.NAMESPACE);
        report.setAttribute("message", message, Edit.NAMESPACE);
        return report;
    }

    private Element getSchemaTronXmlReport(String schema, Element md, String lang, Map<String, Integer[]> valTypeAndStatus, Integer groupOwner) throws Exception {
        ArrayList<MetadataValidation> validations = new ArrayList<MetadataValidation>();
        Element schemaTronXmlOut = this.schematronValidatorExternalMd.applyCustomSchematronRules(schema, md, lang, validations, groupOwner);
        for (Element report : schemaTronXmlOut.getChildren()) {
            Element xmlReport = report.getChild("schematron-output", Geonet.Namespaces.SVRL);
            if (xmlReport == null) continue;
            String ruleId = xmlReport.getAttributeValue("rule", Edit.NAMESPACE);
            int firedRules = 0;
            Iterator firedRulesElems = xmlReport.getDescendants((Filter)new ElementFilter("fired-rule", Geonet.Namespaces.SVRL));
            while (firedRulesElems.hasNext()) {
                firedRulesElems.next();
                ++firedRules;
            }
            int invalidRules = 0;
            Iterator faileAssertElements = xmlReport.getDescendants((Filter)new ElementFilter("failed-assert", Geonet.Namespaces.SVRL));
            while (faileAssertElements.hasNext()) {
                faileAssertElements.next();
                ++invalidRules;
            }
            Integer[] results = new Integer[]{invalidRules != 0 ? 0 : 1, firedRules, invalidRules};
            if (valTypeAndStatus == null) continue;
            valTypeAndStatus.put(ruleId, results);
        }
        return schemaTronXmlOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pair<Element, Boolean> doValidate(AbstractMetadata metadata, String lang) throws Exception {
        Element md;
        String schema = metadata.getDataInfo().getSchemaId();
        int metadataId = metadata.getId();
        Element errorReport = new Element("report", Edit.NAMESPACE);
        errorReport.setAttribute("id", String.valueOf(metadataId), Edit.NAMESPACE);
        try {
            md = metadata.getXmlData(false);
        }
        catch (IOException | JDOMException e) {
            return Pair.read((Object)errorReport, (Object)false);
        }
        md = this.metadataManager.inflateMetadata(md, schema, lang);
        ArrayList<MetadataValidation> validations = new ArrayList<MetadataValidation>();
        boolean valid = true;
        LOGGER.debug("Validating against XSD {}", (Object)schema);
        Element xsdErrors = this.getXSDXmlReport(schema, md, false);
        int xsdErrorCount = 0;
        if (xsdErrors != null && xsdErrors.getContent().size() > 0) {
            xsdErrorCount = xsdErrors.getContent().size();
        }
        if (xsdErrorCount > 0) {
            errorReport.addContent((Content)xsdErrors);
            validations.add(new MetadataValidation().setId(new MetadataValidationId(metadataId, "xsd")).setStatus(MetadataValidationStatus.INVALID).setRequired(Boolean.valueOf(true)).setNumTests(xsdErrorCount).setNumFailures(xsdErrorCount));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("  - XSD error: {}", (Object)Xml.getString((Element)xsdErrors));
            }
            valid = false;
        } else {
            validations.add(new MetadataValidation().setId(new MetadataValidationId(metadataId, "xsd")).setStatus(MetadataValidationStatus.VALID).setRequired(Boolean.valueOf(true)).setNumTests(1).setNumFailures(0));
            LOGGER.debug("  - XSD Valid.");
        }
        try {
            this.metadataManager.getEditLib().enumerateTree(md);
            Element schemaTronReport = this.applyCustomSchematronRules(schema, metadataId, md, lang, validations);
            if (schemaTronReport != null) {
                ArrayList<Namespace> theNSs = new ArrayList<Namespace>();
                theNSs.add(Namespace.getNamespace((String)"geonet", (String)"http://www.fao.org/geonetwork"));
                theNSs.add(Namespace.getNamespace((String)"svrl", (String)"http://purl.oclc.org/dsdl/svrl"));
                List failedAssert = Xml.selectNodes((Element)schemaTronReport, (String)("geonet:report[@geonet:required = '" + SchematronRequirement.REQUIRED + "']/svrl:schematron-output/svrl:failed-assert"), theNSs);
                List failedSchematronVerification = Xml.selectNodes((Element)schemaTronReport, (String)("geonet:report[@geonet:required = '" + SchematronRequirement.REQUIRED + "']/geonet:schematronVerificationError"), theNSs);
                if (failedAssert.size() > 0 || failedSchematronVerification.size() > 0) {
                    valid = false;
                    errorReport.addContent((Content)schemaTronReport);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("  - Schematron error: {}", (Object)Xml.getString((Element)schemaTronReport));
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not run schematron validation on metadata {}.", (Object)metadataId);
            LOGGER.error("Could not run schematron validation on metadata, exception", (Throwable)e);
            valid = false;
        }
        finally {
            this.metadataManager.getEditLib().removeEditingInfo(md);
        }
        this.saveValidationStatus(metadataId, validations);
        return Pair.read((Object)errorReport, (Object)valid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pair<Element, String> doValidate(UserSession session, String schema, String metadataId, Element md, String lang, boolean forEditing) throws Exception {
        int intMetadataId = Integer.parseInt(metadataId);
        String version = null;
        LOGGER.debug("Creating validation report for record #{} [schema: {}].", (Object)metadataId, (Object)schema);
        Element sessionReport = (Element)session.getProperty("validation.report" + metadataId);
        if (sessionReport != null && !forEditing) {
            LOGGER.debug("  Validation report available in session.");
            sessionReport.detach();
            return Pair.read((Object)sessionReport, version);
        }
        ArrayList<MetadataValidation> validations = new ArrayList<MetadataValidation>();
        Element errorReport = new Element("report", Edit.NAMESPACE);
        errorReport.setAttribute("id", metadataId, Edit.NAMESPACE);
        Element xsdErrors = this.getXSDXmlReport(schema, md, forEditing);
        int xsdErrorCount = 0;
        if (xsdErrors != null) {
            xsdErrorCount = xsdErrors.getContent().size();
        }
        if (xsdErrorCount > 0) {
            errorReport.addContent((Content)xsdErrors);
            validations.add(new MetadataValidation().setId(new MetadataValidationId(intMetadataId, "xsd")).setStatus(MetadataValidationStatus.INVALID).setRequired(Boolean.valueOf(true)).setNumTests(xsdErrorCount).setNumFailures(xsdErrorCount));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("  - XSD error: {}", (Object)Xml.getString((Element)xsdErrors));
            }
        } else {
            validations.add(new MetadataValidation().setId(new MetadataValidationId(intMetadataId, "xsd")).setStatus(MetadataValidationStatus.VALID).setRequired(Boolean.valueOf(true)).setNumTests(1).setNumFailures(0));
            LOGGER.trace("Valid.");
        }
        Element error = null;
        if (forEditing) {
            LOGGER.debug("  - Schematron in editing mode.");
            this.metadataManager.getEditLib().expandElements(schema, md);
            version = this.metadataManager.getEditLib().getVersionForEditing(schema, metadataId, md);
            error = this.applyCustomSchematronRules(schema, intMetadataId, md, lang, validations);
        } else {
            this.metadataManager.getEditLib().enumerateTree(md);
            try {
                error = this.applyCustomSchematronRules(schema, intMetadataId, md, lang, validations);
            }
            catch (Exception e) {
                LOGGER.error("Could not run schematron validation on metadata {}.", (Object)metadataId);
                LOGGER.error("Could not run schematron validation on metadata, exception.", (Throwable)e);
            }
            finally {
                this.metadataManager.getEditLib().removeEditingInfo(md);
            }
        }
        if (error != null) {
            errorReport.addContent((Content)error);
        }
        this.saveValidationStatus(intMetadataId, validations);
        session.setProperty("validation.report" + metadataId, errorReport);
        return Pair.read((Object)errorReport, (Object)version);
    }

    @Override
    public Element applyCustomSchematronRules(String schema, int metadataId, Element md, String lang, List<MetadataValidation> validations) {
        return this.schematronValidator.applyCustomSchematronRules(schema, metadataId, md, lang, validations);
    }

    @Transactional
    void saveValidationStatus(int id, List<MetadataValidation> validations) {
        try {
            this.validationRepository.deleteAllInternalValidationById_MetadataId(Integer.valueOf(id));
            this.validationRepository.saveAll(validations);
        }
        catch (Exception e) {
            LOGGER.error("Could not save validation status on metadata {}.", (Object)id);
            LOGGER.error("Could not save validation status on metadata, exception: ", (Throwable)e);
        }
    }

    @Override
    public boolean validate(Element xml) {
        try {
            String schema = this.metadataSchemaUtils.autodetectSchema(xml);
            this.validate(schema, xml);
            return true;
        }
        catch (Exception x) {
            LOGGER.debug("invalid metadata", (Throwable)x);
            return false;
        }
    }
}

