/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.datamanager.base;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.persistence.metamodel.SingularAttribute;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.MetadataStatus;
import org.fao.geonet.domain.MetadataStatus_;
import org.fao.geonet.domain.StatusValue;
import org.fao.geonet.domain.StatusValueType;
import org.fao.geonet.kernel.datamanager.IMetadataIndexer;
import org.fao.geonet.kernel.datamanager.IMetadataStatus;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.search.IndexingMode;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.MetadataStatusRepository;
import org.fao.geonet.repository.SortUtils;
import org.fao.geonet.repository.StatusValueRepository;
import org.fao.geonet.repository.specification.MetadataStatusSpecs;
import org.fao.geonet.util.WorkflowUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Sort;

public class BaseMetadataStatus
implements IMetadataStatus {
    @Autowired
    private MetadataStatusRepository metadataStatusRepository;
    @Autowired
    private IMetadataIndexer metadataIndexer;
    @Autowired
    private StatusValueRepository statusValueRepository;
    @Autowired
    private GroupRepository groupRepository;
    @Autowired
    @Lazy
    private SettingManager settingManager;
    @Autowired
    IMetadataUtils metadataUtils;

    @Override
    public boolean isUserMetadataStatus(int userId) throws Exception {
        return this.metadataStatusRepository.count(MetadataStatusSpecs.hasUserId((int)userId)) > 0L;
    }

    @Override
    public void transferMetadataStatusOwnership(int oldUserId, int newUserId) throws Exception {
        List oldUserStatus = this.metadataStatusRepository.findAll(MetadataStatusSpecs.hasUserId((int)oldUserId));
        oldUserStatus.stream().forEach(s -> s.setUserId(newUserId));
        this.metadataStatusRepository.saveAll((Iterable)oldUserStatus);
    }

    @Override
    public MetadataStatus getStatus(int metadataId) throws Exception {
        String sortField = SortUtils.createPath((SingularAttribute[])new SingularAttribute[]{MetadataStatus_.changeDate});
        List status = this.metadataStatusRepository.findAllByMetadataIdAndByType(metadataId, StatusValueType.workflow, Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{sortField}));
        if (status.isEmpty()) {
            return null;
        }
        return (MetadataStatus)status.get(0);
    }

    @Override
    public MetadataStatus getPreviousStatus(int metadataId) throws Exception {
        String sortField = SortUtils.createPath((SingularAttribute[])new SingularAttribute[]{MetadataStatus_.id, MetadataStatus_.changeDate});
        List metadataStatusList = this.metadataStatusRepository.findAllByMetadataIdAndByType(metadataId, StatusValueType.workflow, Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{sortField}));
        if (metadataStatusList.isEmpty() || metadataStatusList.size() == 1) {
            return null;
        }
        return (MetadataStatus)metadataStatusList.get(1);
    }

    @Override
    public List<MetadataStatus> getAllStatus(int metadataId) throws Exception {
        String sortField = SortUtils.createPath((SingularAttribute[])new SingularAttribute[]{MetadataStatus_.changeDate});
        List status = this.metadataStatusRepository.findAllByMetadataId(metadataId, Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{sortField}));
        if (status.isEmpty()) {
            return null;
        }
        return status;
    }

    @Override
    public String getCurrentStatus(int metadataId) throws Exception {
        MetadataStatus status = this.getStatus(metadataId);
        if (status == null) {
            return "1";
        }
        return String.valueOf(status.getStatusValue().getId());
    }

    @Override
    @Deprecated
    public MetadataStatus setStatus(ServiceContext context, int id, int status, ISODate changeDate, String changeMessage) throws Exception {
        MetadataStatus statusObject = this.setStatusExt(context, id, status, changeDate, changeMessage);
        this.metadataIndexer.indexMetadata(Integer.toString(id), true, IndexingMode.full);
        return statusObject;
    }

    @Override
    public MetadataStatus setStatusExt(MetadataStatus metatatStatus, boolean updateIndex) throws Exception {
        this.metadataStatusRepository.save((Object)metatatStatus);
        if (updateIndex) {
            this.metadataIndexer.indexMetadata(metatatStatus.getMetadataId() + "", true, IndexingMode.full);
        }
        return metatatStatus;
    }

    @Override
    public MetadataStatus setStatusExt(ServiceContext context, int id, int status, ISODate changeDate, String changeMessage) throws Exception {
        Optional statusValue = this.statusValueRepository.findById((Object)status);
        if (!statusValue.isPresent()) {
            throw new IllegalArgumentException("The workflow status change requested is not valid: " + status);
        }
        MetadataStatus metatatStatus = new MetadataStatus();
        metatatStatus.setChangeMessage(changeMessage);
        metatatStatus.setStatusValue((StatusValue)statusValue.get());
        int userId = context.getUserSession().getUserIdAsInt();
        metatatStatus.setMetadataId(id);
        metatatStatus.setChangeDate(changeDate);
        metatatStatus.setUserId(userId);
        metatatStatus.setUuid(this.metadataUtils.getMetadataUuid(Integer.toString(id)));
        metatatStatus.setTitles(this.metadataUtils.extractTitles(Integer.toString(id)));
        return (MetadataStatus)this.metadataStatusRepository.save((Object)metatatStatus);
    }

    @Override
    public void activateWorkflowIfConfigured(ServiceContext context, String newId, String groupOwner) throws Exception {
        if (StringUtils.isEmpty((String)groupOwner)) {
            return;
        }
        Optional group = this.groupRepository.findById((Object)Integer.valueOf(groupOwner));
        String groupName = "";
        if (group.isPresent()) {
            groupName = ((Group)group.get()).getName();
        }
        if (WorkflowUtil.isGroupWithEnabledWorkflow(groupName)) {
            this.setStatus(context, Integer.valueOf(newId), Integer.valueOf("1"), new ISODate(), String.format("Workflow automatically enabled for record in group '%s'. Record status is set to %s.", groupName, "1"));
        }
    }

    @Override
    public void changeCurrentStatus(Integer userId, Integer metadataId, Integer newStatus) throws Exception {
        String nextStatus;
        Optional statusValue = this.statusValueRepository.findById((Object)newStatus);
        if (!statusValue.isPresent()) {
            throw new IllegalArgumentException("The workflow status change requested is not valid: " + newStatus);
        }
        String currentState = this.getCurrentStatus(metadataId);
        if (!BaseMetadataStatus.verifyAllowedStatusTransition(currentState, nextStatus = String.valueOf(newStatus))) {
            throw new IllegalArgumentException("The workflow status change requested is not allowed");
        }
        MetadataStatus metatatStatus = new MetadataStatus();
        metatatStatus.setChangeMessage("");
        metatatStatus.setStatusValue((StatusValue)statusValue.get());
        metatatStatus.setMetadataId(metadataId.intValue());
        metatatStatus.setChangeDate(new ISODate());
        metatatStatus.setUserId(userId.intValue());
        metatatStatus.setUuid(this.metadataUtils.getMetadataUuid(Integer.toString(metadataId)));
        metatatStatus.setTitles(this.metadataUtils.extractTitles(Integer.toString(metadataId)));
        this.metadataStatusRepository.save((Object)metatatStatus);
        this.metadataIndexer.indexMetadata(metadataId + "", true, IndexingMode.full);
    }

    public static boolean verifyAllowedStatusTransition(String currentState, String nextStatus) {
        HashSet<String> draftCompatible = new HashSet<String>();
        draftCompatible.add("1");
        draftCompatible.add("4");
        draftCompatible.add("3");
        HashSet<String> submittedCompatible = new HashSet<String>();
        submittedCompatible.add("1");
        submittedCompatible.add("4");
        submittedCompatible.add("2");
        HashSet<String> approvedCompatible = new HashSet<String>();
        approvedCompatible.add("4");
        approvedCompatible.add("2");
        approvedCompatible.add("1");
        HashSet<String> retiredCompatible = new HashSet<String>();
        retiredCompatible.add("1");
        retiredCompatible.add("4");
        retiredCompatible.add("2");
        retiredCompatible.add("3");
        if ("1".equals(currentState) && draftCompatible.contains(nextStatus)) {
            return true;
        }
        if ("4".equals(currentState) && submittedCompatible.contains(nextStatus)) {
            return true;
        }
        if ("2".equals(currentState) && approvedCompatible.contains(nextStatus)) {
            return true;
        }
        return "3".equals(currentState) && retiredCompatible.contains(nextStatus);
    }

    public boolean canEditorEdit(Integer metadataId) throws Exception {
        String currentState = this.getCurrentStatus(metadataId);
        HashSet<String> draftCompatible = new HashSet<String>();
        draftCompatible.add("1");
        draftCompatible.add("2");
        draftCompatible.add("3");
        return draftCompatible.contains(currentState);
    }
}

