/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.persistence.metamodel.SingularAttribute;
import javax.sql.DataSource;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import jeeves.transaction.AfterCommitTransactionListener;
import jeeves.transaction.BeforeRollbackTransactionListener;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.Constants;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.MetadataCategory;
import org.fao.geonet.domain.MetadataStatus;
import org.fao.geonet.domain.Operation;
import org.fao.geonet.domain.OperationAllowed;
import org.fao.geonet.domain.OperationAllowedId;
import org.fao.geonet.domain.OperationAllowedId_;
import org.fao.geonet.domain.OperationAllowed_;
import org.fao.geonet.domain.User;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.SvnUtils;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.kernel.setting.Settings;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.fao.geonet.repository.OperationRepository;
import org.fao.geonet.repository.SortUtils;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.specification.OperationAllowedSpecs;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SvnManager
implements AfterCommitTransactionListener,
BeforeRollbackTransactionListener {
    private static String username = "geonetwork";
    private static String password = "geonetwork";
    private ServiceContext context;
    private SVNURL repoUrl;
    private String subversionPath;
    private Map<TransactionStatus, SvnTask> tasks = new ConcurrentHashMap<TransactionStatus, SvnTask>();
    private boolean _enabled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws Exception {
        String dbUrl;
        SettingManager _settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        if (!_settingManager.getValueAsBool("metadata/vcs/enable")) {
            Log.debug((String)"geonetwork.svnmanager", (Object)String.format("VCS is disabled. Change the %s setting and restart the application", "metadata/vcs/enable"));
            return;
        }
        DataSource _dataSource = (DataSource)ApplicationContextHolder.get().getBean(DataSource.class);
        this._enabled = true;
        String uuid = _settingManager.getValue(Settings.SYSTEM_SITE_SVNUUID);
        boolean dbCreated = false;
        if (StringUtils.isEmpty((String)uuid)) {
            dbCreated = true;
            uuid = UUID.randomUUID().toString();
            _settingManager.setValue(Settings.SYSTEM_SITE_SVNUUID, uuid);
        }
        File subFile = new File(this.subversionPath);
        boolean repoCreated = false;
        try {
            boolean enableRevisionProperties = true;
            boolean force = false;
            this.repoUrl = SVNRepositoryFactory.createLocalRepository((File)subFile, (String)uuid, (boolean)enableRevisionProperties, (boolean)force);
            repoCreated = true;
        }
        catch (SVNException e) {
            if (subFile.exists()) {
                subFile = subFile.getCanonicalFile();
                this.repoUrl = SVNURL.fromFile((File)subFile);
            }
            Log.error((String)"geonetwork.svnmanager", (String)("Problem creating or using repository at path " + this.subversionPath + ", " + e.getMessage()), (Throwable)e);
            throw new IllegalArgumentException("Problem creating or using repository at path " + this.subversionPath);
        }
        SVNRepository repo = null;
        try {
            repo = this.getRepository();
        }
        catch (SVNException se) {
            Log.error((String)"geonetwork.svnmanager", (String)("Failed to open subversion repo at path " + this.subversionPath), (Throwable)se);
            throw se;
        }
        if (!repoCreated) {
            String repoUuid = repo.getRepositoryUUID(true);
            long latestRev = repo.getLatestRevision();
            if (latestRev > 1L) {
                if (!uuid.equals(repoUuid)) {
                    throw new IllegalArgumentException("Subversion repository at " + this.subversionPath + " has uuid " + repoUuid + " which does not match repository uuid held in database " + uuid);
                }
            } else if (!uuid.equals(repoUuid)) {
                Log.warning((String)"geonetwork.svnmanager", (Object)("Recreating subversion repository at " + this.subversionPath + " as previous repository was empty"));
                boolean enableRevisionProperties = true;
                boolean force = true;
                this.repoUrl = SVNRepositoryFactory.createLocalRepository((File)subFile, (String)uuid, (boolean)enableRevisionProperties, (boolean)force);
                repoCreated = true;
                repo = this.getRepository();
            }
        }
        try (Connection conn = null;){
            conn = _dataSource.getConnection();
            dbUrl = conn.getMetaData().getURL();
        }
        if (dbCreated || repoCreated) {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("geonet:dburl", dbUrl);
            ISVNEditor editor = this.getEditor("Setting geonet:dburl to " + dbUrl);
            editor.openRoot(-1L);
            SvnUtils.modifyFileProps(editor, "/", props);
            editor.closeDir();
            SVNCommitInfo info = editor.closeEdit();
            if (Log.isDebugEnabled((String)"geonetwork.svnmanager")) {
                Log.debug((String)"geonetwork.svnmanager", (Object)("Committed " + dbUrl + " as property " + "geonet:dburl" + ":" + info));
            }
        } else {
            SVNProperties rootProps = new SVNProperties();
            Collection nullColl = null;
            repo.getDir("/", -1L, rootProps, nullColl);
            String repoDbUrl = rootProps.getStringValue("geonet:dburl").trim();
            if (repoDbUrl == null || !dbUrl.trim().equals(repoDbUrl)) {
                throw new IllegalArgumentException("Repository uses database URL of '" + repoDbUrl + "' which does not match current database URL '" + dbUrl + "'. Modify the svn property " + "geonet:dburl" + " on the root of the subversion repository at " + this.subversionPath + " or specify a different subversion repository");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterCommit(TransactionStatus status) {
        if (!this._enabled) {
            return;
        }
        SvnTask task = this.tasks.get(status);
        ISVNEditor editor = null;
        if (task != null) {
            try {
                editor = this.getEditor(task.sessionLogMessage + " (committing transaction " + status + ")");
                editor.openRoot(-1L);
                Iterator<String> it = task.ids.iterator();
                while (it.hasNext()) {
                    String id = it.next();
                    this.commitMetadata(id, editor);
                    it.remove();
                }
                editor.closeDir();
                if (Log.isDebugEnabled((String)"geonetwork.svnmanager")) {
                    Log.debug((String)"geonetwork.svnmanager", (Object)("Committed changes to subversion repository for metadata ids " + task.ids));
                }
            }
            catch (Exception e) {
                Log.error((String)"geonetwork.svnmanager", (String)("Failed to commit changes to subversion repository for metadata ids " + task.ids), (Throwable)e);
                if (editor != null) {
                    try {
                        editor.abortEdit();
                    }
                    catch (Exception ex) {
                        Log.error((String)"geonetwork.svnmanager", (String)"Failed to abort subversion editor", (Throwable)ex);
                    }
                }
            }
            finally {
                this.tasks.remove(status);
            }
        }
    }

    @Override
    public void beforeRollback(@Nonnull TransactionStatus status) {
        if (!this._enabled) {
            return;
        }
        this.tasks.remove(status);
    }

    public void setSubversionPath(String subversionPath) {
        this.subversionPath = subversionPath;
    }

    public void setContext(ServiceContext context) {
        this.context = context;
    }

    private String sessionToLogMessage(ServiceContext context) {
        UserSession session = context.getUserSession();
        if (session == null) {
            session = this.getDefaultSession();
        }
        String result = "GeoNetwork service: " + context.getService() + " GeoNetwork User " + session.getUserIdAsInt() + " (Username: " + session.getUsername() + " Name: " + session.getName() + " " + session.getSurname() + ") Executed from IP address " + context.getIpAddress();
        return result;
    }

    private Map<String, String> sessionToProps(ServiceContext context, Map<String, String> props) {
        UserSession session = context.getUserSession();
        if (session == null) {
            session = this.getDefaultSession();
        }
        props.put("geonet:operator", session.getUserId());
        props.put("geonet:username", session.getUsername());
        props.put("geonet:name", session.getName());
        props.put("geonet:surname", session.getSurname());
        props.put("geonet:service", context.getService());
        props.put("geonet:ipaddress", context.getIpAddress());
        return props;
    }

    private UserSession getDefaultSession() {
        UserSession session = new UserSession();
        return session;
    }

    public void setHistory(String id, ServiceContext context) throws Exception {
        if (!this._enabled) {
            return;
        }
        if (!this.exists(id)) {
            return;
        }
        if (Log.isDebugEnabled((String)"geonetwork.svnmanager")) {
            Log.debug((String)"geonetwork.svnmanager", (Object)("History will be recorded on metadata " + id));
        }
        Map<String, String> props = this.sessionToProps(context, new HashMap<String, String>());
        try {
            TransactionStatus status = TransactionAspectSupport.currentTransactionStatus();
            this.checkSvnTask(status, id, this.sessionToLogMessage(context), props);
            if (Log.isDebugEnabled((String)"geonetwork.svnmanager")) {
                Log.debug((String)"geonetwork.svnmanager", (Object)("Changes to metadata " + id + " will be committed/aborted with the database channel " + status));
            }
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.svnmanager", (String)("Failed to set history for metadata to subversion repo at path " + this.subversionPath), (Throwable)e);
        }
    }

    private Element getFile(String id, String file) throws Exception {
        if (!this.exists(id)) {
            return null;
        }
        String filePath = id + "/" + file;
        SVNRepository repo = this.getRepository();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        repo.getFile(filePath, -1L, new SVNProperties(), (OutputStream)baos);
        Element rec = Xml.loadString((String)baos.toString(Constants.ENCODING), (boolean)false);
        return (Element)rec.detach();
    }

    public void createMetadataDir(String id, ServiceContext context, Element md) throws Exception {
        if (!this._enabled) {
            return;
        }
        if (this.exists(id)) {
            return;
        }
        String logMessage = this.sessionToLogMessage(context) + " adding directory for metadata " + id;
        if (Log.isDebugEnabled((String)"geonetwork.svnmanager")) {
            Log.debug((String)"geonetwork.svnmanager", (Object)logMessage);
        }
        ISVNEditor editor = this.getEditor(logMessage);
        try {
            editor.openRoot(-1L);
            SvnUtils.addDir(editor, id);
            if (Log.isDebugEnabled((String)"geonetwork.svnmanager")) {
                Log.debug((String)"geonetwork.svnmanager", (Object)("Directory for metadata " + id + " was added"));
            }
            editor.closeDir();
            editor.closeEdit();
        }
        catch (SVNException svne) {
            Log.error((String)"geonetwork.svnmanager", (String)("Create metadata dir. error: " + svne.getMessage()), (Throwable)svne);
            editor.abortEdit();
            throw svne;
        }
        try {
            logMessage = this.sessionToLogMessage(context) + " adding initial version of metadata " + id;
            editor = this.getEditor(logMessage);
            editor.openRoot(-1L);
            ISVNEditor finalEditor = editor;
            this.commitMetadata(id, finalEditor);
            if (Log.isDebugEnabled((String)"geonetwork.svnmanager")) {
                Log.debug((String)"geonetwork.svnmanager", (Object)("Metadata " + id + " was added"));
            }
            editor.closeDir();
            SVNCommitInfo commitInfo = editor.closeEdit();
            if (Log.isDebugEnabled((String)"geonetwork.svnmanager")) {
                Log.debug((String)"geonetwork.svnmanager", (Object)("Commit returned " + commitInfo));
            }
        }
        catch (SVNException svne) {
            Log.error((String)"geonetwork.svnmanager", (String)("Create metadata dir. error: " + svne.getMessage()), (Throwable)svne);
            editor.abortEdit();
            throw svne;
        }
    }

    public void deleteDir(String id, ServiceContext context) throws Exception {
        if (!this._enabled) {
            return;
        }
        if (!this.exists(id)) {
            return;
        }
        String logMessage = this.sessionToLogMessage(context) + " deleting directory for metadata " + id;
        if (Log.isDebugEnabled((String)"geonetwork.svnmanager")) {
            Log.debug((String)"geonetwork.svnmanager", (Object)logMessage);
        }
        ISVNEditor editor = this.getEditor(logMessage);
        try {
            SvnUtils.deleteDir(editor, id);
            SVNCommitInfo commitInfo = editor.closeEdit();
            if (Log.isDebugEnabled((String)"geonetwork.svnmanager")) {
                Log.debug((String)"geonetwork.svnmanager", (Object)("Directory for metadata " + id + " deleted: " + commitInfo));
            }
        }
        catch (SVNException svne) {
            Log.error((String)"geonetwork.svnmanager", (String)("Delete metadata dir. error: " + svne.getMessage()), (Throwable)svne);
            editor.abortEdit();
            throw svne;
        }
    }

    private void checkSvnTask(TransactionStatus transaction, String id, String sessionLogMessage, Map<String, String> props) throws Exception {
        Set<String> ids;
        SvnTask task = this.tasks.get(transaction);
        if (task == null) {
            task = new SvnTask();
            task.ids = new HashSet<String>();
            task.sessionLogMessage = sessionLogMessage;
            this.tasks.put(transaction, task);
        }
        if (!(ids = task.ids).contains(id)) {
            ids.add(id);
        }
    }

    private SVNRepository getNewRepository() throws SVNException {
        SVNRepository repository = SVNRepositoryFactory.create((SVNURL)this.repoUrl);
        if (username != null) {
            ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((File)new File(this.repoUrl.getPath()), (String)username, (String)password);
            repository.setAuthenticationManager(authManager);
        }
        return repository;
    }

    private ISVNEditor getEditor(String logMessage) throws SVNException {
        SVNRepository repository = this.getNewRepository();
        ISVNEditor editor = repository.getCommitEditor(logMessage, null, false, null);
        return editor;
    }

    private SVNRepository getRepository() throws SVNException {
        return this.getNewRepository();
    }

    public void commitMetadata(String id, ISVNEditor editor) throws Exception {
        if (!this._enabled) {
            return;
        }
        DataManager dataMan = this.context.getBean(DataManager.class);
        try {
            this.commitMetadataChanges(editor, id, dataMan);
            this.commitMetadataOwner(editor, id);
            this.commitMetadataPrivileges(editor, id);
            this.commitMetadataCategories(editor, id, dataMan);
            this.commitMetadataStatus(editor, id, dataMan);
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.svnmanager", (String)("Failed to commit metadata to  subversion repo at path " + this.subversionPath), (Throwable)e);
            editor.abortEdit();
            throw e;
        }
    }

    private void commitMetadataCategories(ISVNEditor editor, String id, DataManager dataMan) throws Exception {
        Collection<MetadataCategory> categs = dataMan.getCategories(id);
        Element catXml = new Element("results");
        for (MetadataCategory categ : categs) {
            catXml.addContent((Content)new Element("record").addContent((Content)new Element("id").setText("" + categ.getId())).addContent((Content)new Element("name").setText(categ.getName())));
        }
        String now = Xml.getString((Element)catXml);
        if (this.exists(id + "/categories.xml")) {
            Element categsPrevVersion = this.getFile(id, "categories.xml");
            String old = Xml.getString((Element)categsPrevVersion);
            if (!old.equals(now)) {
                SvnUtils.modifyFile(editor, id + "/categories.xml", old.getBytes(Constants.ENCODING), now.getBytes(Constants.ENCODING));
                if (Log.isDebugEnabled((String)"geonetwork.svnmanager")) {
                    Log.debug((String)"geonetwork.svnmanager", (Object)("Categories of metadata " + id + " updated"));
                }
            }
        } else {
            SvnUtils.addFile(editor, id + "/categories.xml", now.getBytes(Constants.ENCODING));
            if (Log.isDebugEnabled((String)"geonetwork.svnmanager")) {
                Log.debug((String)"geonetwork.svnmanager", (Object)("Categories of metadata " + id + " added"));
            }
        }
    }

    private void commitMetadataStatus(ISVNEditor editor, String id, DataManager dataMan) throws Exception {
        MetadataStatus status = dataMan.getStatus(Integer.valueOf(id));
        if (status == null) {
            return;
        }
        String now = Xml.getString((Element)status.getAsXml());
        if (this.exists(id + "/status.xml")) {
            Element statusPrevVersion = this.getFile(id, "status.xml");
            String old = Xml.getString((Element)statusPrevVersion);
            if (!old.equals(now)) {
                SvnUtils.modifyFile(editor, id + "/status.xml", old.getBytes(Constants.ENCODING), now.getBytes(Constants.ENCODING));
                if (Log.isDebugEnabled((String)"geonetwork.svnmanager")) {
                    Log.debug((String)"geonetwork.svnmanager", (Object)("Status of metadata " + id + " was updated"));
                }
            }
        } else {
            SvnUtils.addFile(editor, id + "/status.xml", now.getBytes(Constants.ENCODING));
            if (Log.isDebugEnabled((String)"geonetwork.svnmanager")) {
                Log.debug((String)"geonetwork.svnmanager", (Object)("Status of metadata " + id + " was added"));
            }
        }
    }

    private void commitMetadataChanges(ISVNEditor editor, String id, DataManager dataMan) throws Exception {
        Element md = dataMan.getMetadata(id);
        String now = Xml.getString((Element)md);
        if (this.exists(id + "/metadata.xml")) {
            Element mdPrevVersion = this.getFile(id, "metadata.xml");
            String old = Xml.getString((Element)mdPrevVersion);
            if (!old.equals(now)) {
                SvnUtils.modifyFile(editor, id + "/metadata.xml", old.getBytes(Constants.ENCODING), now.getBytes(Constants.ENCODING));
                if (Log.isDebugEnabled((String)"geonetwork.svnmanager")) {
                    Log.debug((String)"geonetwork.svnmanager", (Object)("Metadata " + id + " was updated"));
                }
            }
        } else {
            SvnUtils.addFile(editor, id + "/metadata.xml", now.getBytes(Constants.ENCODING));
        }
    }

    private void commitMetadataOwner(ISVNEditor editor, String id) throws Exception {
        HashSet<Integer> ids = new HashSet<Integer>();
        ids.add(Integer.valueOf(id));
        AbstractMetadata metadata = this.context.getBean(IMetadataUtils.class).findOne(id);
        User user = (User)this.context.getBean(UserRepository.class).findById((Object)metadata.getSourceInfo().getOwner()).get();
        Element xml = new Element("results").addContent((Content)new Element("record").addContent((Content)new Element("metadataid").setText(id)).addContent((Content)new Element("userid").setText("" + user.getId())).addContent((Content)new Element("name").setText(user.getName())).addContent((Content)new Element("surname").setText(user.getSurname())).addContent((Content)new Element("email").setText(user.getEmail())).addContent((Content)new Element("email").setText(user.getEmail())));
        String now = Xml.getString((Element)xml);
        if (this.exists(id + "/owner.xml")) {
            Element ownerPrevVersion = this.getFile(id, "owner.xml");
            String old = Xml.getString((Element)ownerPrevVersion);
            if (!old.equals(now)) {
                SvnUtils.modifyFile(editor, id + "/owner.xml", old.getBytes(Constants.ENCODING), now.getBytes(Constants.ENCODING));
                if (Log.isDebugEnabled((String)"geonetwork.svnmanager")) {
                    Log.debug((String)"geonetwork.svnmanager", (Object)("Ownership of metadata " + id + " was updated"));
                }
            }
        } else {
            SvnUtils.addFile(editor, id + "/owner.xml", now.getBytes(Constants.ENCODING));
            if (Log.isDebugEnabled((String)"geonetwork.svnmanager")) {
                Log.debug((String)"geonetwork.svnmanager", (Object)("Ownership of metadata " + id + " was added"));
            }
        }
    }

    private void commitMetadataPrivileges(ISVNEditor editor, String id) throws Exception {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        OperationAllowedRepository operationAllowedRepository = (OperationAllowedRepository)applicationContext.getBean(OperationAllowedRepository.class);
        GroupRepository groupRepository = (GroupRepository)applicationContext.getBean(GroupRepository.class);
        OperationRepository operationRepository = (OperationRepository)applicationContext.getBean(OperationRepository.class);
        Sort sort = SortUtils.createSort((SingularAttribute[])new SingularAttribute[]{OperationAllowed_.id, OperationAllowedId_.operationId});
        Specification hasMetadataId = OperationAllowedSpecs.hasMetadataId((int)Integer.valueOf(id));
        List opsAllowed = operationAllowedRepository.findAll(hasMetadataId, sort);
        Element privs = new Element("response");
        for (OperationAllowed operationAllowed : opsAllowed) {
            Element record = new Element("record");
            OperationAllowedId operationAllowedId = operationAllowed.getId();
            record.addContent((Content)new Element("group_id").setText(Integer.toString(operationAllowedId.getGroupId())));
            Group group = (Group)groupRepository.findById((Object)operationAllowedId.getGroupId()).get();
            record.addContent((Content)new Element("group_name").setText(group.getName()));
            Operation operation = (Operation)operationRepository.findById((Object)operationAllowedId.getOperationId()).get();
            record.addContent((Content)new Element("operation_id").setText(Integer.toString(operationAllowedId.getOperationId())));
            record.addContent((Content)new Element("operation_name").setText(operation.getName()));
            privs.addContent((Content)record);
        }
        String now = Xml.getString((Element)privs);
        if (this.exists(id + "/privileges.xml")) {
            Element privsPrevVersion = this.getFile(id, "privileges.xml");
            String old = Xml.getString((Element)privsPrevVersion);
            if (!old.equals(now)) {
                SvnUtils.modifyFile(editor, id + "/privileges.xml", old.getBytes(Constants.ENCODING), now.getBytes(Constants.ENCODING));
                if (Log.isDebugEnabled((String)"geonetwork.svnmanager")) {
                    Log.debug((String)"geonetwork.svnmanager", (Object)("Privileges of metadata " + id + " were updated"));
                }
            }
        } else {
            SvnUtils.addFile(editor, id + "/privileges.xml", now.getBytes(Constants.ENCODING));
            if (Log.isDebugEnabled((String)"geonetwork.svnmanager")) {
                Log.debug((String)"geonetwork.svnmanager", (Object)("Privileges of metadata " + id + " were added"));
            }
        }
    }

    private boolean exists(String filePath) throws SVNException {
        SVNRepository repo = this.getRepository();
        SVNNodeKind nodeKind = repo.checkPath(filePath, -1L);
        return nodeKind == SVNNodeKind.FILE || nodeKind == SVNNodeKind.DIR;
    }

    private static class SvnTask {
        Set<String> ids;
        String sessionLogMessage;

        private SvnTask() {
        }
    }
}

