/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fao.geonet.Constants;
import org.fao.geonet.exceptions.TermNotFoundException;
import org.fao.geonet.kernel.AllQueryResultsTable;
import org.fao.geonet.kernel.KeywordBean;
import org.fao.geonet.kernel.Thesaurus;
import org.fao.geonet.kernel.ThesaurusFinder;
import org.fao.geonet.kernel.search.keyword.KeywordRelation;
import org.fao.geonet.languages.IsoLanguagesMapper;
import org.fao.geonet.utils.Log;
import org.locationtech.jts.util.Assert;
import org.openrdf.model.GraphException;
import org.openrdf.model.URI;
import org.openrdf.sesame.config.AccessDeniedException;
import org.openrdf.sesame.config.ConfigurationException;
import org.openrdf.sesame.query.MalformedQueryException;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.QueryResultsTable;
import org.openrdf.sesame.repository.local.LocalRepository;
import org.springframework.beans.factory.annotation.Autowired;

public class AllThesaurus
extends Thesaurus {
    public static final String FNAME = "allThesaurus";
    public static final String SEPARATOR = "@@@";
    static final String TYPE = "external";
    static final String DNAME = "none";
    public static final String ALL_THESAURUS_KEY = "external.none.allThesaurus";
    static final String TITLE = "All Keywords";
    private static final String URI_CODE_PREFIX = "http://org.fao.geonet.thesaurus.all/";
    @Autowired
    private ThesaurusFinder thesaurusFinder;
    @Autowired
    private IsoLanguagesMapper isoLangMapper;
    private String downloadUrl;
    private String keywordUrl;
    private List<String> allThesaurusExclude = new ArrayList<String>();

    public void init(String siteUrl) {
        this.downloadUrl = this.buildDownloadUrl(FNAME, TYPE, DNAME, siteUrl);
        this.keywordUrl = this.buildKeywordUrl(FNAME, TYPE, DNAME, siteUrl);
    }

    public static String buildKeywordUri(KeywordBean actualWord) {
        return AllThesaurus.buildKeywordUri(actualWord.getThesaurusKey(), actualWord.getUriCode());
    }

    @VisibleForTesting
    static String buildKeywordUri(String thesaurusKey, String uri) {
        try {
            thesaurusKey = URLEncoder.encode(thesaurusKey, Constants.ENCODING);
            return URI_CODE_PREFIX + thesaurusKey + SEPARATOR + uri;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void setThesaurusFinder(ThesaurusFinder thesaurusFinder) {
        this.thesaurusFinder = thesaurusFinder;
    }

    public void setIsoLangMapper(IsoLanguagesMapper isoLangMapper) {
        this.isoLangMapper = isoLangMapper;
    }

    public List<String> getAllThesaurusExclude() {
        return this.allThesaurusExclude;
    }

    public void setAllThesaurusExclude(List<String> allThesaurusExclude) {
        this.allThesaurusExclude = allThesaurusExclude;
    }

    @Override
    public String getKey() {
        return ALL_THESAURUS_KEY;
    }

    @Override
    public String getDname() {
        return DNAME;
    }

    @Override
    public String getFname() {
        return FNAME;
    }

    @Override
    public Path getFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public String getDate() {
        return "";
    }

    @Override
    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    @Override
    public String getKeywordUrl() {
        return this.keywordUrl;
    }

    @Override
    public void retrieveThesaurusInformation() {
    }

    @Override
    public synchronized LocalRepository getRepository() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized Thesaurus setRepository(LocalRepository repository) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized Thesaurus initRepository() throws ConfigurationException, IOException {
        return this;
    }

    @Override
    public synchronized QueryResultsTable performRequest(final String query) throws IOException, MalformedQueryException, QueryEvaluationException, AccessDeniedException {
        final IdentityHashMap allResults = Maps.newIdentityHashMap();
        this.onThesauri(null, new Function<Thesaurus, Void>(){

            @Nullable
            public Void apply(@Nonnull Thesaurus input) {
                try {
                    QueryResultsTable queryResultsTable = input.performRequest(query);
                    if (queryResultsTable.getRowCount() > 0) {
                        allResults.put(input, queryResultsTable);
                    }
                }
                catch (IOException | AccessDeniedException | MalformedQueryException | QueryEvaluationException e) {
                    throw new RuntimeException(e);
                }
                return null;
            }
        });
        return new AllQueryResultsTable(allResults);
    }

    @Override
    public boolean hasConceptScheme(String uri) {
        return false;
    }

    @Override
    public synchronized URI addElement(KeywordBean keyword) throws IOException, AccessDeniedException, GraphException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized Thesaurus removeElement(KeywordBean keyword) throws MalformedQueryException, QueryEvaluationException, IOException, AccessDeniedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized Thesaurus removeElement(String namespace, String code) throws AccessDeniedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized Thesaurus removeElement(String uri) throws AccessDeniedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized URI updateElement(KeywordBean keyword, boolean replace) throws AccessDeniedException, IOException, MalformedQueryException, QueryEvaluationException, GraphException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized boolean isFreeCode(final String namespace, final String code) throws AccessDeniedException {
        return this.onThesauri(true, new Function<Thesaurus, Boolean>(){

            @Nullable
            public Boolean apply(Thesaurus thesaurus) {
                try {
                    if (!thesaurus.isFreeCode(namespace, code)) {
                        return false;
                    }
                }
                catch (AccessDeniedException accessDeniedException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    @Override
    public Thesaurus updateCode(KeywordBean bean, String newcode) throws AccessDeniedException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized Thesaurus updateCode(String namespace, String oldcode, String newcode) throws AccessDeniedException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized Thesaurus updateCodeByURI(String olduri, String newuri) throws AccessDeniedException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeConceptScheme(String thesaurusTitle, String namespace) throws IOException, AccessDeniedException, GraphException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IsoLanguagesMapper getIsoLanguageMapper() {
        return this.isoLangMapper;
    }

    @Override
    public synchronized void addRelation(String subject, KeywordRelation related, String relatedSubject) throws AccessDeniedException, IOException, MalformedQueryException, QueryEvaluationException, GraphException {
        throw new UnsupportedOperationException();
    }

    @Override
    public KeywordBean getKeyword(String uri, String ... languages) {
        DecomposedAllUri decomposedAllUri = new DecomposedAllUri(uri);
        Thesaurus thesaurus = this.thesaurusFinder.getThesaurusByName(decomposedAllUri.thesaurusKey);
        KeywordBean keyword = thesaurus.getKeyword(decomposedAllUri.keywordUri, languages);
        this.updateKeywordBeanThesaurusInfo(keyword);
        return keyword;
    }

    private KeywordBean updateKeywordBeanThesaurusInfo(KeywordBean keyword) {
        keyword.setUriCode(AllThesaurus.buildKeywordUri(keyword));
        keyword.setThesaurusInfo(this);
        return keyword;
    }

    @Override
    public boolean hasKeyword(String uri) {
        DecomposedAllUri decomposedAllUri = new DecomposedAllUri(uri);
        Thesaurus thesaurus = this.thesaurusFinder.getThesaurusByName(decomposedAllUri.thesaurusKey);
        return thesaurus.hasKeyword(decomposedAllUri.keywordUri);
    }

    @Override
    public List<KeywordBean> getRelated(String uri, KeywordRelation request, String ... languages) {
        DecomposedAllUri decomposedAllUri = new DecomposedAllUri(uri);
        Thesaurus thesaurus = this.thesaurusFinder.getThesaurusByName(decomposedAllUri.thesaurusKey);
        return Lists.transform(thesaurus.getRelated(decomposedAllUri.keywordUri, request, languages), (Function)new Function<KeywordBean, KeywordBean>(){

            @Nullable
            public KeywordBean apply(@Nullable KeywordBean keywordBean) {
                return AllThesaurus.this.updateKeywordBeanThesaurusInfo(keywordBean);
            }
        });
    }

    @Override
    public boolean hasKeywordWithLabel(final String label, final String langCode) {
        return this.onThesauri(false, new Function<Thesaurus, Boolean>(){

            @Nullable
            public Boolean apply(Thesaurus thesaurus) {
                if (thesaurus.hasKeywordWithLabel(label, langCode)) {
                    return true;
                }
                return null;
            }
        });
    }

    private <R> R onThesauri(R defaultVal, Function<Thesaurus, R> function) {
        for (Thesaurus thesaurus : this.thesaurusFinder.getThesauriMap().values()) {
            Object result;
            if (ALL_THESAURUS_KEY.equals(thesaurus.getKey()) || this.allThesaurusExclude.contains(thesaurus.getKey()) || (result = function.apply((Object)thesaurus)) == null) continue;
            return (R)result;
        }
        return defaultVal;
    }

    @Override
    public KeywordBean getKeywordWithLabel(final String label, final String langCode) {
        KeywordBean result = this.onThesauri(null, new Function<Thesaurus, KeywordBean>(){

            @Nullable
            public KeywordBean apply(@Nonnull Thesaurus thesaurus) {
                try {
                    return AllThesaurus.this.updateKeywordBeanThesaurusInfo(thesaurus.getKeywordWithLabel(label, langCode));
                }
                catch (TermNotFoundException e) {
                    return null;
                }
            }
        });
        if (result == null) {
            throw new TermNotFoundException(label);
        }
        return result;
    }

    @Override
    public synchronized void clear() throws IOException, AccessDeniedException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public FileTime getLastModifiedTime() {
        long lastModified = -1L;
        for (Thesaurus thesaurus : this.thesaurusFinder.getThesauriMap().values()) {
            long thesLastModified;
            if (thesaurus.getKey().equals(ALL_THESAURUS_KEY) || (thesLastModified = thesaurus.getLastModifiedTime().toMillis()) <= lastModified) continue;
            lastModified = thesLastModified;
        }
        if (Log.isDebugEnabled((String)"geonetwork.thesaurus")) {
            Log.debug((String)"geonetwork.thesaurus", (Object)("external.none.allThesaurus has lastModified of: " + lastModified));
        }
        return FileTime.fromMillis(lastModified);
    }

    @Override
    public String getDefaultNamespace() {
        try {
            Iterator<Thesaurus> iterator = this.thesaurusFinder.getThesauriMap().values().iterator();
            Thesaurus thesaurus = null;
            while (iterator.hasNext() && ALL_THESAURUS_KEY.equals((thesaurus = iterator.next()).getKey())) {
                thesaurus = null;
            }
            if (thesaurus != null) {
                return URI_CODE_PREFIX + URLEncoder.encode(thesaurus.getDefaultNamespace(), Constants.ENCODING);
            }
            return null;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static final class DecomposedAllUri {
        private static final Pattern URI_DECOMPOSER = Pattern.compile(Pattern.quote("http://org.fao.geonet.thesaurus.all/") + "(.+)" + "@@@" + "(.+)");
        public final String thesaurusKey;
        public final String keywordUri;

        public DecomposedAllUri(String allUri) {
            Matcher matcher = URI_DECOMPOSER.matcher(allUri);
            Assert.isTrue((boolean)matcher.matches(), (String)(allUri + "is not an 'all' keyword"));
            try {
                this.thesaurusKey = URLDecoder.decode(matcher.group(1), Constants.ENCODING);
                this.keywordUri = URLDecoder.decode(matcher.group(2), Constants.ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return "DecomposedAllUri{thesaurusKey='" + this.thesaurusKey + '\'' + ", keywordUri='" + this.keywordUri + '\'' + '}';
        }
    }
}

