/*
 * Decompiled with CFR 0.152.
 */
package jeeves.guiservices.session;

import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.domain.Profile;
import org.jdom.Content;
import org.jdom.Element;

public class Get
implements Service {
    String groupName;
    HashSet<String> outFields;

    @Override
    public void init(Path appPath, ServiceConfig params) throws Exception {
        this.groupName = params.getValue("group");
        List<Element> l = params.getChildren("outFields", "field");
        if (l != null) {
            this.outFields = new HashSet();
            for (Element field : l) {
                this.outFields.add(field.getName());
            }
        }
    }

    @Override
    public Element exec(Element params, ServiceContext context) throws Exception {
        Map group;
        UserSession session = context.getUserSession();
        Element sEl = Get.getSessionAsXML(session);
        if (session != null && this.groupName != null && (group = (Map)session.getProperty(this.groupName)) != null) {
            Element gEl = new Element(this.groupName);
            for (Element child : group.values()) {
                if (this.outFields != null && !this.outFields.contains(child.getName())) continue;
                gEl.addContent((Content)((Element)child.clone()));
            }
            sEl.addContent((Content)gEl);
        }
        return sEl;
    }

    public static Element getSessionAsXML(UserSession session) {
        Element sEl = new Element("session");
        if (session != null) {
            String sUsername = session.getUsername();
            String sName = session.getName();
            String sSurname = session.getSurname();
            Profile sProfile = session.getProfile();
            if (sUsername == null) {
                sUsername = Profile.Guest.name();
            }
            if (sName == null) {
                sName = sUsername;
            }
            if (sSurname == null) {
                sSurname = "";
            }
            if (sProfile == null) {
                sProfile = Profile.Guest;
            }
            Element userId = new Element("userId").addContent(session.getUserId());
            Element username = new Element("username").addContent(sUsername);
            Element name = new Element("name").addContent(sName);
            Element surname = new Element("surname").addContent(sSurname);
            Element profile = new Element("profile").addContent(sProfile.name());
            sEl.addContent((Content)userId).addContent((Content)username).addContent((Content)name).addContent((Content)surname).addContent((Content)profile);
        }
        return sEl;
    }
}

