/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tile.impl.bing;

import org.geotools.tile.TileIdentifier;
import org.geotools.tile.impl.ZoomLevel;
import org.geotools.tile.impl.bing.BingTileUtil;

public class BingTileIdentifier
extends TileIdentifier {
    public BingTileIdentifier(int x, int y, ZoomLevel zoomLevel, String serviceName) {
        super(x, y, zoomLevel, serviceName);
    }

    @Override
    public BingTileIdentifier getRightNeighbour() {
        return new BingTileIdentifier(TileIdentifier.arithmeticMod(this.getX() + 1, this.getZoomLevel().getMaxTilePerRowNumber()), this.getY(), this.getZoomLevel(), this.getServiceName());
    }

    @Override
    public BingTileIdentifier getLowerNeighbour() {
        return new BingTileIdentifier(this.getX(), TileIdentifier.arithmeticMod(this.getY() + 1, this.getZoomLevel().getMaxTilePerRowNumber()), this.getZoomLevel(), this.getServiceName());
    }

    @Override
    public String getId() {
        return this.getServiceName() + "_" + this.getCode();
    }

    @Override
    public String getCode() {
        return BingTileUtil.tileXYToQuadKey(this.getX(), this.getY(), this.getZ());
    }
}

