/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.internal.function.radix;

import java.util.function.Consumer;
import tech.units.indriya.internal.function.calc.Calculator;
import tech.units.indriya.internal.function.radix.Radix;

public class MixedRadixSupport {
    private final Radix[] radices;

    public MixedRadixSupport(Radix[] radices) {
        this.radices = radices;
    }

    public void visitRadixNumbers(Number trailingRadixValue, Consumer<Number> numberVisitor) {
        Number total = trailingRadixValue;
        for (int i = 0; i < this.radices.length; ++i) {
            Radix radix = this.radices[this.invertIndex(i)];
            boolean fractionalRemainder = i == 0;
            Number[] divideAndRemainder = radix.divideAndRemainder(total, !fractionalRemainder);
            Number remainder = divideAndRemainder[1];
            numberVisitor.accept(remainder);
            total = divideAndRemainder[0];
        }
        numberVisitor.accept(total);
    }

    public Number sumMostSignificant(Number[] values) {
        int maxAllowedValueIndex = values.length - 1;
        Number sum = values[0];
        for (int i = 0; i < this.radices.length; ++i) {
            sum = this.radices[i].multiply(sum);
            if (i >= maxAllowedValueIndex) continue;
            sum = Calculator.of(sum).add(values[i + 1]).peek();
        }
        return sum;
    }

    private int invertIndex(int index) {
        return this.radices.length - index - 1;
    }
}

