/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import org.geotools.data.QueryCapabilities;
import org.geotools.jdbc.JDBCFeatureSource;
import org.geotools.jdbc.NullPrimaryKey;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;

class JDBCQueryCapabilities
extends QueryCapabilities {
    JDBCFeatureSource source;

    public JDBCQueryCapabilities(JDBCFeatureSource source) {
        this.source = source;
    }

    @Override
    public boolean supportsSorting(SortBy[] sortAttributes) {
        if (super.supportsSorting(sortAttributes)) {
            return true;
        }
        for (SortBy sortBy : sortAttributes) {
            SortOrder sortOrder;
            if (SortBy.NATURAL_ORDER == sortBy || SortBy.REVERSE_ORDER == sortBy) {
                return !(this.source.getPrimaryKey() instanceof NullPrimaryKey);
            }
            PropertyName propertyName = sortBy.getPropertyName();
            if (this.supportsPropertySorting(propertyName, sortOrder = sortBy.getSortOrder())) continue;
            return false;
        }
        return true;
    }

    protected boolean supportsPropertySorting(PropertyName propertyName, SortOrder sortOrder) {
        AttributeDescriptor descriptor = (AttributeDescriptor)propertyName.evaluate((Object)this.source.getSchema());
        if (descriptor == null) {
            String attName = propertyName.getPropertyName();
            descriptor = this.source.getSchema().getDescriptor(attName);
        }
        return descriptor != null && !Geometry.class.isAssignableFrom(descriptor.getType().getBinding());
    }

    @Override
    public boolean isReliableFIDSupported() {
        return !(this.source.getPrimaryKey() instanceof NullPrimaryKey);
    }

    @Override
    public boolean isOffsetSupported() {
        return this.source.getDataStore().getSQLDialect().isLimitOffsetSupported();
    }

    @Override
    public boolean isUseProvidedFIDSupported() {
        return true;
    }
}

