/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.resultset;

import java.io.OutputStream;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.ResultSet;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.resultset.rw.ResultSetWriterXML;
import org.apache.jena.riot.resultset.rw.ResultsWriter;
import org.apache.jena.sparql.resultset.OutputBase;
import org.apache.jena.sparql.util.Context;

public class XMLOutput
extends OutputBase {
    protected String stylesheetURL = null;
    protected boolean includeXMLinst = true;

    public static void setStylesheetURL(Context cxt, String stylesheetURL) {
        cxt.set(ResultSetWriterXML.xmlStylesheet, stylesheetURL);
    }

    public static void setXMLinstruction(Context cxt, Boolean value) {
        if (value != null) {
            cxt.set(ResultSetWriterXML.xmlInstruction, value);
        } else {
            cxt.unset(ResultSetWriterXML.xmlInstruction);
        }
    }

    public XMLOutput() {
    }

    public XMLOutput(String stylesheetURL) {
        this.setStylesheetURL(stylesheetURL);
    }

    public XMLOutput(boolean includeXMLinst) {
        this.setIncludeXMLinst(includeXMLinst);
    }

    public XMLOutput(boolean includeXMLinst, String stylesheetURL) {
        this.setStylesheetURL(stylesheetURL);
        this.setIncludeXMLinst(includeXMLinst);
    }

    @Override
    public void format(OutputStream out, ResultSet resultSet) {
        Context cxt = this.setup();
        ResultsWriter.create().context(cxt).lang(ResultSetLang.SPARQLResultSetXML).write(out, resultSet);
    }

    public boolean getIncludeXMLinst() {
        return this.includeXMLinst;
    }

    public void setIncludeXMLinst(boolean includeXMLinst) {
        this.includeXMLinst = includeXMLinst;
    }

    public String getStylesheetURL() {
        return this.stylesheetURL;
    }

    public void setStylesheetURL(String stylesheetURL) {
        this.stylesheetURL = stylesheetURL;
    }

    @Override
    public void format(OutputStream out, boolean booleanResult) {
        Context cxt = this.setup();
        ResultsWriter.create().context(cxt).lang(ResultSetLang.SPARQLResultSetXML).build().write(out, booleanResult);
    }

    private Context setup() {
        Context cxt = ARQ.getContext().copy();
        XMLOutput.setStylesheetURL(cxt, this.stylesheetURL);
        XMLOutput.setXMLinstruction(cxt, this.includeXMLinst);
        return cxt;
    }
}

